#!/usr/bin/perl
use strict;

our $system_data_dir;

use lib './lib';
require './lib/cgi-lib.pl';
require './btsconf.pl';
use BTS::Statics;
use BTS::Common;
use BTS::Error;
use BTS::FileLocker;
use BTS::Session;
use BTS::HttpRequest;
use BTS::BBSCore;
use KCatch;

use Jcode;
use HTTP::Lite;
use Digest::MD5  qw(md5 md5_hex md5_base64);

&initialize_statics($system_data_dir);

our %input;
&ReadParse(\%input);

our %cookie = &recv_cookie();
our %config;
our $filelocker = BTS::FileLocker->new($locker_temp_dir);
our $cellphone_type = &get_cellphone_type();

#$cellphone_type = "docomo";

if($filelocker->lock($config_file)){
	%config = &read_config($config_file);
	$filelocker->unlock($config_file);
}else{
	&print_error_html($btserr_title, btserr(400));
}

our $bbscore = BTS::BBSCore->new(
	$filelocker,
	$ownerlist_file,
	$boarderlist_file,
	$threadlist_file,
	$threaderlist_file,
	$datfile_dir,
	$config{'MaxLog'}
); 

if($config{'EnableTop'} eq 1){
	require './lib/bts_menu.pl';
	&execute_bts_menu();
}else{
	require './lib/bts_share.pl';
	if($cellphone_type eq 'pc'){
		require './lib/bts_pc.pl';
		&execute_bts_pc();
	}else{
		require './lib/bts_cell.pl';
		&execute_bts_cell();
	}
}

