#!/usr/bin/perl
use strict;

our $system_data_dir;

use lib './lib';
require './lib/cgi-lib.pl';
require './btsconf.pl';
use BTS::Statics;
use BTS::Common;
use BTS::Error;
use BTS::Session;
use BTS::FileLocker;
use BTS::BBSCore;
use BTS::HttpRequest;
use BTS::Logger;
use KCatch;

use Jcode;
use Digest::MD5  qw(md5 md5_hex md5_base64);

&initialize_statics($system_data_dir);

our %input;
&ReadParse(\%input);

our %cookie = &recv_cookie();
our $session_id = $cookie{'SID'};
our $session;
our %config;
our $filelocker = BTS::FileLocker->new($locker_temp_dir);
if($filelocker->lock($config_file)){
	%config = &read_config($config_file);
	$filelocker->unlock($config_file);
}else{
	&print_error_html($btserr_title, btserr(400));
}

our $bbscore = BTS::BBSCore->new(
	$filelocker,
	$ownerlist_file,
	$boarderlist_file,
	$threadlist_file,
	$threaderlist_file,
	$datfile_dir,
	$config{'MaxLog'}
); 
our $logger = BTS::Logger->new(
	$filelocker,
	$log_dir,
	$config{'LogHoldDays'}
);

if($session_id ne ''){
	$session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
}else{
	$session_id = md5_hex(localtime() . $ENV{'REMOTE_ADDR'});
	$session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
}

if($config{'PasswordHash'} eq ''){
	if($input{'mode'} eq 'init' and ($input{'pass1'} eq $input{'pass2'}) and $input{'pass1'} ne ''){
		&init_datafiles();
	}else{
		&show_passinit_html();
	}
}elsif($input{'mode'} eq 'login'){
	my $phash = md5_hex($input{'pass1'});
	my $remote_host = &get_remote_host();
	if($config{'LastAccess'} eq $remote_host and $config{'FailCount'} > 3){
		&print_error_html($btserr_title, btserr(345));
		exit;
	}
	if($phash eq $config{'PasswordHash'}){
		#$logger->write("login: " . $remote_host);
		$session->write('Password', $input{'pass1'});
		&show_basics_html();
	}else{
		# pX[h~X
		$logger->write("login failed: " . $remote_host);
		if($config{'LastAccess'} ne $remote_host){
			$config{'LastAccess'} = $remote_host;
			$config{'FailCount'} = 1;
		}else{
			$config{'FailCount'}++;
		}
		if($filelocker->lock($config_file)){
			&write_config($config_file, %config);
			$filelocker->unlock($config_file);
		}	
		&show_passentry_html();
	}
}elsif($input{'mode'} eq 'logout'){
	$session->clear();
	$session_id = md5_hex(localtime() . $ENV{'REMOTE_ADDR'});
	&show_passentry_html();
}else{

	my $pass = $session->read('Password');
	if($config{'PasswordHash'} eq md5_hex($pass)){
		my $page = $input{'page'};
		if($page eq ''){
			$page = 1;
		}
		if($page eq 1){
			&show_basics_html();
		}elsif($page eq 2){
			&show_toppage_html();
		}elsif($page eq 3){
			&show_bbs_html();
		}elsif($page eq 4){
			&show_customhtml_menu_html();
		}elsif($page eq 5){
			&show_customhtml_board_html();
		}elsif($page eq 6){
			&show_customhtml_bbs_html();
		}elsif($page eq 7){
			&show_redirect_html();
		}elsif($page eq 8){
			&show_manage_boarder_html();
		}elsif($page eq 9){
			&show_manage_threader_html();
		}elsif($page eq 10){
			&show_urltable_bts_html();
		}elsif($page eq 11){
			&show_iptable_bts_html();
		}elsif($page eq 12){
			&show_iptable_user_html();
		}elsif($page eq 13){
			&show_log_html();
		}elsif($page eq 14){
			&show_passwordmod_html();
		}
	}else{
		&show_passentry_html();
	}
}

sub print_header_html {
	my ($title) = @_[0];
	&send_cookie('SID', $session_id);
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><head><title>$title</title>";
	print "<link rel=\"stylesheet\" href=\"resource/css/admin.css\" type=\"text/css\" />";
	print "<meta http-equiv=\"Pragma\" content=\"no-cache\">";
	print "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">";
	print "<meta http-equiv=\"Expires\" content=\"Thu, 01 Dec 1994 16:00:00 GMT\">";
	print "</head><bodyvalign=\"center\">\n";
}

sub print_footer_html {
	print "</body></html>";
}

sub print_error_html {
	my ($title, $message, $return_title, $return_url) = @_;
	&print_header_html($title);

	print "<table width=100% height=100%><tr><td align=center valign=center>";
	print "<table class=\"toplevel\" width=400>";
	print "<tr><th align=\"center\">$title</th></tr>";
	print "<tr><td align=\"center\"><br>$message<br><br>";
	if($return_title eq ""){$return_title="߂";}
	if($return_url eq ""){$return_url="Javascript:history.back();";}
	print "<a href=\"$return_url\">$return_title</a>";
	print "</td></tr></table>";
	print "</td></tr></table>";

	&print_footer_html();
}

sub print_menuheader_html {
	my $page = $input{'page'};
	if($page eq ''){$page=1;}
	my @class=();
	foreach (my $i=1;$i<14;$i++){
		if($i eq $page){
			$class[$i] = "selection_menu";
		}else{
			$class[$i] = "";
		}
	}

	print "<table width=\"800\" height=\"100%\" align=\"center\" class=\"toplevel\">";
	print "<tr><th height=\"20\" colspan=\"2\">BTS Ǘ</th></tr>";
	print "<tr><td valign=\"top\" width=\"150\">";
	print "<table width=\"100%\" height=\"100%\" class=\"inner\">";
	print "<tr><td height=\"10\" class=\"$class[1]\"><a href=\"$admin_module_name?page=1\">{ݒ</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[2]\"><a href=\"$admin_module_name?page=2\">gbvy[Wݒ</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[3]\"><a href=\"$admin_module_name?page=3\">fݒ</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[4]\"><a href=\"$admin_module_name?page=4\">HTMLݒ(ꗗ)</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[5]\"><a href=\"$admin_module_name?page=5\">HTMLݒ(Xꗗ)</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[6]\"><a href=\"$admin_module_name?page=6\">HTMLݒ(f)</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[7]\"><a href=\"$admin_module_name?page=7\">HTMLݒ(])</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[8]\"><a href=\"$admin_module_name?page=8\">{[_[Ǘ</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[9]\"><a href=\"$admin_module_name?page=9\">Xb_[Ǘ</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[10]\"><a href=\"$admin_module_name?page=10\">ANZXiURL)</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[11]\"><a href=\"$admin_module_name?page=11\">ANZXiBTS)</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[12]\"><a href=\"$admin_module_name?page=12\">ANZXi[U)</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[13]\"><a href=\"$admin_module_name?page=13\">O</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[14]\"><a href=\"$admin_module_name?page=14\">pX[hύX</a></td></tr>";
	print "<tr><td height=\"10\" class=\"$class[15]\"><a href=\"$admin_module_name?mode=logout\">OAEg</a></td></tr>";
	print "<tr><td></td></tr>";
	print "</table>";

	print "</td>";
	print "<td align=\"center\" valign=\"top\">";
	print "<table width=\"100%\" height=\"100%\" class=\"inner\">";
	print "<tr><td align=\"left\" valign=\"top\">";
}

sub print_menufooter_html {
	print "</td></tr>";
	print "</table>";
	print "</td>";
	print "</tr>";
	print "</table>";
	print "</body>";
	print "</html>";
}

sub show_passinit_html {
	&print_header_html();

	print $config{"PasswordHash"};

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<table width=100% height=100%><tr><td align=center valign=center>";
	print "<table width=400 class=\"toplevel\">";
	print "<tr><th><b>BTS pX[h쐬</b></th></tr>";
	print "<tr><td align=\"center\">";
	print "pX[hݒ肳Ă܂Bݒ肵܂̂œ͂ĉBYĂ܂ꍇ͏C͏o܂̂ŒӂĉB<br><br>";
	print "<table class=\"inner\">";
	print "<tr><td>pX[h</td><td><input type=\"password\" name=\"pass1\" size=\"30\"></td></tr>";
	print "<tr><td>pX[hmFp</td><td><input type=\"password\" name=\"pass2\" size=\"30\"></td></tr>";
	print "</table><br>";
	print "<input type=\"submit\" value=\"pX[ho^\" class=\"button01\"><br><br>";
	print "<input type=\"hidden\" name=\"mode\" value=\"init\">";
	print "</td></tr>";
	print "</table>";
	print "</td></tr></table>";
	print "</form>";

	&print_footer_html();
}

sub init_datafiles {
	# lݒ
	my $homeurl;
	$config{'PasswordHash'} = md5_hex($input{'pass1'});
	$homeurl = 'http://' . $ENV{'HTTP_HOST'};
	if($ENV{'SERVER_PORT'} ne '80'){
		$homeurl .= ':' . $ENV{'SERVER_PORT'};
	}
	my @path = split(/\//, $ENV{'REQUEST_URI'});
	foreach (my $i=0;$i<@path - 1;$i++){
		$homeurl .= $path[$i] . '/';
	}

	# f[^fBNg̍쐬
	umask(0);
	if(!-e $system_data_dir){
		mkdir $system_data_dir, 0777;
	}
	if(!-e $system_data_dir){
		&print_error_html($btserr_title, btserr(320));
		return;
	}
	if(!-e $locker_temp_dir){
		mkdir $locker_temp_dir, 0777;
	}
	if(!-e $locker_temp_dir){
		&print_error_html($btserr_title, btserr(321));
		return;
	}
	if(!-e $datfile_dir){
		mkdir $datfile_dir, 0777;
	}
	if(!-e $datfile_dir){
		&print_error_html($btserr_title, btserr(322));
		return;
	}
	if(!-e $log_dir){
		mkdir $log_dir, 0777;
	}
	if(!-e $log_dir){
		&print_error_html($btserr_title, btserr(322));
		return;
	}

	# t@C쐬eXg
	my $text;
	&write_textfile("$system_data_dir/dummy.dat", "dummytext");
	if(!-f "$system_data_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(323));
		return;
	}
	$text = &read_textfile("$system_data_dir/dummy.dat");
	if($text ne "dummytext"){
		&print_error_html($btserr_title, btserr(324));
		return;
	}
	&write_textfile("$locker_temp_dir/dummy.dat", "dummytext");
	if(!-f "$locker_temp_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(325));
		return;
	}
	$text = &read_textfile("$locker_temp_dir/dummy.dat");
	if($text ne "dummytext"){
		&print_error_html($btserr_title, btserr(326));
		return;
	}
	&write_textfile("$datfile_dir/dummy.dat", "dummytext");
	if(!-f "$datfile_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(327));
		return;
	}
	$text = &read_textfile("$datfile_dir/dummy.dat");
	if($text ne "dummytext"){
		&print_error_html($btserr_title, btserr(328));
		return;
	}
	&write_textfile("$log_dir/dummy.dat", "dummytext");
	if(!-f "$log_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(327));
		return;
	}
	$text = &read_textfile("$log_dir/dummy.dat");
	if($text ne "dummytext"){
		&print_error_html($btserr_title, btserr(328));
		return;
	}

	# t@C폜eXg
	unlink "$system_data_dir/dummy.dat";
	unlink "$locker_temp_dir/dummy.dat";
	unlink "$datfile_dir/dummy.dat";
	unlink "$log_dir/dummy.dat";
	if(-e "$system_data_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(329));
		return;
	}
	if(-e "$locker_temp_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(330));
		return;
	}
	if(-e "$datfile_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(331));
		return;
	}
	if(-e "$log_dir/dummy.dat"){
		&print_error_html($btserr_title, btserr(331));
		return;
	}
	
	# subject.txt eXg
	&write_textfile("$subject_txt_file", "dummytext");
	if(!-f "$subject_txt_file"){
		&print_error_html($btserr_title, btserr(332));
		return;
	}
	$text = &read_textfile("$subject_txt_file");
	if($text ne "dummytext"){
		&print_error_html($btserr_title, btserr(333));
		return;
	}
	unlink($subject_txt_file);

	# t@C

	$config{'HomeUrl'} = 		$homeurl;
	$config{'MaxLog'} = 		1000;
	$config{'EnableTop'} = 		0;
	$config{'DefaultName'} = 	'';
	$config{'ThreaderCount'} = 	0;
	$config{'HomeTitle'} = 		'No Title';

	$config{'HaveOwner'} = 		0;
	$config{'NodeClass'} = 		'none';

	$config{'ProxyHost'} = 		'';
	$config{'ProxyPort'} = 		'';

	$config{'LogHoldDays'} =	7;

	my %categorys = &get_category_hash();
	my $category_code;
	foreach $category_code(sort keys %categorys){
		$config{'CategoryLimit_' . $category_code} = 5;
	}

	&write_config($config_file, %config);

	# j[wb_l
	my $html;
	$html = "<a href=\"$register_module_name\" target=\"_blank\">[o^]</a>";
	$html .= "<a href=\"$admin_module_name\" target=\"_blank\">[Ǘ]</a>";
	if(open(IO, ">$htmlhead_menupc_file")){
		print IO $html;
		close(IO);
	}

	# _CNgy[Wl
	$html = "<html><body><a href=\"%URL%\">%URL%</a></body></html>";
	if(open(IO, ">$redirect_temp_pc")){
		print IO $html;
		close(IO);
	}
	if(open(IO, ">$redirect_temp_cell")){
		print IO $html;
		close(IO);
	}	

	&print_error_html("", "Ƀf[^܂B", "OC", "$admin_module_name");
}

sub show_passentry_html {
	&print_header_html();

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<table width=100% height=100%><tr><td align=center valign=center>";
	print "<table width=400 class=\"toplevel\">";
	print "<tr><th align=\"center\"><b>BTS pX[hF</b></th></tr>";
	print "<tr><td align=\"center\">";
	print "<br>Ǘʂ֐iނɂ̓OCKvłB<br><br>";
	print "pX[h<input type=\"password\" name=\"pass1\" size=\"30\"><br><br>";
	print "<input type=\"submit\" value=\"OC\" class=\"button01\"><br><br>";
	print "<input type=\"hidden\" name=\"mode\" value=\"login\">";
	print "</td></tr>";
	print "</table>";
	print "</td></tr></table>";
	print "</form>";

	&print_footer_html();
}

sub show_basics_html {
	my $page = 1;
	my $sig = $input{'sig'};

	if(!$filelocker->lock($config_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';
	if($input{'mode'} eq 'update'){
		my $url = $input{'homeurl'};
		if(substr($url,0,7) ne 'http://'){
			$url = 'http://' . $url;
		}
		if(substr($url, length($url)-1, 1) ne '/'){
			$url .= '/';
		} 
		$config{'HomeUrl'} = $url;
		$config{'ProxyHost'} = $input{'proxyhost'};
		$config{'ProxyPort'} = $input{'proxyport'};

		&write_config($config_file, %config);
		$message = 'XV';
	}
	if($input{'mode'} eq 'delete'){
		if($bbscore->open($bbscore->{mode_owner})){
			foreach (my $i=0;$i<$bbscore->get_count();$i++){
				my $rec = $bbscore->get_from_index($i);
				if(get_url_sig($rec->{url}) eq $sig){
					$bbscore->delete_rec($i);
					last;
				}
			}
			if($bbscore->get_count() eq 0){
				$config{'NodeClass'} = 'none';
				$config{'HaveOwner'} = 0;
				&write_config($config_file, %config);
			}
			$bbscore->close();
			$message = 'E';
		}
	}

	print "MessageF$message";
	print "<hr></hr>";

	my %categorys = &get_category_hash();
	my $nodeclass;
	if($config{'EnableTop'} eq 1){
		$nodeclass = 'owner';
	}else{
		$nodeclass = $config{'NodeClass'};
	}

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "ݒuTCgURL<br>";
	print "<input type=\"text\" name=\"homeurl\" value=\"" . $config{'HomeUrl'} . "\" size=\"70\"><br>";
	print "<br>";
	print "Proxy Server Host<br>";
	print "<input type=\"text\" name=\"proxyhost\" value=\"" . $config{'ProxyHost'} . "\" size=\"70\"><br>";
	print "Proxy Server Port<br>";
	print "<input type=\"text\" name=\"proxyport\" value=\"" . $config{'ProxyPort'} . "\" size=\"10\"><br>";
	print "<br>";
	print "<input type=\"submit\" value=\"XV\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";
	print "TCg<br>";
	print "NodeClassF" . $nodeclass . "<br>";
	print "<br>";
	print "QI[i[ꗗ<br>";

	if($bbscore->open($bbscore->{mode_owner})){
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			my $num = $i + 1;
			my $sig = get_url_sig($rec->{url});
			print "<form method=\"POST\" action=\"$admin_module_name\">";
			print "<table class=\"toplevel\">";
			print "<th colspan=2>No.$num</th>";
			print "<tr><td>OwnerTitle($num)F</td><td>" . $rec->{title} . "</td></tr>";
			print "<tr><td>OwnerCategory($num)F</td><td>" . $categorys{$rec->{category}} . "</td></tr>";
			print "<tr><td>OwnerSubCategory($num)F</td><td>" . $rec->{subcategory} . "</td></tr>";
			print "<tr><td>OwnerUrl($num)F</td><td>" . $rec->{url} . "</td></tr>";
			print "<tr><td>OwnerBM($num)F</td><td>" . $rec->{bm} . "</td></tr>";
			print "<tr><td>OwnerTM($num)F</td><td>" . $rec->{tm} . "</td></tr>";
			print "<tr><td colspan=2><input type=submit value=\"E\"></td></tr>";
			print "</table>";
			print "<input type=hidden name=\"page\" value=\"$page\">";
			print "<input type=hidden name=\"mode\" value=\"delete\">";
			print "<input type=hidden name=\"sig\" value=\"$sig\">";
			print "</form>";
		}
		$bbscore->close();
	}

	print "</table>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($config_file);
}

sub show_toppage_html {
	my $page = $input{'page'};

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'update'){
		if($config{'HaveOwner'}){
			$message = 'ɃNCAgƂĎQłB';
		}else{
			if($input{'enabletop'} eq 1){
				$config{'EnableTop'} = 1;
			}else{
				$config{'EnableTop'} = 0;
			}

			$config{'HomeTitle'} = 	jcode($input{'hometitle'})->sjis;

			my %categorys = &get_category_hash();
			my $category_code;
			foreach $category_code(sort keys %categorys){
				my $count = $input{'limit_' . $category_code};
				if($count eq ""){$count=0;};
				$config{'CategoryLimit_' . $category_code} = $count;
			}
			if($filelocker->lock($config_file)){
				&write_config($config_file, %config);
				$filelocker->unlock($config_file);
				$message = 'XV';
			}else{
				$message = 't@CɃANZXo܂B';
			}
		}
	}

	print "MessageF$message";
	print "<hr></hr>";

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	if($config{"EnableTop"} eq 1){
		print "<input type=\"checkbox\" name=\"enabletop\" value=\"1\" checked>";
	}else{
		print "<input type=\"checkbox\" name=\"enabletop\" value=\"1\">";
	}
	print "gbvy[W@\\\Lɂ<br>";
	print "<br>";
	print "^Cg<br>";
	print "<input type=\"text\" name=\"hometitle\" value=\"" . $config{"HomeTitle"} . "\" size=\"30\"><br>";
	print "<br>";

	print "JeSʎ󂯓\\\<br>";

	print "<table class=\"inner\">";
	print "<tr>";

	my $col = 0;
	my %categorys = &get_category_hash();
	my $category_code;
	foreach $category_code(sort keys %categorys){
		print "<td>" . $categorys{$category_code} . "</td>";
		print "<td><input type=\"text\" name=\"limit_$category_code\" value=\"" . $config{'CategoryLimit_' . $category_code} . "\" size=\"10\"></td>";
		
		$col++;
		if($col eq 3){
			print "</tr><tr>";
			$col = 0;
		}
	}
	if($col eq 1){print "<td></td><td></td>";}
	if($col eq 2){print "<td></td>";}

	print "</tr></table>";
	print "<br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();
}

sub show_bbs_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($config_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'update'){
		$config{'DefaultName'} = jcode($input{'defaultname'})->sjis;
		my $count = $input{'maxlog'};
		if($count < 100){
			$message = "100ȉ͐ݒo܂B";
		}else{
			$config{'MaxLog'} = $count;
			&write_config($config_file, %config);
			$message = 'XV';
		}
	}

	print "MessageF$message";
	print "<hr></hr>";

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<table class=\"inner\"><tr><td>ő働OێF</td>";
	print "<td><input type=\"text\" name=\"maxlog\" value=\"" . $config{"MaxLog"} . "\"></td></tr>";
	print "<tr><td>̖OF</td>";
	print "<td><input type=\"text\" name=\"defaultname\" value=\"" . $config{"DefaultName"} . "\">@JeSI[i[̂݌ʂ</td></tr>";
	print "</table>";

	print "<input type=\"submit\" value=\"XV\" class=\"button01\"><br>";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($config_file);
}

sub show_customhtml_menu_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($sig_htmlheadfoot_menu)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $message = '';

	if($input{'mode'} eq 'update'){
		my $html;
		$html = jcode($input{'head_pc'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlhead_menupc_file, $html);
		$html = jcode($input{'foot_pc'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlfoot_menupc_file, $html);
		$html = jcode($input{'head_cell'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlhead_menucell_file, $html);
		$html = jcode($input{'foot_cell'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlfoot_menucell_file, $html);
		$message = 'XV';
	}

	my $htmlhead_menupc = &read_textfile($htmlhead_menupc_file);
	my $htmlfoot_menupc = &read_textfile($htmlfoot_menupc_file);
	my $htmlhead_menucell = &read_textfile($htmlhead_menucell_file);
	my $htmlfoot_menucell = &read_textfile($htmlfoot_menucell_file);
	$filelocker->unlock($sig_htmlheadfoot_menu);

	&print_header_html();
	&print_menuheader_html();

	print "MessageF$message";
	print "<hr></hr>";
	
	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "wb_(PC)<br>";
	print "<textarea name=\"head_pc\" cols=\"70\" rows=\"8\">$htmlhead_menupc</textarea><br>";
	print "tb^(PC)<br>";
	print "<textarea name=\"foot_pc\" cols=\"70\" rows=\"8\">$htmlfoot_menupc</textarea><br>";
	print "wb_(g)<br>";
	print "<textarea name=\"head_cell\" cols=\"70\" rows=\"8\">$htmlhead_menucell</textarea><br>";
	print "tb^(g)<br>";
	print "<textarea name=\"foot_cell\" cols=\"70\" rows=\"8\">$htmlfoot_menucell</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();
}

sub show_customhtml_board_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($sig_htmlheadfoot_board)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $message = '';

	if($input{"mode"} eq "update"){
		my $html;
		$html = jcode($input{"head_pc"})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlhead_boardpc_file, $html);
		$html = jcode($input{"foot_pc"})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlfoot_boardpc_file, $html);
		$html = jcode($input{"head_cell"})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlhead_boardcell_file, $html);
		$html = jcode($input{"foot_cell"})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlfoot_boardcell_file, $html);
		$message = "XV";
	}

	my $htmlhead_boardpc = &read_textfile($htmlhead_boardpc_file);
	my $htmlfoot_boardpc = &read_textfile($htmlfoot_boardpc_file);
	my $htmlhead_boardcell = &read_textfile($htmlhead_boardcell_file);
	my $htmlfoot_boardcell = &read_textfile($htmlfoot_boardcell_file);
	$filelocker->unlock($sig_htmlheadfoot_board);

	&print_header_html();
	&print_menuheader_html();

	print "MessageF$message";
	print "<hr></hr>";

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "wb_(PC)<br>";
	print "<textarea name=\"head_pc\" cols=\"70\" rows=\"8\">$htmlhead_boardpc</textarea><br>";
	print "tb^(PC)<br>";
	print "<textarea name=\"foot_pc\" cols=\"70\" rows=\"8\">$htmlfoot_boardpc</textarea><br>";
	print "wb_(g)<br>";
	print "<textarea name=\"head_cell\" cols=\"70\" rows=\"8\">$htmlhead_boardcell</textarea><br>";
	print "tb^(g)<br>";
	print "<textarea name=\"foot_cell\" cols=\"70\" rows=\"8\">$htmlfoot_boardcell</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();
}

sub show_customhtml_bbs_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($sig_htmlheadfoot_bbs)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $message = '';

	if($input{'mode'} eq 'update'){
		my $html;
		$html = jcode($input{'head_pc'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlhead_bbspc_file, $html);
		$html = jcode($input{'foot_pc'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlfoot_bbspc_file, $html);
		$html = jcode($input{'head_cell'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlhead_bbscell_file, $html);
		$html = jcode($input{'foot_cell'})->sjis;
		$html =~ s/\r//g;
		&write_textfile($htmlfoot_bbscell_file, $html);
		$message = 'XV';
	}

	my $htmlhead_bbspc = &read_textfile($htmlhead_bbspc_file);
	my $htmlfoot_bbspc = &read_textfile($htmlfoot_bbspc_file);
	my $htmlhead_bbscell = &read_textfile($htmlhead_bbscell_file);
	my $htmlfoot_bbscell = &read_textfile($htmlfoot_bbscell_file);
	$filelocker->unlock($sig_htmlheadfoot_bbs);

	&print_header_html();
	&print_menuheader_html();

	print "MessageF$message";
	print "<hr></hr>";

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "wb_(PC)<br>";
	print "<textarea name=\"head_pc\" cols=\"70\" rows=\"8\">$htmlhead_bbspc</textarea><br>";
	print "tb^(PC)<br>";
	print "<textarea name=\"foot_pc\" cols=\"70\" rows=\"8\">$htmlfoot_bbspc</textarea><br>";
	print "wb_(g)<br>";
	print "<textarea name=\"head_cell\" cols=\"70\" rows=\"8\">$htmlhead_bbscell</textarea><br>";
	print "tb^(g)<br>";
	print "<textarea name=\"foot_cell\" cols=\"70\" rows=\"8\">$htmlfoot_bbscell</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();
}

sub show_redirect_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($redirect_temp_pc)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	if(!$filelocker->lock($redirect_temp_cell)){
		$filelocker->unlock($redirect_temp_pc);
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{"mode"} eq "update"){
		my $html;
		$html = jcode($input{"html_pc"});
		$html =~ s/\r//g;
		&write_textfile($redirect_temp_pc, $html);
		$html = jcode($input{"html_cell"});
		$html =~ s/\r//g;
		&write_textfile($redirect_temp_cell, $html);
		$message = "XV";
	}

	print "MessageF$message";
	print "<hr></hr>";
	
	my $html_pc = &read_textfile($redirect_temp_pc);
	my $html_cell = &read_textfile($redirect_temp_cell);

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "]y[W(PC)<br>";
	print "<textarea name=\"html_pc\" cols=\"70\" rows=\"15\">$html_pc</textarea><br>";
	print "]y[W(g)<br>";
	print "<textarea name=\"html_cell\" cols=\"70\" rows=\"15\">$html_cell</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($redirect_temp_pc);
	$filelocker->unlock($redirect_temp_cell);
}

sub show_manage_boarder_html {
	my $page = $input{'page'};
	my $url = $input{'url'};
	my $mode = $input{'mode'};

	my $message = '';
	&print_header_html();
	&print_menuheader_html();

	if($mode eq 'delete'){
		if($url eq ""){
			$message = 'p[^[G[';
		}else{
			if($bbscore->open($bbscore->{mode_board})){
				foreach(my $i=0;$i<$bbscore->get_count();$i++){
					my $rec = $bbscore->get_from_index($i);
					if($rec->{url} eq $url){
						$bbscore->delete_rec($i);
						last;
					}
				}
				$bbscore->close();

				$message = '폜';
			}else{
				$message = btserr(400);
			}
		}
	}

	print "MessageF$message";
	print "<hr></hr>";
	
	print "<table width=100% class=\"toplevel\">";
	print "<tr>";
	print "<th>Category</th><th>URL</th><th>LastUpdate<br>Threader/Fail</th><th>*</th>";
	print "</tr>";
	if($bbscore->open($bbscore->{mode_board})){
		my %categorys = &get_category_hash();
		my $category_code;
		foreach $category_code(sort keys %categorys){
			foreach(my $i=0;$i<$bbscore->get_count();$i++){
				my $rec = $bbscore->get_from_index($i);
				if($rec->{category} eq $category_code){
					print "<tr>";
					print "<td>" . $categorys{$category_code} . "<br>" . $rec->{subcategory} . "</td>";
					print "<td>" . $rec->{url} . "<br>" . $rec->{bm} . "/" . $rec->{tm} . "</td>";
					print "<td>" . $rec->{time} . "<br>" . $rec->{threaders} . "/" . $rec->{fail} . "</td>";
					print "<td><a href=\"$admin_module_name?page=$page&mode=delete&url=" . $rec->{url} . "\">[del]</a></td>";
					print "</tr>";
				}
			}
		}
		$bbscore->close();
	}
	print "</table>";

	&print_menufooter_html();
	&print_footer_html();
}

sub show_manage_threader_html {
	my $page = $input{'page'};
	my $url = $input{'url'};
	my $mode = $input{'mode'};

	if(!$filelocker->lock($threaderlist_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $message = '';
	&print_header_html();
	&print_menuheader_html();

	if($mode eq "delete"){
		if($url eq ""){
			$message = 'p[^[G[';
		}else{
			if($bbscore->open($bbscore->{mode_threader})){
				foreach (my $i=0;$i<$bbscore->get_count();$i++){
					my $rec = $bbscore->get_from_index($i);
					if($rec->{url} eq $url){
						$bbscore->delete_rec($i);
						last;
					}
				}
				$bbscore->close();
				$message = '폜';
			}else{
				$message = btserr(400);
			}
		}
	}

	print "MessageF$message";
	print "<hr></hr>";
	
	print "<table width=100% class=\"toplevel\">";
	print "<tr>";
	print "<th>URL</th><th>Fail</th><th>*</th>";
	print "</tr>";
	if($bbscore->open($bbscore->{mode_threader})){
		my %categorys = &get_category_hash();
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			print "<tr>";
			print "<td>" . $rec->{url} . "(" . $rec->{bm} . "/" . $rec->{tm} . ")</td>";
			print "<td>" . $rec->{fail} . "</td>";
			print "<td><a href=\"$admin_module_name?page=$page&mode=delete&url=" . $rec->{url} . "\">[del]</a></td>";
			print "</tr>";
		}
	}
	print "</table>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($threaderlist_file);
}

sub show_urltable_bts_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($urltable_bts_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	if(!$filelocker->lock($compiled_urltable_bts_file)){
		$filelocker->unlock($urltable_bts_file);
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'remote'){
		if($config{'HaveOwner'} eq 0){
			$message = 'I[i[ɏĂ܂B';
		}else{
			my $local_sid = md5_hex(localtime);
			my $local_session = BTS::Session->new($filelocker, $session_temp_file, $local_sid);

			my $param = "ver=2&method=gett&sid=$local_sid&type=urlbts";
			$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
			my $tracker_url = $config{'OwnerUrl'}.$config{'OwnerTM'};
			my ($res_code, $res_message) = &httprequest($tracker_url, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
			my $checked = $local_session->read('checked');
			if($res_code ne 200 or $checked ne 1){
				$message = "Remote Error($res_message)";
			}else{
				$input{'urltable_bts'} = "# copy from: [" . $config{'OwnerUrl'} . "]";
				$input{'urltable_bts'} .= ' ' . &format_string_time(&get_localtime_string());
				$input{'urltable_bts'} .= "\n";
				$input{'urltable_bts'} .= $local_session->read('table');
				$input{'mode'} = 'update';
			}
			$local_session->clear();
		}
	}
	if($input{'mode'} eq 'update'){
		my $urltable = jcode($input{'urltable_bts'})->sjis;
		$urltable =~ s/\r//g;
		my $compiled_urltable = &compile_iptable($urltable);
		&write_textfile($urltable_bts_file, $urltable);
		&write_textfile($compiled_urltable_bts_file, $compiled_urltable);
		$message = 'XV';
	}

	print "MessageF$message";
	print "<hr></hr>";
	
	my $urltable = &read_textfile($urltable_bts_file);

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "BTSpʐMURLۃXg<br>";
	print "<textarea name=\"urltable_bts\" cols=\"70\" rows=\"30\">$urltable</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";
	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<input type=\"submit\" value=\"I[i[擾\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"remote\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($urltable_bts_file);
	$filelocker->unlock($compiled_urltable_bts_file);
}

sub show_iptable_bts_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($iptable_bts_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	if(!$filelocker->lock($compiled_iptable_bts_file)){
		$filelocker->unlock($iptable_bts_file);
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'remote'){
		if($config{'HaveOwner'} eq 0){
			$message = 'I[i[ɏĂ܂B';
		}else{
			my $local_sid = md5_hex(localtime);
			my $local_session = BTS::Session->new($filelocker, $session_temp_file, $local_sid);

			my $param = "ver=2&method=gett&sid=$local_sid&type=ipbts";
			$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
			my $tracker_url = $config{'OwnerUrl'}.$config{'OwnerTM'};
			my ($res_code, $res_message) = &httprequest($tracker_url, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
			my $checked = $local_session->read('checked');
			if($res_code ne 200 or $checked ne 1){
				$message = "Remote Error($res_message)";
			}else{
				$input{'iptable_bts'} = "# copy from: [" . $config{'OwnerUrl'} . "]";
				$input{'iptable_bts'} .= ' ' . &format_string_time(&get_localtime_string());
				$input{'iptable_bts'} .= "\n";
				$input{'iptable_bts'} .= $local_session->read('table');
				$input{'mode'} = 'update';
			}
			$local_session->clear();
		}
	}
	if($input{'mode'} eq 'update'){
		my $iptable = jcode($input{'iptable_bts'})->sjis;
		$iptable =~ s/\r//g;
		my $compiled_iptable = &compile_iptable($iptable);
		&write_textfile($iptable_bts_file, $iptable);
		&write_textfile($compiled_iptable_bts_file, $compiled_iptable);
		$message = 'XV';
	}

	print "MessageF$message";
	print "<hr></hr>";
	
	my $iptable = &read_textfile($iptable_bts_file);

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "BTSpʐMIPAhXۃXg<br>";
	print "<textarea name=\"iptable_bts\" cols=\"70\" rows=\"30\">$iptable</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";
	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<input type=\"submit\" value=\"I[i[擾\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"remote\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($iptable_bts_file);
	$filelocker->unlock($compiled_iptable_bts_file);
}

sub show_iptable_user_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($iptable_user_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	if(!$filelocker->lock($compiled_iptable_user_file)){
		$filelocker->unlock($iptable_user_file);
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'remote'){
		if($config{'HaveOwner'} eq 0){
			$message = 'I[i[ɏĂ܂B';
		}else{
			my $local_sid = md5_hex(localtime);
			my $local_session = BTS::Session->new($filelocker, $session_temp_file, $local_sid);

			my $param = "ver=2&method=gett&sid=$local_sid&type=ipuser";
			$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
			my $tracker_url = $config{'OwnerUrl'}.$config{'OwnerTM'};
			my ($res_code, $res_message) = &httprequest($tracker_url, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
			my $checked = $local_session->read('checked');
			if($res_code ne 200 or $checked ne 1){
				$message = "Remote Error($res_message)";
			}else{
				$input{'iptable_user'} = "# copy from: [" . $config{'OwnerUrl'} . "]";
				$input{'iptable_user'} .= ' ' . &format_string_time(&get_localtime_string());
				$input{'iptable_user'} .= "\n";
				$input{'iptable_user'} .= $local_session->read('table');
				$input{'mode'} = 'update';
			}
			$local_session->clear();
		}
	}
	if($input{'mode'} eq 'update'){
		my $iptable = jcode($input{'iptable_user'})->sjis;
		$iptable =~ s/\r//g;
		my $compiled_iptable = &compile_iptable($iptable);
		&write_textfile($iptable_user_file, $iptable);
		&write_textfile($compiled_iptable_user_file, $compiled_iptable);
		$message = 'XV';
	}

	print "MessageF$message";
	print "<hr></hr>";
	
	my $iptable = &read_textfile($iptable_user_file);

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "ʃ[U[IPAhXۃXg<br>";
	print "<textarea name=\"iptable_user\" cols=\"70\" rows=\"30\">$iptable</textarea><br>";
	print "<input type=\"submit\" value=\"XV\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";
	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<input type=\"submit\" value=\"I[i[擾\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"remote\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($iptable_user_file);
	$filelocker->unlock($compiled_iptable_user_file);
}

sub show_log_html {
	my $page = $input{'page'};
	my $date = $input{'date'};
	if($date eq ''){
		$date = substr(&get_localtime_string(), 0, 8);
	}

	if(!$filelocker->lock($config_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'update'){
		my $days = $input{'logholddays'};
		if($days eq ''){$days = 0;}
		if($days ne $config{'LogHoldDays'}){
			$config{'LogHoldDays'} = $days;
			&write_config($config_file, %config);
			$message = 'ێXV܂B';
		}
	}
	
	# tI쐬
	my $dayoffset = 0;
	my $dateselect = "<select name=\"date\">";
	foreach (my $i=0;$i<$config{'LogHoldDays'};$i++){
		my $wdate = substr(&get_localtime_string($dayoffset), 0, 8);
		my $year = substr($wdate, 0, 4);
		my $mon = substr($wdate, 4, 2);
		my $day = substr($wdate, 6, 2);
		if($wdate eq $date){
			$dateselect .= "<option value=\"$wdate\" selected>$year/$mon/$day</option>";
		}else{
			$dateselect .= "<option value=\"$wdate\">$year/$mon/$day</option>";
		}
		$dayoffset -= (60 * 60 * 24);
	}
	$dateselect .= "</select>";

	print "MessageF$message";
	print "<hr></hr>";

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "<table width=100%>";
	print "<tr>";
	print "<td>$dateselect</td>";
	print "<td></td>";
	print "<td>Oێ:<input type=text name=logholddays size=3 value=".$config{"LogHoldDays"}."></td>";
	print "<td><input type=submit value=\"XV\"></td>";
	print "</tr></table>";
	print "</form>";

	print "<table width=100%>";
	print "<tr><td>time</td><td>message</td></tr>";

	if($logger->open($date)){
		foreach (my $i=0;$i<$logger->get_count();$i++){
			my $rec = $logger->get_from_index($i);
			print "<tr><td>";
			print &format_string_time($rec->{time});
			print "</td><td>";
			print $rec->{text};
			print "</td></tr>";
		}
		$logger->close();
	}
	print "</table>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($config_file);
}


sub show_passwordmod_html {
	my $page = $input{'page'};

	if(!$filelocker->lock($config_file)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html();
	&print_menuheader_html();

	my $message = '';

	if($input{'mode'} eq 'update'){
		if($password_lock eq 1){
			$message = 'pX[h̓bNĂ܂B';
		}else{
			if($input{'pass1'} eq $input{'pass2'} and $input{'pass1'} ne ''){
				$session->write('Password', $input{'pass1'});
				$config{'PasswordHash'} = md5_hex($input{'pass1'});
				&write_config($config_file, %config);
				$message = 'pX[hC܂B';
			}else{
				$message = '͓esłB';
			}
		}
	}

	print "MessageF$message";
	print "<hr></hr>";

	print "<form method=\"POST\" action=\"$admin_module_name\">";
	print "<table class=\"inner\">";
	print "<tr><td>VpX[hF</td>";
	print "<td><input type=\"password\" name=\"pass1\"></td></tr>";
	print "<tr><td>mFppX[hF</td>";
	print "<td><input type=\"password\" name=\"pass2\"></td></tr>";
	print "</table>";
	print "<input type=\"submit\" value=\"ύX\" class=\"button01\">";
	print "<input type=\"hidden\" name=\"page\" value=\"$page\">";
	print "<input type=\"hidden\" name=\"mode\" value=\"update\">";
	print "</form>";

	&print_menufooter_html();
	&print_footer_html();

	$filelocker->unlock($config_file);
}

sub compile_iptable {
	# ̂߂ɋۃXgRg폜
	my $table = @_[0];
	my @lines = split(/\n/, $table);
	my $text = '';
	my $line;
	foreach $line(@lines){
		my @sentence = split(/#/, $line);
		$line = $sentence[0];
		$line =~ s/\r//g;
		$line =~ s/^\s+//;
		$line =~ s/\s+$//;
		if(length($line) > 0){
 			# sjis GXP[v
			$line =~ s/([\x21\x24-\x26\x28-\x2b\x2e\x2f\x3f\x40\x5b-\x5e\x7b-\x7d])/\\$1/g if $line;
   			$text .= "$line\n";
		}
	}
	return $text;
}

