#!/usr/bin/perl
use strict;

our $system_data_dir;

use lib './lib';
require './lib/cgi-lib.pl';
require './btsconf.pl';
use BTS::Statics;
use BTS::Common;
use BTS::Error;
use BTS::Session;
use BTS::FileLocker;
use BTS::HttpRequest;
use BTS::BBSCore;
use KCatch;

use Jcode;
use Digest::MD5  qw(md5 md5_hex md5_base64);

&initialize_statics($system_data_dir);

our %input;
&ReadParse(\%input);

our %config;
our $filelocker = BTS::FileLocker->new($locker_temp_dir);
if($filelocker->lock($config_file)){
	%config = &read_config($config_file);
	$filelocker->unlock($config_file);
}else{
	&print_error_html($btserr_title, btserr(400));
	exit;
}

our $bbscore = BTS::BBSCore->new(
	$filelocker,
	$ownerlist_file,
	$boarderlist_file,
	$threadlist_file,
	$threaderlist_file,
	$datfile_dir,
	$config{'MaxLog'}
); 

if($config{'EnableTop'} eq 1){
	if($input{'mode'} eq 'regcat'){
		&regist_category();
	}elsif($input{'mode'} eq 'regthreader'){
		&regist_threader();
	}else{
		&show_category_regist_html();
	}
}else{
	&print_error_html($btserr_title, btserr(334));
}

sub print_header_html {
	my ($title) = @_[0];
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><head><title>$title</title>";
	print "<link rel=\"stylesheet\" href=\"resource/css/admin.css\" type=\"text/css\" />";
	print "<meta http-equiv=\"Pragma\" content=\"no-cache\">";
	print "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">";
	print "<meta http-equiv=\"Expires\" content=\"Thu, 01 Dec 1994 16:00:00 GMT\">";
	print "</head><bodyvalign=\"center\">\n";
}

sub print_footer_html {
	print "</body></html>";
}

sub print_error_html {
	my ($title, $message, $return_title, $return_url) = @_;
	&print_header_html($title);

	print "<table width=100% height=100%><tr><td align=center valign=center>";
	print "<table class=\"toplevel\" width=400>";
	print "<tr><th align=\"center\">$title</th></tr>";
	print "<tr><td align=\"center\"><br>$message<br><br>";
	if($return_title eq ""){$return_title="߂";}
	if($return_url eq ""){$return_url="Javascript:history.back();";}
	print "<a href=\"$return_url\">$return_title</a>";
	print "</td></tr></table>";
	print "</td></tr></table>";

	&print_footer_html();
}

sub show_category_regist_html {
	my %categorys = &get_category_hash();

	# Xb_[JEg
	my %category_count;
	foreach my $category_code(sort keys %categorys){
		$category_count{$category_code} = 0;
	}
	if(!$bbscore->open($bbscore->{mode_board})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		$category_count{$rec->{category}}++;
	}

	my $category_owner_select = "<select name=\"category_owner\">";
	$category_owner_select .= "<option value=\"\" selected></option>";
	foreach my $category_code(sort keys %categorys){
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->{category} eq $category_code){
				$category_owner_select .= "<option value=\"" . $rec->{category} . ":" . $rec->{subcategory} . "\">";
				$category_owner_select .= $categorys{$rec->{category}} . ":" . $rec->{subcategory} . "(" . $rec->{threaders} . ")</option>";
			}
		}
	}
	$category_owner_select .= "</select>";
	$bbscore->close();

	my $category_select = "<select name=\"category\">";
	$category_select .= "<option value=\"\" selected></option>";
	foreach my $category_code(sort keys %categorys){
		$category_select .= "<option value=\"$category_code\">" . $categorys{$category_code} . "</option>";
	}
	$category_select .= "</select>";

	&print_header_html("BTSQo^");

	print "<table width=100% height=100%><tr><td align=\"center\" valign=\"top\">";
	print "<form method=\"POST\" action=\"btsregister.cgi\">";
	print "<table width=\"700\" class=\"toplevel\"><tr><th align=\"center\">JeSQo^</th></tr>";
	print "<tr><td>";

	print "<table class=\"inner\">";
	print "<tr><td>JeSF</td><td id=\"select_sub\">$category_owner_select</td></tr>";
	print "<tr><td>BTSgbJ[URLF</td><td><input type=\"text\" name=\"trackerurl\" size=\"80\" value=\"http://\"></td></tr>";
	print "</table>";
	print "<input type=\"submit\" value=\"o^\" class=\"button01\"><br>";
	print "<input type=\"hidden\" name=\"mode\" value=\"regthreader\"><br>";

	print "</td></tr></table>";
	print "</form>";

	print "<form method=\"POST\" action=\"btsregister.cgi\">";
	print "<table width=\"700\" class=\"toplevel\"><tr><th align=\"center\">JeSI[i[o^</th></tr>";
	print "<tr><td>";
	
	print "<table class=\"inner\">";
	print "<tr><td>JeSF</td><td>$category_select</td></tr>";
	print "<tr><td>JeSF</td><td><input type=\"text\" name=\"subcat\"></td></tr>";
	print "<tr><td>BTSgbJ[URLF</td><td><input type=\"text\" name=\"trackerurl\" size=\"80\" value=\"http://\"></td></tr>";
	print "</table>";
	print "<input type=\"submit\" value=\"o^\" class=\"button01\"><br>";
	print "<input type=\"hidden\" name=\"mode\" value=\"regcat\"><br>";

	print "JeSo^";

	print "<table width=\"100%\" class=\"inner\"><tr>";
	my $col = 0;
	foreach my $category_code(sort keys %categorys){
		print "<td>" . $categorys{$category_code} . "</td>";
		print "<td>" . $category_count{$category_code} . "/" . $config{'CategoryLimit_' . $category_code} . "</td>";
		
		$col++;
		if($col eq 4){
			print "</tr><tr>";
			$col = 0;
		}
	}
	if($col eq 1){print "<td></td><td></td>";}
	if($col eq 2){print "<td></td>";}
	print "</tr></table>";

	print "</td></tr></table>";
	print "</form>";
	print "$copyright</td></tr></table>";

	&print_footer_html();
}
sub regist_category {
	my $entry_category_code = $input{'category'};
	my $entry_subcategory_name = $input{'subcat'};
	my $entry_url = $input{'trackerurl'};

	$entry_subcategory_name = jcode($entry_subcategory_name)->sjis;

	if($entry_category_code eq ""){
		&print_error_html($btserr_title, btserr(335));
		return;
	}
	if(is_existed_category($entry_category_code) eq 0){
		&print_error_html($btserr_title, btserr(306));
		return;
	}
	if($entry_subcategory_name eq ""){
		&print_error_html($btserr_title, btserr(336));
		return;
	}
	if(length($entry_subcategory_name) > 18){
		&print_error_html($btserr_title, btserr(337));
		return;
	}
	if($entry_url eq ""){
		&print_error_html($btserr_title, btserr(338));
		return;
	}

	# o^󋵏Wv
	my %category_count;
	if(!$bbscore->open($bbscore->{mode_board})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my %categorys = &get_category_hash();
	foreach my $category_code(sort keys %categorys){
		$category_count{$category_code} = 0;
	}
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		$category_count{$rec->{category}}++;
	}
	$bbscore->close();

	if($config{'CategoryLimist_' . $entry_category_code} eq $category_count{$entry_category_code}){
		&print_error_html($btserr_title, btserr(339));
		return;
	}

	my $session_id = md5_hex(localtime);
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	$session->write('remote_tracker', $entry_url);
	$session->write('category_code', $entry_category_code);
	$session->write('subcategory_name', $entry_subcategory_name);

	my $param = "ver=2&method=rgct&sid=$session_id&cat=$entry_category_code&scat=$entry_subcategory_name&title=".$config{"HomeTitle"};
	$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest($entry_url, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		&print_error_html($btserr_title, btserr(340) . "($res_message)");
		return;
	}

	my $checked = $session->read('checked');
	if($checked ne 1){
		&print_error_html($btserr_title, btserr(304));
		return;
	}
	my $remote_url = $session->read('url');
	my $bm = $session->read('bm');
	my $tm = $session->read('tm');
	my $threader_count = $session->read('threader_count');

	if(!$bbscore->open($bbscore->{mode_board})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	# ɓo^Ăꍇ͋폜
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($rec->{url} eq $remote_url){
			$bbscore->delete_rec($i);
			last;
		}
	}

	# ǉ
	my $local_datetime = &get_localtime_string();
	$bbscore->append_rec(
		BTS::Record::Board->new(
			$entry_category_code,
			$entry_subcategory_name,
			$remote_url,
			$bm,
			$tm,
			$local_datetime,
			$threader_count,
			0
		)
	);

	$bbscore->close();
	$session->clear();

	&print_error_html('JeSo^', 'o^͐Ɋ܂B');
}

sub regist_threader {
	my @category_owner = split(/:/, $input{'category_owner'});
	my $entry_category_code = $category_owner[0];
	my $entry_subcategory_name = $category_owner[1];
	my $entry_url = $input{'trackerurl'};

	$entry_subcategory_name = jcode($entry_subcategory_name)->sjis;

	if($entry_category_code eq '' or $entry_subcategory_name eq ''){
		&print_error_html($btserr_title, btserr(335));
		return;
	}
	if(is_existed_category($entry_category_code) eq 0){
		&print_error_html($btserr_title, btserr(306));
		return;
	}
	if($entry_url eq ''){
		&print_error_html($btserr_title, btserr(338));
		return;
	}


	# ^[Qbg̃gbJ[ǂݍ
	if(!$bbscore->open($bbscore->{mode_board})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $boarder_url='';
	my $boarder_tm='';
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($rec->{category} eq $entry_category_code and $rec->{subcategory} eq $entry_subcategory_name){
			$boarder_url = $rec->{url};
			$boarder_tm = $rec->{tm};
			last;
		}
	}
	$bbscore->close();

	if($boarder_url eq '' or $boarder_tm eq ''){
		&print_error_html($btserr_title, btserr(306));
		return;
	}

	my $session_id = md5_hex(localtime);
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	$session->write('remote_tracker', $entry_url);
	$session->write('category_code', $entry_category_code);
	$session->write('subcategory_name', $entry_subcategory_name);

	my $param = "ver=2&method=rgth&sid=$session_id&target=$entry_url";
	$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest("$boarder_url$boarder_tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		&print_error_html($btserr_title, btserr(340) . "($res_message)");
		return;
	}

	my $checked = $session->read('checked');
	if($checked ne 1){
		&print_error_html($btserr_title, btserr(304));
		return;
	}
	my $threader_count = $session->read('threader_count');

	# Xb_[XV
	if(!$bbscore->open($bbscore->{mode_board})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($rec->{category} eq $entry_category_code and $rec->{subcategory} eq $entry_subcategory_name){
			$bbscore->update_rec($i, 'threaders', $threader_count);
			last;
		}
	}
	$bbscore->close();
	$session->clear();

	&print_error_html('JeSQ', 'o^͐Ɋ܂B');
}
