# BTS/BBSCore.pm
# status 0:idle 1:bbs opened 2:category opened 3:thread opened

package BTS::BBSCore;

use BTS::FileLocker;
use BTS::Record::Board;
use BTS::Record::Thread;
use BTS::Record::Response;
use BTS::Record::Threader;
use BTS::Record::Owner;

use strict;

my %btsbbserror = (
	200 => 'OK',
	400 => 'ANZXWĂ܂B΂炭҂ĂēxĂ݂ĉB',
	401 => 'ANZXK',
	500 => 'VXeG[',
	300 => 'p[^G[',
);

sub btsbbserr {
	my $code = @_[0];
	return "$code " . $btsbbserror{$code};
}

sub new {
	my $pkg = shift;
	my $hash = {
		btsfilelocker => shift,
		ownerlist_file => shift,
		boardlist_file => shift,
		threadlist_file => shift,
		threaderlist_file => shift,
		datfile_dir => shift,

		datalist => undef,
		status => 0,
		modify => 0,
		key => "",
		mode_board => 1,
		mode_thread => 2,
		mode_response => 3,
		mode_threader => 4,
		mode_owner => 5
	};

	bless $hash, $pkg;
}

sub last_error {
	my $self = shift;
	$self->{last_error};
}

sub open {
	my $self = shift;
	my $target = shift;
	my $key = shift;

	my $filelocker = $self->{btsfilelocker};
	my $ownerlist_file = $self->{ownerlist_file};
	my $boardlist_file = $self->{boardlist_file};
	my $threadlist_file = $self->{threadlist_file};
	my $threaderlist_file = $self->{threaderlist_file};
	my $datfile_dir = $self->{datfile_dir};

	if($target eq $self->{mode_board}){
		# bbs open
		if(!$filelocker->lock($boardlist_file)){
			$self->{last_error} = btsbbserr(400);
			return 0;
		}

		@{$self->{datalist}}=();
		if(open(IO, "<$boardlist_file")){
			foreach my $line(<IO>){
				my $rec = BTS::Record::Board->new();
				$rec->convert_from_text($line);
				push @{$self->{datalist}}, $rec;
			}
			close(IO);
		}
		$self->{last_error} = "";
		$self->{status} = $self->{mode_board};
		return 1;
	}elsif($target eq $self->{mode_thread}){
		# category open
		if(!$filelocker->lock($threadlist_file)){
			$self->{last_error} = btsbbserr(400);
			return 0;
		}
		@{$self->{datalist}}=();
		if(open(IO, "<$threadlist_file")){
			foreach my $line(<IO>){
				my $rec = BTS::Record::Thread->new();
				$rec->convert_from_text($line);
				push @{$self->{datalist}}, $rec;
			}
			close(IO);
		}
		$self->{last_error} = "";
		$self->{status} = $self->{mode_thread};
		return 1;
	}elsif($target eq $self->{mode_response}){
		# thread open
		my $filename = "$datfile_dir/$key.dat"; 
		my $filename_ext = "$datfile_dir/".$key.'_ext.dat'; 
		if(!$filelocker->lock($filename)){
			$self->{last_error} = btsbbserr(400);
			return 0;
		}

		@{$self->{datalist}}=();
		my @linelist=();
		my @linelist_ext=();
		if(open(IO, "<$filename")){
			foreach my $line(<IO>){
				push @linelist, $line;
			}
			close(IO);
		}
		if(open(IO, "<$filename_ext")){
			foreach my $line(<IO>){
				push @linelist_ext, $line;
			}
			close(IO);
		}
		foreach (my $i=0;$i<@linelist;$i++){
			my $rec = BTS::Record::Response->new();
			$rec->convert_from_text($linelist[$i]);
			$rec->convert_from_text_ex($linelist_ext[$i]);
			push @{$self->{datalist}}, $rec;
		}
		$self->{last_error} = "";
		$self->{status} = $self->{mode_response};
		$self->{key} = $key;
		return 1;
	}elsif($target eq $self->{mode_threader}){
		# threader open
		if(!$filelocker->lock($threaderlist_file)){
			$self->{last_error} = btsbbserr(400);
			return 0;
		}
		@{$self->{datalist}}=();
		if(open(IO, "<$threaderlist_file")){
			foreach my $line(<IO>){
				my $rec = BTS::Record::Threader->new();
				$rec->convert_from_text($line);
				push @{$self->{datalist}}, $rec;
			}
			close(IO);
		}
		$self->{last_error} = "";
		$self->{status} = $self->{mode_threader};
		return 1;
	}elsif($target eq $self->{mode_owner}){
		# threader open
		if(!$filelocker->lock($ownerlist_file)){
			$self->{last_error} = btsbbserr(400);
			return 0;
		}
		@{$self->{datalist}}=();
		if(open(IO, "<$ownerlist_file")){
			foreach my $line(<IO>){
				my $rec = BTS::Record::Owner->new();
				$rec->convert_from_text($line);
				push @{$self->{datalist}}, $rec;
			}
			close(IO);
		}
		$self->{last_error} = "";
		$self->{status} = $self->{mode_owner};
		return 1;
	}else{
		$self->{last_error} = btsbbserr(300);
		return 0;
	}
}

sub close {
	my $self = shift;

	my $filelocker = $self->{btsfilelocker};
	my $ownerlist_file = $self->{ownerlist_file};
	my $boardlist_file = $self->{boardlist_file};
	my $threadlist_file = $self->{threadlist_file};
	my $threaderlist_file = $self->{threaderlist_file};
	my $datfile_dir = $self->{datfile_dir};
	
	if($self->{status} eq 0){
		return 0;
	}

	# save modified data
	if($self->{modify} eq 1){
		if($self->{status} eq $self->{mode_board}){
			# save boardlist
			if(open(IO, ">$boardlist_file")){
				foreach my $rec(@{$self->{datalist}}){
					my $text = $rec->convert_to_text();
					print IO $text;
				}
				close(IO);
			}
		}elsif($self->{status} eq $self->{mode_thread}){
			# save threadlist
			if(open(IO, ">$threadlist_file")){
				foreach my $rec(@{$self->{datalist}}){
					my $text = $rec->convert_to_text();
					print IO $text;
				}
				close(IO);
			}
		}elsif($self->{status} eq $self->{mode_response}){
			# save datfile
			my $key = $self->{key};
			my $filename = "$datfile_dir/$key.dat";
			my $filename_ext = "$datfile_dir/".$key."_ext.dat";
			if(open(IO, ">$filename")){
				foreach my $rec(@{$self->{datalist}}){
					my $text = $rec->convert_to_text();
					print IO $text;
				}
				close(IO);
			}
			if(open(IO, ">$filename_ext")){
				foreach my $rec(@{$self->{datalist}}){
					my $text = $rec->convert_to_text_ex();
					print IO $text;
				}
				close(IO);
			}
		}elsif($self->{status} eq $self->{mode_threader}){
			# save threaderlist
			if(open(IO, ">$threaderlist_file")){
				foreach my $rec(@{$self->{datalist}}){
					my $text = $rec->convert_to_text();
					print IO $text;
				}
				close(IO);
			}
		}elsif($self->{status} eq $self->{mode_owner}){
			# save ownerlist
			if(open(IO, ">$ownerlist_file")){
				foreach my $rec(@{$self->{datalist}}){
					my $text = $rec->convert_to_text();
					print IO $text;
				}
				close(IO);
			}
		}
	}

	# unlock
	if($self->{status} eq $self->{mode_board}){
		$filelocker->unlock($boardlist_file);
	}elsif($self->{status} eq $self->{mode_thread}){
		$filelocker->unlock($threadlist_file);
	}elsif($self->{status} eq $self->{mode_response}){
		my $key = $self->{key};
		my $filename = "$datfile_dir/$key.dat";
		$filelocker->unlock($filename);
	}elsif($self->{status} eq $self->{mode_threader}){
		$filelocker->unlock($threaderlist_file);
	}elsif($self->{status} eq $self->{mode_owner}){
		$filelocker->unlock($ownerlist_file);
	}

	$self->{status} = 0;
	$self->{last_error} = "";
	$self->{datalist} = ();
	$self->{modify} = 0;
	return 1;
}

sub get_count {
	my $self = shift;
	my $count = @{$self->{datalist}};

	return $count;
}

sub get_from_index {
	my $self = shift;
	my $index = shift;

	my $rec = @{$self->{datalist}}[$index];
	$rec;
}

sub append_rec {
	my $self = shift;
	my $rec = shift;
	
	push @{$self->{datalist}}, $rec;
	$self->{modify} = 1;
	return 1;
}

sub insert_rec {
	my $self = shift;
	my $index = shift;
	my $rec = shift;

	splice @{$self->{datalist}}, $index, 0, $rec;
	$self->{modify} = 1;
	return 1;
}

sub update_rec {
	my $self = shift;
	my $index = shift;
	my $item = shift;
	my $value = shift;

	@{$self->{datalist}}[$index]->{$item} = $value;
	$self->{modify} = 1;
	return 1;
}

sub delete_rec {
	my $self = shift;
	my $index = shift;

	splice @{$self->{datalist}}, $index, 1;
	$self->{modify} = 1;
	return 1;
}

sub delete_thread_with_maxlog {
	my $self = shift;
	my $maxlog = shift;

	my $filelocker = $self->{btsfilelocker};
	my $boardlist_file = $self->{boardlist_file};
	my $threadlist_file = $self->{threadlist_file};
	my $datfile_dir = $self->{datfile_dir};

	if($self->{status} ne $self->{mode_thread}){
		return 0;
	}

	# delete over maxlog
	my $count = @{$self->{datalist}};
	if($count >= $maxlog){
		foreach (my $i=$maxlog;$i<=$count;$i++){
			my $rec = @{$self->{datalist}}[$i];
			my $key = $rec->{key};
			my $filename = "$datfile_dir/$key.dat";
			my $filename_ext = "$datfile_dir/$key" . "_ext.dat";
			unlink $filename;
			unlink $filename_ext;
		}
		splice @{$self->{datalist}}, $maxlog, $count - $maxlog;
		$self->{modify} = 1;
	}
	return 1;
}

sub get_thread_index_from_key {
	my $self = shift;
	my $key = shift;

	foreach (my $i=0;$i<@{$self->{datalist}};$i++){
		my $rec = @{$self->{datalist}}[$i];
		if($rec->{key} eq $key){
			return $i;
		}
	}
	return -1;
}

sub age_thread {
	my $self = shift;
	my $index = shift;
	my $age = shift;

	if($age eq 1){
		my $temp_rec = @{$self->{datalist}}[$index];
		for(my $j=$index;$j>0;$j--){
			@{$self->{datalist}}[$j] = @{$self->{datalist}}[$j-1];
		}
		@{$self->{datalist}}[0] = $temp_rec;
	}else{
		if($index > 0){
			my $temp_rec = @{$self->{datalist}}[$index-1];
			@{$self->{datalist}}[$index-1] = @{$self->{datalist}}[$index];
			@{$self->{datalist}}[$index] = $temp_rec;
		}
	}
	$self->{modify} = 1;
	return 1;
}

# DATt@C݊mF
sub response_exist {
	my $self = shift;
	my $key = shift;

	my $datfile_dir = $self->{datfile_dir};
	if(-f "$datfile_dir/$key.dat"){
		return 1;
	}else{
		return undef;
	}
}

# DATt@C폜
sub response_delete {
	my $self = shift;
	my $key = shift;

	my $datfile_dir = $self->{datfile_dir};
	my $filename = "$datfile_dir/$key.dat";
	my $filename_ext = "$datfile_dir/$key" . "_ext.dat";
	if(-f $filename){
		unlink $filename;
		unlink $filename_ext;
	}
}

sub build_subject_txt {
	my $self = shift;
	my $filename = shift;

	if($self->{status} ne 0){
		return 0;
	}

	my $filelocker = $self->{btsfilelocker};
	my $datfile_dir = $self->{datfile_dir};

	if(!$filelocker->lock($filename)){
		return 0;
	}

	if(!$self->open($self->{mode_thread})){
		$filelocker->unlock($filename);
	}

	my @temp_data = ();
	foreach (my $i=0;$i<$self->get_count();$i++){
		my $rec = $self->get_from_index($i);
		my $text = "";
		$text .= $rec->{url} . $datfile_dir . "/" . $rec->{key} . ".dat<>";
		$text .= $rec->{title} . " (" . $rec->{rescount} . ")<>";
		$text .= $rec->{url}.$rec->{bm} . "\n";
		push @temp_data, $text;
	}

	if(open(IO, ">$filename")){
		print IO @temp_data;
		close(IO);
	}
	
	$self->close();
	$filelocker->unlock($filename);

	return 1;
}

1;

