# BTS/Common.pm

package BTS::Common;

use BTS::TimeZone;
use Time::Local;
use Digest::MD5  qw(md5 md5_hex md5_base64);
use Exporter;
@ISA = (Exporter);
@EXPORT = qw(
	get_localtime_string
	get_formated_localtime_string
	format_string_time
	escape_html_tags
	get_category_hash
	is_existed_category
	read_timestamp
	write_timestamp
	erase_enter
	get_remote_host
	read_config
	write_config
	send_cookie
	recv_cookie
	get_crypted_name
	get_cellphone_type
	ipfilter
	z_substr
	read_textfile
	write_textfile
	get_url_sig
	make_query
	check_post_error
);

use strict;

sub get_localtime_string {
	my $span = @_[0];
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)   = gmtime(time + $span + $timezone);
	my $fmt0 = '%04d%02d%02d%02d%02d%02d';
	my $now_datetime = sprintf($fmt0, $year+1900,$mon+1,$mday,$hour,$min,$sec);
	return $now_datetime;
}

sub get_formated_localtime_string {
	my $span = @_[0];
	my @japanese_week = ('', '', '', '', '', '', 'y');
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)   = gmtime(time + $span + $timezone);
	my $fmt0 = '%04d/%d/%d(%s) %02d:%02d:%02d';
	my $now_datetime = sprintf($fmt0, $year+1900,$mon+1,$mday,$japanese_week[$wday],$hour,$min,$sec);
	return $now_datetime;
}	

sub format_string_time {
	my $time = @_[0];
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
	if(length($time) != 14){
		return '';
	}

	$year = substr($time, 0, 4);
	$mon = substr($time, 4, 2);
	$mday = substr($time, 6, 2);
	$hour = substr($time, 8, 2);
	$min = substr($time, 10, 2);
	$sec = substr($time, 12, 2);
	my @japanese_week = ('', '', '', '', '', '', 'y');
	my $epoch= Time::Local::timelocal($sec, $min, $hour, $mday, ($mon - 1), ($year - 1900));
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)   = gmtime($epoch + $timezone);
	my $fmt0 = '%04d/%d/%d(%s) %02d:%02d:%02d';
	my $now_datetime = sprintf($fmt0, $year+1900,$mon+1,$mday,$japanese_week[$wday],$hour,$min,$sec);
	return $now_datetime;
}

sub escape_html_tags {
	my $text = @_[0];
	$text =~ s/&/&amp;/g;
	$text =~ s/</&lt;/g;
	$text =~ s/>/&gt;/g;
	$text =~ s/"/&quot;/g;
	return $text;
}

sub get_category_hash {
	my %hash = (
		'01_quake' => 'nk',
		'02_news' => 'j[X',
		'03_world' => 'E',
		'04_guide' => 'ē',
		'05_manage' => '^c',
		'06_talk' => 'ꍇ',
		'07_aa' => 'AA',
		'08_society' => 'Љ',
		'09_company' => '',
		'10_darkside' => 'Љ',
		'11_culture' => '',
		'12_komosu' => 'wEn',
		'13_bakasu' => 'wEn',
		'14_elec' => 'Ɠdi',
		'15_dictator' => 'o',
		'16_food' => 'H',
		'17_life' => '',
		'18_free' => 'l^Gk',
		'19_nekodaisuki' => 'JeSGk',
		'20_live' => 'ch',
		'21_school' => '󌱁EwZ',
		'22_hoby' => '',
		'23_sports' => 'X|[c',
		'24_ball' => 'Z',
		'25_misawa' => 'iZ',
		'26_travel' => 'sEOo',
		'27_usotuki' => 'er',
		'28_talent' => '|\\',
		'29_ganble' => 'Mu',
		'30_game' => 'Q[',
		'31_sgame' => 'gуQ[',
		'32_netgame' => 'lbgQ[',
		'33_manga' => 'E',
		'34_music' => 'y',
		'35_health' => 'SƑ',
		'36_pc' => 'PC',
		'37_net' => 'lbg֌W',
		'38_talk2' => 'Gkn2',
		'39_pink' => 'BBSPINK',
		'40_local' => '܂BBS'
		);
	return %hash;
}

sub is_existed_category {
	my $category_code = @_[0];
	my %category_hash = &get_category_hash();

	if($category_hash{$category_code} ne ''){
		return 1;
	}else{
		return 0;
	}
}

sub read_timestamp {
	my $filename = @_[0];
	my $timestamp = "";
	if(open(IO, "<$filename")){
		my @data = <IO>;
		$timestamp = $data[0];
		close(IO);
	}
	return $timestamp;
}

sub write_timestamp {
	my $filename = @_[0];
	my $timestamp = get_localtime_string(0);
	if(open(IO, ">$filename")){
		print IO "$timestamp\n";
		close(IO);
	}
}

sub erase_enter {
	my $text = @_[0];
	$text =~ s/\r\n//g;
	$text =~ s/\n//g;
	return $text;
}

sub get_remote_host {
	my $host;
	if (!$ENV{'REMOTE_HOST'} || $ENV{'REMOTE_HOST'} eq $ENV{'REMOTE_ADDR'}){
		if (!($host=gethostbyaddr(pack('C4',split(/\./,$ENV{'REMOTE_ADDR'})),2))){
			$host = $ENV{'REMOTE_ADDR'};
		}
	}else{ 
		$host = $ENV{'REMOTE_HOST'};
	}
	return $host;
}

sub read_config {
	my $filename = @_[0];
	my @list;
	my %pair;

	if(open(IO, "<$filename")){
		@list = <IO>;
		close(IO);
	}
	foreach my $rec(@list){
		my @item = split(/=/, $rec);
		$item[1] =~ s/\n//g;
		$pair{"$item[0]"} = $item[1];
	}

	return %pair;
}

sub write_config {
	my ($filename, %hash) = @_;

	if(open(IO, ">$filename")){
		foreach my $key(sort keys %hash){
			print IO "$key=" . $hash{$key} . "\n";
		}
		close(IO);
	}
}

sub send_cookie {
	my ($name, $value) = @_;
	$value =~ s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
	print "Set-Cookie: $name=$value;\n";
}

sub recv_cookie {
	my %cookie;
	foreach (split(/;/, $ENV{'HTTP_COOKIE'})) {
		my ($name, $value) = split(/=/);
		$name =~ s/\s//g;
		$value =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("C", hex($1))/eg;
		$cookie{$name} = $value;
	}
	return %cookie;
}

sub get_crypted_name {
	my $name = @_[0];
	my $find_sharp = index($name, "#");
	if($find_sharp < 0){
		return $name;
	}
	my $find_space = index($name, " ", $find_sharp);
	if($find_space < 0){
		$find_space = length($name) - 1;
	}

	my $left = substr($name, 0, $find_sharp);
	my $target = substr($name, $find_sharp+1, $find_space - $find_sharp);
	my $right = substr($name, $find_space+1, length($name) - ($find_space+1));
	my $digest = md5_base64($target);
	my $digest = substr($digest, 0, 10);
	return "$left</b>$digest <b>$right";
}

sub get_cellphone_type {
	my $agent = $ENV{'HTTP_USER_AGENT'};
	if($agent =~ /^DoCoMo/){
		return "docomo";
	}elsif($agent =~ /^J-PHONE|^Vodafone|^SoftBank/){
		return "softbank";
	}elsif($agent =~ /^UP.Browser|^KDDI/){
		return "kddi";
	}
	return "pc";
}

sub ipfilter {
	my ($remote_host, $iptable_filename) = @_;

	my $table = &read_textfile($iptable_filename);
	my @patterns = split(/\n/, $table);

	foreach my $pattern(@patterns){
		if($remote_host =~ /$pattern/){
			# match
			return 1;
		}
	}
	return 0;
}

sub z_substr {
	my ($s,$p,$l) = @_;
	$s =~ s/(.)/$1\0/g;
	$s =~ s/([\x81-\x9f\xe0-\xfc])\0(.)\0/$1$2\0\0/g;
	$s = $l eq '' ? substr($s,$p*2):substr($s,$p*2,$l*2);
	$s =~ tr/\0//d;
	$s;
}

sub read_textfile {
	my $filename = @_[0];
	my $text = "";
	if(open(IO, "<$filename")){
		foreach my $line(<IO>){
			$text .= $line;
		}
		close(IO);
	}
	return $text;
}

sub write_textfile {
	my ($filename, $text) = @_;
	if(open(IO, ">$filename")){
		print IO $text;
		close(IO);
	}
}

sub get_url_sig {
	my $url = @_[0];
	my $sig = substr(md5_hex($url), 0, 5);
	return $sig;
}

sub make_query {
	my ($url, $key, $value) = @_;
	if($value eq ''){
		return $url;
	}
	if($url =~ /\?/){
		$url .= "&$key=$value";
	}else{
		$url .= "?$key=$value";
	}
	return $url;
}

sub check_post_error {
	my (
		$force_subject,
		$subject,
		$from,
		$mail,
		$message
	) = @_;

	if($force_subject eq 1 and $subject eq ''){
		return 307;
	}
	if(length($subject) > 100){
		return 308;
	}
	if(length($from) > 100){
		return 309;
	}
	if(length($mail) > 100){
		return 310;
	}
	if($message eq ''){
		return 311;
	}
	if(length($message) > 2048){
		return 312;
	}

	my @lines = split(/\n/, $message);
	foreach my $line(@lines){
		if(length($line) > 256){
			return 313;
		}
	}
	if(@lines > 32){
		return 347;
	}

	return 200;
}

1;
