# BTS/HttpRequest.pm

package BTS::HttpRequest;

use Exporter;
@ISA = (Exporter);
@EXPORT = qw(httprequest);
use HTTP::Lite;

use strict;

sub httprequest {
	my($tracker_url, $param, $proxy_host, $proxy_port) = @_;

	my %http_param;

	my @params = split(/&/, $param);
	my $sep;
	foreach $sep(@params){
		my @keyval = split(/=/, $sep);
		$http_param{$keyval[0]} = $keyval[1];
	}

	my $http = new HTTP::Lite;
	if($proxy_host ne ''){
		if($proxy_port ne ''){
			$http->proxy("$proxy_host:$proxy_port");
		}else{
			$http->proxy("$proxy_host");
		}
	}
	$http->prepare_post(\%http_param);
	my $server_res = $http->request($tracker_url);
	if($server_res < 200 or $server_res > 299){
		return ("500", "500 Server Error\n");
	}

	my $body = $http->body();
	my @body_sp = split(/ /, $body);
	my $res_code = $body_sp[0];
	return ($res_code, $body);
}


1;
