# BTS/Logger.pm

package BTS::Logger;
use strict;
use BTS::FileLocker;
use BTS::Record::Log;
use BTS::TimeZone;

sub new {
	my $pkg = shift;
	my $hash = {
		btsfilelocker => shift,
		logdir => shift,
		holddays => shift,

		status => 0,
		loglist => undef,
		date => undef,
	};
	bless $hash, $pkg;
}

sub write {
	my $self = shift;
	my $value = shift;

	my $filelocker =  $self->{btsfilelocker};
	my $logdir = $self->{logdir};
	my $holddays = $self->{holddays};

	if($holddays < 0){
		return 0;
	}

	my $datetime = &localtime_string();
	my $date = substr($datetime, 0, 8);
	my $filename = $logdir . '/' . $date . '.log';

	if(!$filelocker->lock($filename)){
		return 0;
	}

	my @list;
	if(open(IO, "<$filename")){
		foreach my $line(<IO>){
			my $rec = BTS::Record::Log->new();
			$rec->convert_from_text($line);
			push @list, $rec;
		}
		close(IO);
	}
	
	splice @list, 0, 0, BTS::Record::Log->new($datetime, $value);

	if(open(IO, ">$filename")){
		foreach my $rec(@list){
			print IO $rec->convert_to_text();
		}
		close(IO);
	}

	$filelocker->unlock($filename);

	#$self->delete_old_log();

	return 1;
}

sub delete_old_log {
	my $self = shift;

	my $filelocker =  $self->{btsfilelocker};
	my $logdir = $self->{logdir};
	my $holddays = $self->{holddays};

	my $oldday = substr(&localtime_string($holddays * -86400), 0, 8);

	if(opendir(DH, $logdir)){
		while (my $filename = readdir DH){
			my @file_sp = split(/./, $filename);
			if($file_sp[0] < $oldday){
				unlink $logdir . '/' . $filename;
			}
		}
		closedir(DH);
	}
}

sub open {
	my $self = shift;
	my $date = shift;

	my $filelocker =  $self->{btsfilelocker};
	my $logdir = $self->{logdir};
	my $holddays = $self->{holddays};

	my $filename = $logdir . '/' . $date . '.log';

	if(!-e $filename){
		return 0;
	}

	if(!$filelocker->lock($filename)){
		return 0;
	}

	@{$self->{loglist}} = ();
	if(open(IO, "<$filename")){
		foreach my $line(<IO>){
			my $rec = BTS::Record::Log->new();
			$rec->convert_from_text($line);
			push @{$self->{loglist}}, $rec;
		}
		close(IO);
	}

	$self->{status} = 1;
	$self->{date} = $date;

	return 1;
}

sub close {
	my $self = shift;

	my $filelocker =  $self->{btsfilelocker};
	my $logdir = $self->{logdir};
	my $holddays = $self->{holddays};

	if($self->{status} eq 0){
		return 0;
	}

	my $date = $self->{date};
	my $filename = $logdir . '/' . $date . '.log';

	$filelocker->unlock($filename);
	$self->{status} = 0;
	$self->{date} = 0;
}

sub get_count {
	my $self = shift;

	my $count = @{$self->{loglist}};
	return $count;
}

sub get_from_index {
	my $self = shift;
	my $index = shift;
	
	my $rec = @{$self->{loglist}}[$index];
	return $rec;
}

sub localtime_string {
	my $span = @_[0];
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)   = gmtime(time + $span + $timezone);
	my $fmt0 = '%04d%02d%02d%02d%02d%02d';
	my $now_datetime = sprintf($fmt0, $year+1900,$mon+1,$mday,$hour,$min,$sec);
	return $now_datetime;
}

1;
