# BTS/Record/Board.pm
# record class for boardlist

package BTS::Record::Board;
use strict;
use BTS::Record::Encoder;

sub new {
	my $pkg = shift;
	my $hash = {
		category => shift,
		subcategory => shift,
		url => shift,
		bm => shift,
		tm => shift,
		time => shift,
		threaders => shift,
		fail => shift
	};

	bless $hash, $pkg;
}

sub convert_from_text {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{category} 	= &rec_decode_string($items[0]);
	$self->{subcategory} 	= &rec_decode_string($items[1]);
	$self->{url} 		= &rec_decode_string($items[2]);
	$self->{bm} 		= &rec_decode_string($items[3]);
	$self->{tm} 		= &rec_decode_string($items[4]);
	$self->{time} 		= &rec_decode_string($items[5]);
	$self->{threaders} 	= &rec_decode_string($items[6]);
	$self->{fail} 		= &rec_decode_string($items[7]);
}

sub convert_to_text {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{category});
	$text .= '<>' . &rec_encode_string($self->{subcategory});
	$text .= '<>' . &rec_encode_string($self->{url});
	$text .= '<>' . &rec_encode_string($self->{bm});
	$text .= '<>' . &rec_encode_string($self->{tm});
	$text .= '<>' . &rec_encode_string($self->{time});
	$text .= '<>' . &rec_encode_string($self->{threaders});
	$text .= '<>' . &rec_encode_string($self->{fail});
	$text .= "\n";
	$text;
}

1;
