# BTS/Record/Log.pm
# record class for log

package BTS::Record::Log;
use strict;
use BTS::Record::Encoder;

sub new {
	my $pkg = shift;
	my $hash = {
		time => shift,
		text => shift
	};

	bless $hash, $pkg;
}

sub convert_from_text {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{time} 	= &rec_decode_string($items[0]);
	$self->{text} 	= &rec_decode_string($items[1]);
}

sub convert_to_text {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{time});
	$text .= '<>' . &rec_encode_string($self->{text});
	$text .= "\n";
	$text;
}

1;
