# BTS/Record/Owner.pm
# record class for ownerlist

package BTS::Record::Owner;
use strict;
use BTS::Record::Encoder;

sub new {
	my $pkg = shift;
	my $hash = {
		title => shift,
		category => shift,
		subcategory => shift,
		url => shift,
		bm => shift,
		tm => shift,
		fail => shift
	};

	bless $hash, $pkg;
}

sub convert_from_text {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{title}	 	= &rec_decode_string($items[0]);
	$self->{category} 	= &rec_decode_string($items[1]);
	$self->{subcategory} 	= &rec_decode_string($items[2]);
	$self->{url} 		= &rec_decode_string($items[3]);
	$self->{bm} 		= &rec_decode_string($items[4]);
	$self->{tm} 		= &rec_decode_string($items[5]);
	$self->{fail} 		= &rec_decode_string($items[6]);
}

sub convert_to_text {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{title});
	$text .= '<>' . &rec_encode_string($self->{category});
	$text .= '<>' . &rec_encode_string($self->{subcategory});
	$text .= '<>' . &rec_encode_string($self->{url});
	$text .= '<>' . &rec_encode_string($self->{bm});
	$text .= '<>' . &rec_encode_string($self->{tm});
	$text .= '<>' . &rec_encode_string($self->{fail});
	$text .= "\n";
	$text;
}

1;
