# BTS/Record/Response.pm
# record class for thread data

package BTS::Record::Response;

use BTS::Record::Encoder;

use strict;

sub new {
	my $pkg = shift;
	my $hash = {
		from => shift,
		mail => shift,
		time_and_id => shift,
		message => shift,
		title => shift,
		default_name => shift,
		post_url => shift,
		ex_deleted => shift,
		ex_delcount => shift,
		ex_lastid => shift
	};

	bless $hash, $pkg;
}

sub convert_from_text {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{from} 		= &rec_decode_string($items[0]);
	$self->{mail} 		= &rec_decode_string($items[1]);
	$self->{time_and_id} 	= &rec_decode_string($items[2]);
	$self->{message} 	= &rec_decode_string($items[3]);
	$self->{title} 		= &rec_decode_string($items[4]);
	$self->{default_name} 	= &rec_decode_string($items[5]);
	$self->{post_url} 	= &rec_decode_string($items[6]);
}

sub convert_to_text {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{from});
	$text .= '<>' . &rec_encode_string($self->{mail});
	$text .= '<>' . &rec_encode_string($self->{time_and_id});
	$text .= '<>' . &rec_encode_string($self->{message});
	if($self->{title} ne ""){ # first line
		$text .= '<>' . &rec_encode_string($self->{title});
		$text .= '<>' . &rec_encode_string($self->{default_name});
		$text .= '<>' . &rec_encode_string($self->{post_url});
	}
	$text .= "\n";
	$text;
}

# extention
sub convert_from_text_ex {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{ex_deleted} 	= &rec_decode_string($items[0]);
	$self->{ex_delcount} 	= &rec_decode_string($items[1]);
	$self->{ex_lastid} 	= &rec_decode_string($items[2]);
}

sub convert_to_text_ex {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{ex_deleted});
	$text .= '<>' . &rec_encode_string($self->{ex_delcount});
	$text .= '<>' . &rec_encode_string($self->{ex_lastid});
	$text .= "\n";
	$text;
}

1;
