# BTS/Record/Thread.pm
# record class for threadlist

package BTS::Record::Thread;
use strict;
use BTS::Record::Encoder;

sub new {
	my $pkg = shift;
	my $hash = {
		key => shift,
		url => shift,
		bm => shift,
		tm => shift,
		title => shift,
		rescount => shift,
		time => shift,
		deleted => shift,
		delcount => shift,
		lastid => shift
	};

	bless $hash, $pkg;
}

sub convert_from_text {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{key} 		= &rec_decode_string($items[0]);
	$self->{url} 		= &rec_decode_string($items[1]);
	$self->{bm} 		= &rec_decode_string($items[2]);
	$self->{tm} 		= &rec_decode_string($items[3]);
	$self->{title} 		= &rec_decode_string($items[4]);
	$self->{rescount} 	= &rec_decode_string($items[5]);
	$self->{time} 		= &rec_decode_string($items[6]);
	$self->{deleted} 	= &rec_decode_string($items[7]);
	$self->{delcount} 	= &rec_decode_string($items[8]);
	$self->{lastid} 	= &rec_decode_string($items[9]);
}

sub convert_to_text {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{key});
	$text .= '<>' . &rec_encode_string($self->{url});
	$text .= '<>' . &rec_encode_string($self->{bm});
	$text .= '<>' . &rec_encode_string($self->{tm});
	$text .= '<>' . &rec_encode_string($self->{title});
	$text .= '<>' . &rec_encode_string($self->{rescount});
	$text .= '<>' . &rec_encode_string($self->{time});
	$text .= '<>' . &rec_encode_string($self->{deleted});
	$text .= '<>' . &rec_encode_string($self->{delcount});
	$text .= '<>' . &rec_encode_string($self->{lastid});
	$text .= "\n";
	$text;
}

1;
