# BTS/Record/Threader.pm
# record class for threader list

package BTS::Record::Threader;

use BTS::Record::Encoder;

use strict;

sub new {
	my $pkg = shift;
	my $hash = {
		url => shift,
		bm => shift,
		tm => shift,
		fail => shift
	};

	bless $hash, $pkg;
}

sub convert_from_text {
	my $self = shift;
	my $text = shift;

	my @items = split(/<>|\n/, $text);
	$self->{url} 		= &rec_decode_string($items[0]);
	$self->{bm} 		= &rec_decode_string($items[1]);
	$self->{tm} 		= &rec_decode_string($items[2]);
	$self->{fail}	 	= &rec_decode_string($items[3]);
}

sub convert_to_text {
	my $self = shift;
	my $text;

	$text =  &rec_encode_string($self->{url});
	$text .= '<>' . &rec_encode_string($self->{bm});
	$text .= '<>' . &rec_encode_string($self->{tm});
	$text .= '<>' . &rec_encode_string($self->{fail});
	$text .= "\n";
	$text;
}

1;
