# BTS/Session.pm

package BTS::Session;
use strict;
use BTS::FileLocker;
use BTS::Record::Encoder;
use BTS::TimeZone;

sub new {
	my $pkg = shift;
	my $hash = {
		btsfilelocker => shift,
		session_file => shift,
		id => shift
	};
	bless $hash, $pkg;
}

sub write {
	my $self = shift;
	my $name = shift;
	my $value = shift;

	$value = &rec_encode_string($value);

	my $filelocker =  $self->{btsfilelocker};
	my $session_file = $self->{session_file};
	my $id = $self->{id};

	if(!$filelocker->lock($session_file)){
		return 0;
	}

	my @list;
	if(open(IO, "<$session_file")){
		@list = <IO>;
		close(IO);
	}

	my $lt = &localtime_string(0);
	my $onedaybefore = &localtime_string(-86400); # 24Ԃō폜
	my @newlist=();
	
	my $found=0;
	foreach (my $i=0; $i<@list;$i++){
		my @items = split(/<>|\n/, $list[$i]);
		if($items[0] eq $id and $items[1] eq $name){
			push @newlist, "$id<>$name<>$value<>$lt\n";
			$found=1;
		}else{
			if($items[3] > $onedaybefore){
				push @newlist, $list[$i];
			}
		}
	}
	if($found eq 0){
		push @newlist, "$id<>$name<>$value<>$lt\n";
	}

	if(open(IO, ">$session_file")){
		print IO @newlist;
		close(IO);
	}

	$filelocker->unlock($session_file);

	return 1;
}

sub read {
	my $self = shift;
	my $name = shift;

	my $filelocker =  $self->{btsfilelocker};
	my $session_file = $self->{session_file};
	my $id = $self->{id};

	if(!$filelocker->lock($session_file)){
		return "";
	}

	my @list;
	if(open(IO, "<$session_file")){
		@list = <IO>;
		close(IO);
	}

	my $value = "";
	foreach (my $i=0; $i<@list;$i++){
		my @items = split(/<>|\n/, $list[$i]);
		if($items[0] eq $id and $items[1] eq $name){
			$value = $items[2];
			last;
		}
	}

	$value = &rec_decode_string($value);

	$filelocker->unlock($session_file);

	return $value;
}

sub clear {
	my $self = shift;

	my $filelocker =  $self->{btsfilelocker};
	my $session_file = $self->{session_file};
	my $id = $self->{id};

	if(!$filelocker->lock($session_file)){
		return 0;
	}

	my @list;
	if(open(IO, "<$session_file")){
		@list = <IO>;
		close(IO);
	}

	my @newlist=();
	foreach (my $i=0; $i<@list;$i++){
		my @items = split(/<>|\n/, $list[$i]);
		if($items[0] ne $id){
			push @newlist, $list[$i];
		}
	}
	
	if(open(IO, ">$session_file")){
		print IO @newlist;
		close(IO);
	}

	$filelocker->unlock($session_file);

	return 1;
}

sub localtime_string {
	my $span = @_[0];
	my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst)   = gmtime(time + $span + $timezone);
	my $fmt0 = '%04d%02d%02d%02d%02d%02d';
	my $now_datetime = sprintf($fmt0, $year+1900,$mon+1,$mday,$hour,$min,$sec);
	return $now_datetime;
}

1;
