# BTS/Statics.pm

package BTS::Statics;

use Time::Local;
use Digest::MD5  qw(md5 md5_hex md5_base64);
use Exporter;
@ISA = (Exporter);
@EXPORT = qw(
	initialize_statics

	$btserr_title
	$btsmsg_title
	$datfile_dir
	$subject_txt_file
	$bts_module_name
	$tracker_module_name
	$admin_module_name
	$register_module_name
	$config_file
	$session_temp_file
	$iptable_bts_file
	$urltable_bts_file
	$iptable_user_file
	$compiled_iptable_bts_file
	$compiled_urltable_bts_file
	$compiled_iptable_user_file
	$ownerlist_file
	$boarderlist_file
	$threaderlist_file
	$locker_temp_dir
	$threadlist_file
	$htmlhead_menupc_file
	$htmlfoot_menupc_file
	$htmlhead_menucell_file
	$htmlfoot_menucell_file
	$htmlhead_boardpc_file
	$htmlfoot_boardpc_file
	$htmlhead_boardcell_file
	$htmlfoot_boardcell_file
	$htmlhead_bbspc_file
	$htmlfoot_bbspc_file
	$htmlhead_bbscell_file
	$htmlfoot_bbscell_file
	$sig_htmlheadfoot_menu
	$sig_htmlheadfoot_board
	$sig_htmlheadfoot_bbs
	$boarder_alive_check_file
	$owner_alive_check_file
	$redirect_temp_pc
	$redirect_temp_cell
	$password_lock
	$log_dir
	$copyright
	$ownerlimit
);

use strict;

our $btserr_title;
our $btsmsg_title;
our $datfile_dir;
our $subject_txt_file;
our $bts_module_name;
our $tracker_module_name;
our $admin_module_name;
our $register_module_name;
our $config_file;
our $session_temp_file;
our $iptable_bts_file;
our $urltable_bts_file;
our $iptable_user_file;
our $compiled_iptable_bts_file;
our $compiled_urltable_bts_file;
our $compiled_iptable_user_file;
our $ownerlist_file;
our $boarderlist_file;
our $threaderlist_file;
our $locker_temp_dir;
our $threadlist_file;
our $htmlhead_menupc_file;
our $htmlfoot_menupc_file;
our $htmlhead_menucell_file;
our $htmlfoot_menucell_file;
our $htmlhead_boardpc_file;
our $htmlfoot_boardpc_file;
our $htmlhead_boardcell_file;
our $htmlfoot_boardcell_file;
our $htmlhead_bbspc_file;
our $htmlfoot_bbspc_file;
our $htmlhead_bbscell_file;
our $htmlfoot_bbscell_file;
our $sig_htmlheadfoot_menu;
our $sig_htmlheadfoot_board;
our $sig_htmlheadfoot_bbs;
our $boarder_alive_check_file;
our $owner_alive_check_file;
our $redirect_temp_pc;
our $redirect_temp_cell;
our $password_lock;
our $log_dir;
our $copyright;
our $ownerlimit;

sub initialize_statics {
	my $system_data_dir = @_[0];

	$btserr_title = "G[";
	$btsmsg_title = "bZ[W";

	$datfile_dir = "dat";

	$subject_txt_file = "subject.txt";

	$bts_module_name = "bts.cgi";
	$tracker_module_name = "tracker.cgi";
	$admin_module_name = "btsadmin.cgi";
	$register_module_name = "btsregister.cgi";

	$config_file = "$system_data_dir/conf.dat";
	$session_temp_file = "$system_data_dir/session.tmp";

	$iptable_bts_file = "$system_data_dir/iptablebts.dat";
	$urltable_bts_file = "$system_data_dir/urltablebts.dat";
	$iptable_user_file = "$system_data_dir/iptableuser.dat";
	$compiled_iptable_bts_file = "$system_data_dir/iptablebts2.dat";
	$compiled_urltable_bts_file = "$system_data_dir/urltablebts2.dat";
	$compiled_iptable_user_file = "$system_data_dir/iptableuser2.dat";

	$ownerlist_file = "$system_data_dir/ownerlist.dat";
	$boarderlist_file = "$system_data_dir/boaderlist.dat";
	$threaderlist_file = "$system_data_dir/threaderlist.dat";

	$locker_temp_dir = "$system_data_dir/lock";

	$threadlist_file = "$system_data_dir/threads.dat";

	$htmlhead_menupc_file = "$system_data_dir/htmlhead_menupc.dat";
	$htmlfoot_menupc_file = "$system_data_dir/htmlfoot_menupc.dat";
	$htmlhead_menucell_file = "$system_data_dir/htmlhead_menucell.dat";
	$htmlfoot_menucell_file = "$system_data_dir/htmlfoot_menucell.dat";
	$htmlhead_boardpc_file = "$system_data_dir/htmlhead_boardpc.dat";
	$htmlfoot_boardpc_file = "$system_data_dir/htmlfoot_boardpc.dat";
	$htmlhead_boardcell_file = "$system_data_dir/htmlhead_boardcell.dat";
	$htmlfoot_boardcell_file = "$system_data_dir/htmlfoot_boardcell.dat";
	$htmlhead_bbspc_file = "$system_data_dir/htmlhead_bbspc.dat";
	$htmlfoot_bbspc_file = "$system_data_dir/htmlfoot_bbspc.dat";
	$htmlhead_bbscell_file = "$system_data_dir/htmlhead_bbscell.dat";
	$htmlfoot_bbscell_file = "$system_data_dir/htmlfoot_bbscell.dat";

	$sig_htmlheadfoot_menu = "htmlheadfoot_menu";
	$sig_htmlheadfoot_board = "htmlheadfoot_board";
	$sig_htmlheadfoot_bbs = "htmlheadfoot_bbs";

	$boarder_alive_check_file = "$system_data_dir/boarder_alive_check.dat";
	$owner_alive_check_file = "$system_data_dir/owner_alive_check.dat";

	$redirect_temp_pc = "$system_data_dir/redirect_pc_tmp.dat";
	$redirect_temp_cell = "$system_data_dir/redirect_cell_tmp.dat";

	$password_lock = 0;

	$log_dir = "$system_data_dir/log";
	$copyright = "Coryright (c) 2009-2010 BTS All Rights Reserved";

	$ownerlimit = 2;
}

1;


