# bts_cell.pl
use strict;

our $system_data_dir;

our $bbscore;
our $filelocker;
our %config;
our %input;
our $cellphone_type;

sub execute_bts_cell {
	if($input{'submit'} eq '쐬'){
		&create_thread();
	}elsif($input{'submit'} eq ''){
		&add_response();
	}elsif($input{'m'} eq 'rdt'){
		&show_redirect_html();
	}else{
		if($input{'key'} eq ''){
			if($input{'m'} eq 'new'){
				&show_newthread_cell_html();
			}else{
				&show_threadlist_cell_html();
			}
		}else{
			if($input{'m'} eq 'delres'){
				&show_res_delete_warn_html();
			}elsif($input{'m'} eq 'delth'){
				&show_thread_delete_warn_html();
			}elsif($input{'m'} eq 'delth_apply'){
				&delete_thread();
			}elsif($input{'m'} eq 'delres_apply'){
				&delete_response();
			}elsif($input{'m'} eq 'addres'){
				&show_newres_cell_html();
			}elsif($input{'line'} ne ''){
				&show_resdetail_cell_html();
			}else{
				&show_bbs_cell_html();
			}
		}
	}
	&owner_alive_check();
}

sub make_url_link {
	my ($str, $target) = @_;
	$str =~ s/(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<a href="$bts_module_name?m=rdt&url=$1">$1<\/a>/g;
	return $str;
}

sub print_header_html {
	my ($title) = @_[0];
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><head>";
	print "</head>\n";
}

sub print_footer_html {
	print "</html>";
}

sub print_error_html {
	my ($title, $message, $return_title, $return_url) = @_;
	&print_header_html($title);

	print "<body>";
	print "$message<br><br>";
	if($return_title ne ""){
		print "<a href=\"$return_url\">$return_title</a>";
	}
	print "<body>";
	
	&print_footer_html();
}

sub show_newthread_cell_html {
	my $sig1 = $input{'s1'};

	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><body>";
	print "<form method=POST action=\"$bts_module_name\">";
	print "<input type=text name=subject size=40><br>";
	print "<input type=text name=FROM size=40><br>";
	print "<input type=text name=mail size=40><br>";
	print "<textarea rows=5 cols=40 wrap=OFF name=MESSAGE></textarea><br>";
	print "<input type=submit value=\"쐬\" name=submit>";
	if($sig1 ne ''){
		print "<input type=hidden name=s1 value=\"$sig1\">";
	}
	print "<a href=\"$bts_module_name?s1=$sig1\">߂</a>";
	print "</form>";
	print "</body>";
	print "</html>";
}

sub show_threadlist_cell_html {
	my $page = $input{'page'};
	my $maxview = 10;
	my $sig1 = $input{'s1'};

	if(!$filelocker->lock($sig_htmlheadfoot_board)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $htmlhead = &read_textfile($htmlhead_boardcell_file);
	my $htmlfoot = &read_textfile($htmlfoot_boardcell_file);
	$filelocker->unlock($sig_htmlheadfoot_board);

	my $owner_bts;
	if(!$bbscore->open($bbscore->{mode_owner})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($sig1 eq get_url_sig($rec->{url})){
			$owner_bts = $rec->{url} . $rec->{bm};
			last;
		}
	}
	$bbscore->close();

	if(!$bbscore->open($bbscore->{mode_thread})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><body>";
	print $htmlhead;

	print "<a href=\"$owner_bts\">[gbv]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1\">[ē]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&m=new\">[쐬]</a>";
	print "<br>";
	
	my $sig2 = get_url_sig($config{'HomeUrl'});
	my $start = $page * $maxview;
	my $end = $start + $maxview;
	if($end > $bbscore->get_count()){$end=$bbscore->get_count();}
	foreach (my $i=$start;$i<$end;$i++){
		my $rec = $bbscore->get_from_index($i);
		my $formated_time = &format_string_time($rec->{time});
		my $title = &z_substr($rec->{title}, 0, 18);
		my $index = $i+1;
		
		if($config{'NodeClass'} eq 'boarder'){
			print "<a href=\"$rec->{url}$rec->{bm}?s1=$sig1&s2=$sig2&key=$rec->{key}\">";
		}else{
			print "<a href=\"".$config{'HomeUrl'}.$bts_module_name."?s1=$sig1&s2=$sig2&key=$rec->{key}>";
		}
		print "$index.";
		print "$title";
		print "</a>";
		print "<br>";
		$index++;
	}

	if($page > 0){
		my $num = $page - 1;
		print "<a href=\"$bts_module_name?page=$num\">O</a>";
	}
	if(($page * $maxview + $maxview) < $bbscore->get_count()){
		my $num = $page + 1;
		print "<a href=\"$bts_module_name?page=$num\"></a>";
	}
	$bbscore->close();

	print $htmlfoot;
	print "</body></html>";
}

sub show_bbs_cell_html {
	my $key = $input{'key'};
	my $view = $input{'m'};
	my $page = $input{'page'};
	my $maxview=10;
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};

	if(!$filelocker->lock($sig_htmlheadfoot_bbs)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $htmlhead = &read_textfile($htmlhead_bbscell_file);
	my $htmlfoot = &read_textfile($htmlfoot_bbscell_file);
	$filelocker->unlock($sig_htmlheadfoot_bbs);

	if(!$bbscore->response_exist($key)){
		&print_error_html($btserr_title, btserr(315));
		return;
	}

	my $owner_bts;
	if(get_url_sig($config{'HomeUrl'}) eq $sig2){
		$owner_bts = $config{'HomeUrl'}.$bts_module_name;
	}else{
		if(!$bbscore->open($bbscore->{mode_owner})){
			&print_error_html($btserr_title, btserr(400));
			return;
		}
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($sig2 eq get_url_sig($rec->{url})){
				$owner_bts = $rec->{url} . $rec->{bm};
				last;
			}
		}
		$bbscore->close();
	}

	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $rec = $bbscore->get_from_index(0);
	my $thread_title = $rec->{title};

	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><body>";
	print $htmlhead;
	print "<a href=\"".$owner_bts."?s1=$sig1\">[߂]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key\">[ē]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&m=addres\">[e]</a>";
	print "<br>";
	print "<hr>";

	my $start = $bbscore->get_count() - $maxview - ($page * $maxview);
	if($start < 0){$start=0;}
	my $end = $start + $maxview;
	if($end >= $bbscore->get_count()){$end=$bbscore->get_count();}

	for(my $i=$start; $i<$end; $i++){
		my $rec = $bbscore->get_from_index($i);
		my $line_num = $i + 1;

		if($rec->{ex_deleted} eq 1){
			print "[$line_num]폜<br>";
			print "<hr>";
		}else{
			my $from = $rec->{from};
			my $mail = $rec->{mail};
			my $msg = $rec->{message};
			$msg = z_substr($msg, 0, 40);
			print "[$line_num]$from";
			if($mail ne ""){
				print "<a href=\"mailto:$mail\"></a>";
			}
			print "<br>";
			print $msg;
			print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&line=$i&page=$page\">[]</a><br>";
			print "<hr>";
		}
	}

	print "<a href=\"".$owner_bts."?s1=$sig1\">[߂]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key\">[ē]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&m=addres\">[e]</a>";
	print "<br>";
	$bbscore->close();

	if($start > 0){
		my $num = $page + 1;
		print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&page=$num\">O</a>";
	}
	if($page > 0){
		my $num = $page - 1;
		print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&page=$num\"></a>";
	}
	print "<br>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&m=delth&page=$page\">X폜</a>";

	print $htmlfoot;
	print "</body>";
	print "</html>";


}

sub show_newres_cell_html {
	my $key = $input{'key'};
	my $num = $input{'num'};
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};
	my $msg = "";

	if($num ne ""){
		$msg = ">>$num\n";
	}

	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><body>";
	print "<form method=POST action=\"$bts_module_name\">";
	print "<input type=text name=FROM size=40><br>";
	print "<input type=text name=mail size=40><br>";
	print "<textarea rows=5 cols=40 wrap=OFF name=MESSAGE>$msg</textarea><br>";
	print "<input type=submit value=\"\" name=submit>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key\">߂</a>";
	print "<input type=hidden name=key value=$key>";
	print "<input type=hidden name=s1 value=$sig1>";
	print "<input type=hidden name=s2 value=$sig2>";
	print "</form>";
	print "</body>";
	print "</html>";
}

sub show_resdetail_cell_html {
	my $key = $input{'key'};
	my $line = $input{'line'};
	my $page = $input{'page'};
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};

	if(!$bbscore->response_exist($key)){
		&print_error_html($btserr_title, btserr(315), "߂", "$bts_module_name?s1=$sig1&s2=$sig2&key=$key");
		return;
	}
	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_error_html($btserr_title, btserr(400), "߂", "$bts_module_name?s1=$sig1&s2=$sig2&key=$key");
		return;
	}
	if($line < 0 or $line >= $bbscore->get_count()){
		&print_error_html($btserr_title, btserr(303), "߂", "$bts_module_name?s1=$sig1&s2=$sig2&key=$key");
		return;
	}
	
	my $rec = $bbscore->get_from_index($line);

	my $from = $rec->{from};
	my $mail = $rec->{mail};
	my $msg = $rec->{message};
	$msg = &make_url_link($msg);
	$bbscore->close();

	my $num = $line + 1;
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><body>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&page=$page\">[߂]</a>";
	if($line > 0){
		print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&m=delres&num=$line\">[폜]</a>";
	}
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&m=addres&num=$num\">[X]</a>";
	print "<br>";
	print "[No]$num<br>";
	print "[]";
	if($mail ne ""){
		print "<a href=\"mailto:$mail\">$from</a>";
	}else{
		print $from;
	}
	print "<br>";
	print "[]<br>";
	print $msg;

	print "</body>";
	print "</html>";
}

sub show_res_delete_warn_html {
	my $key = $input{'key'};
	my $num = $input{'num'};
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};

	if(!$bbscore->response_exist($key)){
		&print_error_html($btserr_title, btserr(315));
		return;
	}
	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	if($num < 1 or $num >= $bbscore->get_count()){
		&print_error_html($btserr_title, btserr(303));
		$bbscore->close();
		return;
	}

	my $rec = $bbscore->get_from_index($num);
	if($rec->{ex_deleted} eq 1){
		&print_error_html($btserr_title, btserr(303));
		$bbscore->close();
		return;
	}

	my $line_num = $num + 1;
	&print_header_html("e̍폜");
	print "<body>";
	print "ȉ̓e폜ɓ[܂B<br>";
	print "$line_num : <b>$rec->{from}</b>:$rec->{time_and_id}<br>";
	print "$rec->{message}<br><br>";
	print "xF<br>";
	print "POlȏ̓[ɂ폜܂B[͂Pxo܂B<br>";
	print "낵Γ[{^ĂB<br>";
	print "<br><form method=POST action=\"$bts_module_name\">";
	print "<input type=hidden name=key value=\"$key\">";
	print "<input type=hidden name=num value=\"$num\">";
	print "<input type=hidden name=s1 value=\"$sig1\">";
	print "<input type=hidden name=s2 value=\"$sig2\">";
	print "<input type=hidden name=m value=\"delres_apply\">";
	print "<input type=submit value=\"[\">";
	print "</form>";
	print "<br>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&line=$num\">[߂]</a><br>";
	print "</body>";
	&print_footer_html();

	$bbscore->close();
}

sub show_thread_delete_warn_html {
	my $key = $input{'key'};
	my $page = $input{'page'};
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};

	if(!$bbscore->open($bbscore->{mode_thread})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	
	my $index = $bbscore->get_thread_index_from_key($key);
	my $rec = $bbscore->get_from_index($index);

	&print_header_html("Xbh폜");
	print "<body>";
	print "ȉ̃Xbh폜ɓ[܂B<br>";
	print "$rec->{title}<br><br>";
	print "xF<br>";
	print "POlȏ̓[ɂ폜܂B[͂Pxo܂B<br>";
	print "낵Γ[{^ĂB<br>";
	print "<br><form method=POST action=\"$bts_module_name\">";
	print "<input type=hidden name=key value=\"$key\">";
	print "<input type=hidden name=m value=\"delth_apply\">";
	print "<input type=hidden name=s1 value=\"$sig1\">";
	print "<input type=hidden name=s2 value=\"$sig2\">";
	print "<input type=submit value=\"[\">";
	print "</form>";
	print "<br>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&page=$page\">[߂]</a><br>";
	print "</body>";
	&print_footer_html();

	$bbscore->close();
}

sub show_redirect_html {
	my $url = $input{'url'};
	my $html;

	print "Content-type: text/html; charset=Shift_JIS\n\n";
	$html = &read_textfile($redirect_temp_cell);
	$html =~ s/%URL%/$url/g;
	print $html;
}

1;
