# bts_menu.pl

use strict;

our $system_data_dir;

our $bbscore;
our $filelocker;
our %config;
our %input;
our $cellphone_type;

use BTS::HttpRequest;

sub execute_bts_menu {
	if($input{'v'} eq 'txt'){
		&show_menu_text();
	}elsif($input{'v'} eq 'left'){
		&show_menu_html();
		&boarder_alive_check();
	}else{
		if($cellphone_type ne 'pc'){
			&show_menu_cell_html();
			&boarder_alive_check();
		}else{
			&show_3paneframe_html();
		}
	}
}

sub print_header_html {
	my ($title) = @_[0];
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><head><title>$title</title>";
	print "<link rel=\"stylesheet\" href=\"resource/css/bts.css\" type=\"text/css\" />";
	print "<meta http-equiv=\"Pragma\" content=\"no-cache\">";
	print "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">";
	print "<meta http-equiv=\"Expires\" content=\"Thu, 01 Dec 1994 16:00:00 GMT\">";
	print "</head>\n";
}

sub print_footer_html {
	print "</html>";
}

sub print_error_html {
	my ($title, $message, $return_title, $return_url) = @_;
	&print_header_html($title);

	print "<body>";
	print $message;
	print "</body>";

	&print_footer_html();
}

sub show_menu_text {
	print "Content-type: text/plain; charset=Shift_JIS\n";
	print "Content-Disposition: attachment; filename=btsmenu.txt\n";
	print "Content-Description: CSV data of btsmenu\n";
	print "\n";

	if(!$bbscore->open($bbscore->{mode_board})){
		print btserr(400);
		return;
	}

	my %categorys = &get_category_hash();
	foreach my $category_code(sort keys %categorys){
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->{category} eq $category_code){
				print $categorys{$category_code};
				print ',';
				print $rec->{subcategory};
				print ',';
				print $rec->{url}.$rec->{bm};
				print "\n";
			}
		}
	}

	$bbscore->close();
}

sub show_menu_html {
	my $bt = $input{'bt'};
	my $bt2 = $input{'bt2'};

	if(!$filelocker->lock($sig_htmlheadfoot_menu)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $htmlhead = &read_textfile($htmlhead_menupc_file);
	my $htmlfoot = &read_textfile($htmlfoot_menupc_file);
	$filelocker->unlock($sig_htmlheadfoot_menu);

	if(!$bbscore->open($bbscore->{mode_board})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $html = '';
	$html .= "<body class=\"menu\">\n";
	$html .= $htmlhead;
	$html .= "<font size=-2>\n";

	my $sig1 = get_url_sig($config{'HomeUrl'});
	my %categorys = &get_category_hash();
	foreach my $category_code(sort keys %categorys){
		$html .= "<BR/><BR/><B>" . $categorys{$category_code} . "</B><BR/>\n";

		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->{category} eq $category_code){
				if($bt ne ""){
					$html .= "<A HREF=\"" . $rec->{url}.$rec->{bm} . "?s1=$sig1&bt=$bt2\" TARGET=\"$bt\">" . $rec->{subcategory} . "</A><BR/>\n";
				}else{
					$html .= "<A HREF=\"" . $rec->{url}.$rec->{bm} . "?s1=$sig1&bt=$bt2\">".$rec->{subcategory}."</A><BR/>\n";
				}
			}
		}
	}
	$html .= "</font>";
	$html .= $htmlfoot;
	$html .= "</body>\n";

	$bbscore->close();

	&print_header_html();
	print $html;
	&print_footer_html();

}

sub show_3paneframe_html {
	&print_header_html($config{'HomeTitle'});
	print "<frameset cols=\"150,*\">\n";
	print " <frame src=\"$bts_module_name?v=left&bt=top_pane&bt2=bottom_pane\" name=\"left_pane\">\n";
	print " <frameset rows=\"35%,*\">\n";
	print "  <frame src=\"dummy.html\" name=\"top_pane\">\n";
	print "  <frame src=\"dummy.html\" name=\"bottom_pane\">\n";
	print " </frameset>\n";
	print "</frameset>\n";
	&print_footer_html();
}

sub boarder_alive_check {
	# PԂƂɃ{[_[̐mFs
	if(!$filelocker->lock($boarder_alive_check_file)){
		return;
	}

	my @lines;
	if(open(IO, "<$boarder_alive_check_file")){
		@lines = <IO>;
		close(IO);
	}
	my $last_check_time = $lines[0];
	my $last_check_index = $lines[1];
	if($last_check_index eq ''){
		$last_check_index = 0;
	}

	my $need_check_time = &get_localtime_string(-1 * 60 * 60);
	if($need_check_time < $last_check_time){
		$filelocker->unlock($boarder_alive_check_file);
		return;
	}

	if(!$bbscore->open($bbscore->{mode_board})){
		$filelocker->unlock($boarder_alive_check_file);
		return;
	}

	if($bbscore->get_count() eq 0){
		$bbscore->close();
		$filelocker->unlock($boarder_alive_check_file);
		return;
	}

	$last_check_index++;
	if($last_check_index >= $bbscore->get_count()){
		$last_check_index=0;
	}

	my $rec = $bbscore->get_from_index($last_check_index);
	my $category_code = $rec->{category};
	my $subcategory_name = $rec->{subcategory};
	my $url = $rec->{url};
	my $tm = $rec->{tm};
	my $fail = $rec->{fail};

	my $session_id = md5_hex(localtime);
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	$session->write('target_class', 'boarder');
	$session->write('target_cat', 	$category_code);
	$session->write('target_scat', 	$subcategory_name);
	$session->write('target_url', 	$url);

	my $param = "ver=2&method=ping&sid=$session_id&cat=$category_code&scat=$subcategory_name&class=owner";
	$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = httprequest("$url$tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});

	my $checked = $session->read('checked');
	
	if($res_code ne 200 or $checked ne 1){
		# Tȏ㎸s폜
		
		$fail++;
		if($fail > 5){
			$bbscore->delete_rec($last_check_index);
		}else{
			$bbscore->update_rec($last_check_index, 'fail', $fail);
		}
	}else{
		# 玸sZbg
		if($fail > 0){
			$bbscore->update_rec($last_check_index, 'fail', 0);
		}
	}
	$bbscore->close();

	if(open(IO, ">$boarder_alive_check_file")){
		my $time = &get_localtime_string();
		print IO "$time\n";
		print IO "$last_check_index\n";
		close(IO);
	}

	$session->clear();
	$filelocker->unlock($boarder_alive_check_file);
}

sub show_menu_cell_html {
	print "Content-type: text/html; charset=Shift_JIS\n\n";

	if(!$filelocker->lock($sig_htmlheadfoot_menu)){
		print btserr(400);
		return;
	}
	my $htmlhead = &read_textfile($htmlhead_menucell_file);
	my $htmlfoot = &read_textfile($htmlfoot_menucell_file);
	$filelocker->unlock($sig_htmlheadfoot_menu);


	if(!$bbscore->open($bbscore->{mode_board})){
		print btserr(400);
		return;
	}

	my $html = '';
	$html .= "<html><head>";
	$html .= "<body TEXT=\"#CC3300\" BGCOLOR=\"#FFFFFF\" link=\"#0000FF\" alink=\"#ff0000\" vlink=\"#660099\">";
	$html .= $htmlhead;

	my $sig1 = get_url_sig($config{'HomeUrl'});

	my %categorys = &get_category_hash();
	foreach my $category_code(sort keys %categorys){
		$html .= "<br><br>" . $categorys{$category_code} . "<br>";

		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->{category} eq $category_code){
				$html .= "<A HREF=\"$rec->{url}$rec->{bm}?s1=$sig1\">$rec->{subcategory}</A><br>";
			}
		}
	}
	$html .= $htmlfoot;
	$html .= "</body></html>";

	print $html;

	$bbscore->close();
}

1;
