# bts_pc.pl
use strict;

our $system_data_dir;

our $bbscore;
our $filelocker;
our %config;
our %input;
our $cellphone_type;

sub execute_bts_pc {
	if($input{'submit'} eq 'VKXbh쐬'){
		&create_thread();
	}elsif($input{'submit'} eq ''){
		&add_response();
	}elsif($input{'m'} eq 'redirect'){
		&show_redirect_html();
	}else{
		if($input{'key'} eq ''){
			if($input{'m'} eq 'new'){
				&show_newthread_html();
			}elsif($input{'m'} eq 'info'){
				&show_info_html();
			}else{
				if($input{'bt'} eq ''){
					&show_2paneframe_html();
				}else{
					&show_threadlist_html();
				}
			}
		}else{
			if($input{'m'} eq 'delres'){
				&show_res_delete_warn_html();
			}elsif($input{'m'} eq 'delth'){
				&show_thread_delete_warn_html();
			}elsif($input{'m'} eq 'delth_apply'){
				&delete_thread();
			}elsif($input{'m'} eq 'delres_apply'){
				&delete_response();
			}else{
				&show_bbs_html();
			}
		}
	}
	&owner_alive_check();
}

sub make_url_link {
	my ($str, $target) = @_;
	$str =~ s/(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<a href="$bts_module_name?m=redirect&url=$1" target="$target">$1<\/a>/g;
	return $str;
}



sub print_header_html {
	my ($title) = @_[0];
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	print "<html><head><title>$title</title>";
	print "<link rel=\"stylesheet\" href=\"resource/css/bts.css\" type=\"text/css\" />";
	print "<meta http-equiv=\"Pragma\" content=\"no-cache\">";
	print "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">";
	print "<meta http-equiv=\"Expires\" content=\"Thu, 01 Dec 1994 16:00:00 GMT\">";
	print "</head>\n";
}

sub print_footer_html {
	print "</html>";
}

sub print_error_html {
	my ($title, $message, $return_title, $return_url) = @_;
	&print_header_html($title);

	print "<body>";
	print "<table width=100% height=100%><tr><td align=center valign=center>";
	print "<table class=\"toplevel\" width=400>";
	print "<tr><th align=\"center\">$title</th></tr>";
	print "<tr><td align=\"center\"><br>$message<br><br>";
	if($return_title eq ""){$return_title="߂";}
	if($return_url eq ""){$return_url="Javascript:history.back();";}
	print "<a href=\"$return_url\">$return_title</a>";
	print "</td></tr></table>";
	print "</td></tr></table>";
	print "</body>";

	&print_footer_html();
}


sub show_2paneframe_html {
	&print_header_html($config{'HomeTitle'});
	print "<frameset rows=\"35%,*\">\n";
	print " <frame src=\"$bts_module_name?bt=bottom_pane\" name=\"top_pane\">\n";
	print " <frame src=\"dummy.html\" name=\"bottom_pane\">\n";
	print "</frameset>\n";
	&print_footer_html();
}

sub show_newthread_html {
	my $sig1 = $input{'s1'};

	&print_header_html("VKXbh쐬");
	print "<body><center>\n";
	print "<table border=1 cellspacing=7 cellpadding=3 width=95% bgcolor=#CCFFCC align=center class=\"toplevel\">\n";
	print "<tr><td>\n";
	print "<form method=POST action=\"$bts_module_name\">";
	print "<td nowrap>\n";
	print "^CgF<input type=text name=subject size=40>";
	print "<input type=submit value=\"VKXbh쐬\" name=submit>";
	print "<input type=button value=\"LZ\" onClick=\"JavaScript:history.back();\">";
	print "<br>\n";
	print "OF<input type=text name=FROM size=19> E-mailF<input type=text name=mail size=19><br>\n";
	print "eF<textarea rows=5 cols=60 wrap=OFF name=MESSAGE></textarea>\n";
	print "<input type=\"hidden\" name=\"bt\" value=\"" . $input{"bt"} . "\">";
	print "<input type=hidden name=s1 value=$sig1>";
	print "</td></tr></form></table>";
	print "</center></body>\n";
	&print_footer_html();
}

sub show_threadlist_html {
	my $bt = $input{'bt'};
	my $sig1 = $input{'s1'};

	if(!$filelocker->lock($sig_htmlheadfoot_board)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $htmlhead = &read_textfile($htmlhead_boardpc_file);
	my $htmlfoot = &read_textfile($htmlfoot_boardpc_file);
	$filelocker->unlock($sig_htmlheadfoot_board);

	my $category_title;
	my %categorys = &get_category_hash();
	if(!$bbscore->open($bbscore->{mode_owner})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if(get_url_sig($rec->{url}) eq $sig1){
			$category_title = $categorys{$rec->{category}} . "-" . $rec->{subcategory};
			last;
		}
	}
	$bbscore->close();

	if(!$bbscore->open($bbscore->{mode_thread})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	&print_header_html('Xbhꗗ');
	print "<body>";
	print $htmlhead;
	print "<table width=100%><tr><td>";
	print $category_title;
	print "</td>";
	print "<td align=right><font size=2>";
	print "<a href=\"$bts_module_name?s1=$sig1&bt=$bt\">[reload]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&m=new&bt=$bt\">[new]</a>";
	print "<a href=\"$bts_module_name?s1=$sig1&m=info&bt=$bt\">[info]</a>";
	print "</font></td></tr></table>";
	print "<table width=100% class=\"toplevel\">";
	print "<tr>";
	print "<th width=50>Rank</th>";
	print "<th>Title</th>";
	print "<th width=50>Res</th>";
	print "<th width=160>LastUpdate</th>";
	print "<th width=50>Del</th>";
	print "</tr>";
	
	my $sig2 = get_url_sig($config{'HomeUrl'});
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		my $formated_time = &format_string_time($rec->{time});
		my $index = $i+1;
		print "<tr>";
		print "<td align=right>$index</td>";
		if($config{'NodeClass'} eq 'boarder'){
			print "<td><a href=\"$rec->{url}$rec->{bm}?s1=$sig1&s2=$sig2&key=$rec->{key}&bt=$bt\" target=\"$bt\">$rec->{title}</a>";
		}else{
			print "<td><a href=\"".$config{'HomeUrl'}.$bts_module_name."?s1=$sig1&s2=$sig2&key=$rec->{key}&bt=$bt\" target=\"$bt\">$rec->{title}</a>";
		}
		print "</td>";
		print "<td align=right><font size=2>$rec->{rescount}</td>";
		print "<td>$formated_time</td>";
		print "<td align=center>";
		if($rec->{deleted} eq 0){
			my $color;
			print "<a href=\"$bts_module_name?s1=$sig1&m=delth&key=$rec->{key}&bt=$bt\">";
			if($rec->{delcount} < 4){
				$color = "#0000ff";
			}elsif($rec->{delcount} < 8){
				$color = "#cccc00";
			}else{
				$color = "#ff0000";
			}
			print "<font color=\"$color\">($rec->{delcount})</font></a>";
		}else{
			print "(*)";
		}
		print "</td>";
		print "</tr>";
	}

	print "</table>";
	print $htmlfoot;
	print "<center>$copyright</center>";
	print "</body>";
	&print_footer_html();

	$bbscore->close();
}

sub show_bbs_html {
	my $key = $input{'key'};
	my $view = $input{'v'};
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};

	if(!$filelocker->lock($sig_htmlheadfoot_bbs)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $htmlhead = &read_textfile($htmlhead_bbspc_file);
	my $htmlfoot = &read_textfile($htmlfoot_bbspc_file);
	$filelocker->unlock($sig_htmlheadfoot_bbs);

	my $menu = "<table width=100%><tr><td>";
	$menu .= "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&v=all\">[all]</a>";
	$menu .= "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&v=last50\">[last50]</a>";
	$menu .= "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&v=top100\">[top100]</a>";
	$menu .= "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&v=$view\">[reload]</a>";
	$menu .= "</td><td align=right>";
	$menu .= "</td></tr></table>";

	if(!$bbscore->response_exist($key)){
		&print_header_html($btserr_title);
		print btserr(315);
		&print_footer_html();
		return;
	}

	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_header_html($btserr_title);
		print btserr(400);
		&print_footer_html();
		return;
	}

	my $rec = $bbscore->get_from_index(0);
	my $title = $rec->{title};

	&print_header_html($title);

	my $count = $bbscore->get_count();
	my $index_start;
	my $index_end;
	if($view eq ""){
		$index_start = $count - 10;
		$index_end = $count - 1;
	}elsif($view eq "last50"){
		$index_start = $count - 50;
		$index_end = $count - 1;
	}elsif($view eq "all"){
		$index_start = 1;
		$index_end = $count - 1;
	}elsif($view eq "top100"){
		$index_start = 1;
		$index_end = 100;
	}
	if($index_start < 1){
		$index_start = 1;
	}
	if($index_end >= $count){
		$index_end = $count - 1;
	}

	print "<body>";
	print $htmlhead;
	print "$menu<br><hr/>";
	print "<b>$title</b><br><br>";

	# Psڂ͏ɕ\
	if($rec->{mail} ne ""){
		print "1 : <b><a href=\"mail:$rec->{mail}\">$rec->{from}</a></b>:$rec->{time_and_id}";
	}else{
		print "1 : <b>$rec->{from}</b>:$rec->{time_and_id}";
	}
	print "<br>";
	my $msg = &make_url_link($rec->{message}, "_blank");
	print "$msg<br><br>\n";

	for(my $i=$index_start; $i<=$index_end; $i++){
		my $rec = $bbscore->get_from_index($i);
		my $line_num = $i + 1;
		if($rec->{mail} ne ""){
			print "$line_num : <b><a href=\"mail:$rec->{mail}\">$rec->{from}</a></b>:$rec->{time_and_id}";
		}else{
			print "$line_num : <b>$rec->{from}</b>:$rec->{time_and_id}";
		}
		if($rec->{ex_deleted} eq 0){
			my $color;
			if($rec->{ex_delcount} < 4){
				$color = "#0000ff";
			}elsif($rec->{ex_delcount} < 8){
				$color = "#cccc00";
			}else{
				$color = "#ff0000";
			}
			print "&nbsp;<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&m=delres&key=$key&num=$i&v=$view\">";
			print "<font color=\"$color\">($rec->{ex_delcount})</font>";
			print "</a>";
		}
		print "<br>";
		$msg = &make_url_link($rec->{message}, "_blank");
		print "$msg<br><br>\n";
	}

	if($bbscore->get_count() < 1000){
		print "<dd><form method=POST action=\"$bts_module_name\">\n";
		print "<input type=hidden name=\"key\" value=\"$key\">\n";
		print "<input type=hidden name=\"s1\" value=\"$sig1\">\n";
		print "<input type=hidden name=\"s2\" value=\"$sig2\">\n";
		print "<input type=submit value=\"\" name=\"submit\">\n";
		print " OF	<input type=text name=FROM size=19>\n";
		print " E-mailF<input type=text name=mail size=19>\n";
		print "<ul><textarea rows=5 cols=64 wrap=OFF name=MESSAGE></textarea></ul>\n";
		print "</form></dd><br>\n";
	}

	print "<hr/>";
	print $menu;
	print $htmlfoot;
	print "<center>$copyright</center>";
	print "</body>";
	&print_footer_html();

	$bbscore->close();
}

sub show_info_html {
	my $bt = $input{'bt'};
	my $sig1 = $input{'s1'};

	my %categorys = &get_category_hash();

	my $threaders=0;
	if($bbscore->open($bbscore->{mode_threader})){
		$threaders = $bbscore->get_count();
		$bbscore->close();
	}

	&print_header_html('');
	print "<body>";
	print "<a href=\"$bts_module_name?s1=$sig1&bt=$bt\">[back]</a><br>";
	print "NodeClass: ".$config{"NodeClass"},"<br>";

	if($bbscore->open($bbscore->{mode_owner})){
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			my $num = $i+1;
			print "OwnerUrl($num):".$rec->{url}."<br>";
			print "OwnerBM($num):".$rec->{bm}."<br>";
			print "OwnerTM($num):".$rec->{tm}."<br>";
			print "OwnerFail($num):".$rec->{fail}."<br>";
		}
		$bbscore->close();
	}
	print "Threaders:".$threaders."<br>";
	print "</body>";

	&print_footer_html();
}

sub show_redirect_html {
	my $url = $input{'url'};
	
	print "Content-type: text/html; charset=Shift_JIS\n\n";
	my $html = &read_textfile($redirect_temp_pc);
	$html =~ s/%URL%/$url/g;
	print $html;
}

sub show_thread_delete_warn_html {
	my $key = $input{'key'};
	my $bt = $input{'bt'};
	my $sig1 = $input{'s1'};

	if(!$bbscore->open($bbscore->{mode_thread})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	
	my $index = $bbscore->get_thread_index_from_key($key);
	my $rec = $bbscore->get_from_index($index);

	&print_header_html("Xbh폜");
	print "<body>";
	print "ȉ̃Xbh폜ɓ[܂B<br>";
	print "$rec->{title}<br><br>";
	print "xF<br>";
	print "POlȏ̓[ɂ폜܂B[͂Pxo܂B<br>";
	print "낵Γ[{^ĂB<br>";
	print "<br><form method=POST action=\"$bts_module_name\">";
	print "<input type=hidden name=key value=\"$key\">";
	print "<input type=hidden name=m value=\"delth_apply\">";
	print "<input type=hidden name=bt value=\"" . $input{"bt"} . "\">";
	print "<input type=hidden name=s1 value=\"$sig1\">";
	print "<input type=submit value=\"[\">";
	print "</form>";
	print "<br>";
	print "<a href=\"$bts_module_name?s1=$sig1&bt=$bt\">[߂]</a><br>";
	print "</body>";
	&print_footer_html();

	$bbscore->close();
}

sub show_res_delete_warn_html {
	my $key = $input{'key'};
	my $num = $input{'num'};
	my $view = $input{'v'};
	my $sig1 = $input{'s1'};
	my $sig2 = $input{'s2'};

	# X̓ǂݍ
	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $rec = $bbscore->get_from_index($num);

	my $line_num = $num + 1;
	&print_header_html("e̍폜");
	print "<body>";
	print "ȉ̓e폜ɓ[܂B<br>";
	print "$line_num : <b>$rec->{from}</b>:$rec->{time_and_id}<br>";
	print "$rec->{message}<br><br>";
	print "xF<br>";
	print "POlȏ̓[ɂ폜܂B[͂Pxo܂B<br>";
	print "낵Γ[{^ĂB<br>";
	print "<br><form method=POST action=\"$bts_module_name\">";
	print "<input type=hidden name=key value=\"$key\">";
	print "<input type=hidden name=num value=\"$num\">";
	print "<input type=hidden name=m value=\"delres_apply\">";
	print "<input type=hidden name=s1 value=\"$sig1\">";
	print "<input type=hidden name=s2 value=\"$sig2\">";
	print "<input type=submit value=\"[\">";
	print "</form>";
	print "<br>";
	print "<a href=\"$bts_module_name?s1=$sig1&s2=$sig2&key=$key&v=$view\">[߂]</a><br>";
	print "</body>";
	&print_footer_html();

	$bbscore->close();
}

1;
