# bts_share.pl
use strict;

our $system_data_dir;

our $bbscore;
our $filelocker;
our %config;
our %input;
our $cellphone_type;

sub gen_response_id {
	my $remote_host = &get_remote_host();
	my $day = substr(&get_localtime_string(), 0, 8);
	my $digest = md5_base64($remote_host . $day . $config{'HomeUrl'});
	$digest = substr($digest, 0, 10);
	return $digest;
}

sub create_thread {
	if(ipfilter(get_remote_host(), $compiled_iptable_user_file) eq 1){
		&print_error_html($btserr_title, btserr(401));
		return;
	}

	my $subject = $input{'subject'};
	my $from = $input{'FROM'};
	my $mail = $input{'mail'};
	my $message = $input{'MESSAGE'};

	$subject = jcode($subject)->sjis;
	$from = jcode($from)->sjis;
	$mail = jcode($mail)->sjis;
	$message = jcode($message)->sjis;

	my $err = &check_post_error(1, $subject, $from, $mail, $message);
	if($err ne 200){
		&print_error_html($btserr_title, btserr($err));
		return;
	}
	
	if(!$bbscore->open($bbscore->{mode_threader})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	my $target_tracker;
	my $remote;
	my $target_url;
	my $target_bm;
	my $target_tm;
	if($bbscore->get_count() eq 0){
		$target_tracker = $config{'HomeUrl'} . $tracker_module_name;
		$remote=0;
	}else{
		srand(time);
		my $threaders_count = $bbscore->get_count();
		my $index = int(rand $threaders_count);
		
		my $rec = $bbscore->get_from_index($index);
		$target_tracker = $rec->{url} . $rec->{tm};
		$target_url = $rec->{url};
		$target_bm = $rec->{bm};
		$target_tm = $rec->{tm};
		if($rec->{url} eq $config{'HomeUrl'}){
			$remote=0;
		}else{
			$remote=1;
		}
	}
	$bbscore->close();

	my $key = &get_localtime_string();
	my $param = "ver=2&method=crth&key=$key&subject=$subject&from=$from&mail=$mail&message=$message&defn=" . $config{'DefaultName'};
	$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest($target_tracker, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	
	# Ȍꍇ
	if($remote eq 1){
		if(!$bbscore->open($bbscore->{mode_threader})){
			&print_error_html($btserr_title, btserr(400));
			return;
		}
		my $index=-1;
		my $fail_count;
		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->{url} eq $target_url){
				$index = $i;
				$fail_count = $rec->{fail};
				last;
			}
		}
		if($res_code eq 500){ # T[o[G[̏ꍇ
			$fail_count++;
			if($fail_count < 6){
				# s񐔂XV
				$bbscore->update_rec($index, 'fail', $fail_count);
			}else{
				# Xb_[𖕏
				$bbscore->delete_rec($index);
			}
			$bbscore->close();
		}else{
			# sZbg
			if($fail_count > 0){
				$bbscore->update_rec($index, 'fail', 0);
			}
		}
		$bbscore->close();

	}

	if($remote eq 1 and $res_code ne 200){
		# [gs烍[Jɍ쐬
		my $key = &get_localtime_string();
		my $param = "ver=2&method=crth&key=$key&subject=$subject&from=$from&mail=$mail&message=$message&defn=" . $config{'DefaultName'};
		$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
		my ($res_code, $res_message) = &httprequest($config{'HomeUrl'} . $tracker_module_name, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
		if($res_code ne 200){
			# [Jɂ玸s
			&print_error_html($btserr_title, $res_message);
			return;
		}
	}

	if($remote eq 1 and $res_code eq 200){
		# [gꍇ
		if($bbscore->open($bbscore->{mode_thread})){
			$bbscore->insert_rec(0,
				BTS::Record::Thread->new(
					$key,
					$target_url,
					$target_bm,
					$target_tm,
					$subject,
					1,
					$key,
					0,
					0,
					""
				)
			);
			my $maxlog = $input{'MaxLog'};
			if($config{'NodeClass'} eq 'boarder'){
				# {[_[Oێ1000Œ
				$maxlog = 1000;
			}
			$bbscore->delete_thread_with_maxlog($maxlog);
			$bbscore->close();
		}
	}

	$bbscore->build_subject_txt($subject_txt_file);

	my $return_url = $bts_module_name;
	$return_url = make_query($return_url, 'bt', $input{'bt'});
	$return_url = make_query($return_url, 's1', $input{'s1'});
	&print_error_html('쐬', 'Xbh쐬', '߂', $return_url);
}

sub delete_thread {
	if(ipfilter(get_remote_host(), $compiled_iptable_user_file) eq 1){
		&print_error_html($btserr_title, btserr(401));
		return;
	}

	my $key = $input{"key"};
	my $remote_host = &get_remote_host();

	if(!$bbscore->open($bbscore->{mode_thread})){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	my $index = $bbscore->get_thread_index_from_key($key);
	if($index < 0){
		&print_error_html($btserr_title, btserr(303));
		return;
	}
	my $rec = $bbscore->get_from_index($index);
	my $target_tracker = $rec->{url}.$rec->{tm};
	my $target_url = $rec->{url};
	$bbscore->close();

	my $session_id = md5_hex(localtime);
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	$session->write('key', $key);
	$session->write('host', $remote_host);

	my $param = "ver=2&method=dlth&key=$key&host=$remote_host&sid=$session_id";
	$param .= "&url=" . $config{"HomeUrl"} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest($target_tracker, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		&print_error_html($btserr_title, $res_message);
		return;
	}
	
	if($target_url ne $config{'HomeUrl'}){
		my $checked = $session->read('checked');
		if($checked ne 1){
			&print_error_html($btserr_title, btserr(304));
			return;
		}

		if(!$bbscore->open($bbscore->{mode_thread})){
			&print_error_html($btserr_title, btserr(400));
			return;
		}
		
		my $delcount = $session->read('delcount');
		my $deleted = $session->read('deleted');

		my $index = $bbscore->get_thread_index_from_key($key);
		$bbscore->update_rec($index, 'delcount', $delcount);
		$bbscore->update_rec($index, 'deleted', $deleted);
		if($deleted eq 1){
			$bbscore->update_rec($index, 'title', 'ځ`');
		}
		$bbscore->close();
	}
	$session->clear();

	$bbscore->build_subject_txt($subject_txt_file);

	my $return_url;
	$return_url = make_query($return_url, 's1', $input{'s1'});
	$return_url = make_query($return_url, 's2', $input{'s2'});
	$return_url = make_query($return_url, 'bt', $input{'bt'});
	&print_error_html('bZ[W', '폜JEg', '߂', $return_url);
}

sub delete_response {
	if(ipfilter(get_remote_host(), $compiled_iptable_user_file) eq 1){
		&print_error_html($btserr_title, btserr(401));
		return;
	}

	my $key = $input{'key'};
	my $num = $input{'num'};

	my $remote_host = &get_remote_host();
	my $lastid = substr(md5_hex($remote_host), 0, 10);

	if($num eq ""){$num=0;}
	if($num < 0){
		&print_error_html($btserr_title, btserr(303));
		return;
	}
	if(!$bbscore->response_exist($key)){
		&print_error_html($btserr_title, btserr(303));
		return;
	}
	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}
	if($num >= $bbscore->get_count()){
		$bbscore->close();
		&print_error_html($btserr_title, btserr(303));
		return;
	}
	
	my $rec = $bbscore->get_from_index($num);
	if($lastid eq $rec->{ex_lastid} and $lastid ne ""){
		$bbscore->close();
		&print_error_html($btserr_title, btserr(346));
		return;
	}

	if($rec->{ex_deleted} eq 0){
		my $delcount = $rec->{ex_delcount};
		$delcount++;
		if($delcount >= 10){
			$bbscore->update_rec($num, 'from', 		'ځ`');
			$bbscore->update_rec($num, 'mail', 		'');
			$bbscore->update_rec($num, 'time_and_id',	'ځ`');
			$bbscore->update_rec($num, 'message', 		'ځ`');
			$bbscore->update_rec($num, 'ex_deleted', 	1);
		}else{
			$bbscore->update_rec($num, 'ex_delcount', 	$delcount);
			$bbscore->update_rec($num, 'ex_lastid', 	$lastid);
		}
	}
	$bbscore->close();

	my $return_url = $bts_module_name;
	$return_url = make_query($return_url, 's1', $input{'s1'});
	$return_url = make_query($return_url, 's2', $input{'s2'});
	$return_url = make_query($return_url, 'key', $key);
	&print_error_html('bZ[W', '폜JEg', '߂', $return_url);
}

sub add_response {
	if(ipfilter(get_remote_host(), $compiled_iptable_user_file) eq 1){
		&print_error_html($btserr_title, btserr(401));
		return;
	}

	my $key = $input{'key'};
	my $from = $input{'FROM'};
	my $mail = $input{'mail'};
	my $message = $input{'MESSAGE'};

	$from = jcode($from)->sjis;
	$mail = jcode($mail)->sjis;
	$message = jcode($message)->sjis;

	if($key eq ""){
		&print_error_html($btserr_title, btserr(303));
		return;
	}

	my $err = &check_post_error(0, '', $from, $mail, $message);
	if($err ne 200){
		&print_error_html($btserr_title, btserr($err));
		return;
	}

	$message = &escape_html_tags($message);
	$message =~ s/\r\n/<br>/g;
	$message =~ s/\n/<br>/g;
	$from = &escape_html_tags($from);
	$from = &get_crypted_name($from);

	my $age;
	if($mail ne 'sage'){
		$age = 1;
	}else{
		$age = 0;
	}

	my $remote_host = &get_remote_host();
	my $time = &get_localtime_string();
	my $time_and_id = &format_string_time($time) . ' ID: ' . &gen_response_id();

	if(!$bbscore->response_exist($key)){
		&print_error_html($btserr_title, btserr(303));
		return;
	}
	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		&print_error_html($btserr_title, btserr(400));
		return;
	}

	if($bbscore->get_count() >= 1000){
		&print_error_html($btserr_title, btserr(317));
		return;
	}

	my $rec = $bbscore->get_from_index(0);
	my $defname = $rec->{default_name};
	if($from eq ""){$from = $defname;}
	$rec = $bbscore->get_from_index($bbscore->get_count() -1);

	$bbscore->append_rec(
		BTS::Record::Response->new(
			$from,
			$mail,
			$time_and_id,
			$message,
			'',
			'',
			'',
			0,
			0,
			''
		)
	);
	my $rescount = $bbscore->get_count();
	$bbscore->close();

	my $target_tracker;
	my $lasttime;
	my $mins_before = &get_localtime_string(-60 * 5);
	if($bbscore->open($bbscore->{mode_thread})){
		my $index = $bbscore->get_thread_index_from_key($key);
		my $rec = $bbscore->get_from_index($index);
		$target_tracker = $rec->{url}.$rec->{tm};
		$lasttime = $rec->{time};
		if($lasttime < $mins_before){
			# 5ȏȂXV
			$bbscore->update_rec($index, 'time', $time);
			$bbscore->update_rec($index, 'rescount', $rescount);
		}
	}
	$bbscore->close();

	if($lasttime < $mins_before or $rescount eq 1000){
		# 5ȓ݂̏Ȃ琨Ǝv̂ŕ񍐂Ȃ
		# XVv𔭍s@ʂ͖
		my $param = "ver=2&method=upth&up=$age&count=$rescount&key=$key&time=$time";
		$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
		my ($res_code, $res_message) = &httprequest($target_tracker, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	}

	my $return_url = $bts_module_name;
	$return_url = make_query($return_url, 's1', $input{'s1'});
	$return_url = make_query($return_url, 's2', $input{'s2'});
	$return_url = make_query($return_url, 'key', $key);
	&print_error_html('bZ[W', 'I', '߂', $return_url);
}

sub owner_alive_check {
	if($config{'NodeClass'} ne 'boarder' and $config{'NodeClass'} ne 'threader'){
		return;
	}
	if(!$filelocker->lock($owner_alive_check_file)){
		return;
	}

	my @lines;
	if(open(IO, '<'.$owner_alive_check_file)){
		@lines = <IO>;
		close(IO);
	}
	my $last_check_time = $lines[0];
	my $last_check_index = $lines[1];
	my $need_check_time = &get_localtime_string(-1 * 60 * 60 * 24);
	if($need_check_time < $last_check_time){
		$filelocker->unlock($owner_alive_check_file);
		return;
	}

	if(!$bbscore->open($bbscore->{mode_owner})){
		$filelocker->unlock($owner_alive_check_file);
		return;
	}
	if($bbscore->get_count() eq 0){
		$filelocker->unlock($owner_alive_check_file);
		return;
	}
	$last_check_index++;
	if($last_check_index >= $bbscore->get_count()){
		$last_check_index=0;
	}
	my $rec = $bbscore->get_from_index($last_check_index);

	my $session_id = md5_hex(localtime);
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	my $owner_tracker = $rec->{url}.$rec->{tm};

	my $fail = 0;
	if($config{'NodeClass'} eq 'boarder'){
		my $category_code = $rec->{category};
		my $subcategory_name = $rec->{subcategory};
		
		my $param = "ver=2&method=ping&class=boarder&cat=$category_code&scat=$subcategory_name&sid=$session_id";
		$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
		my ($res_code, $res_message) = &httprequest($owner_tracker, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
		if($res_code ne 200){
			$fail = 1;
		}
	}
	if($config{'NodeClass'} eq 'threader'){
		my $param = "ver=2&method=ping&class=threader&sid=$session_id";
		$param .= "&url=" . $config{"HomeUrl"} . "&bm=$bts_module_name&tm=$tracker_module_name";
		my ($res_code, $res_message) = &httprequest($owner_tracker, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
		if($res_code ne 200){
			$fail = 1;
		}
	}

	my $checked = $session->read('checked');
	if($checked ne 1){
		$fail = 1;
	}

	my $fail_count = $rec->{fail};
	if($fail eq 1){
		# AT񎸔s珊𖕏
		$fail_count++;
		if($fail_count > 5){
			$config{'NodeClass'} = 		'none';
			$bbscore->delete_rec($last_check_index);
			if($bbscore->get_count() eq 0){
				$config{'HaveOwner'} =		 0;
			}
		}
		if($filelocker->lock($config_file)){
			&write_config($config_file, %config);
			$filelocker->unlock($config_file);
		}
	}else{
		# ڑo玸sZbg
		if($fail_count > 0){
			$bbscore->update_rec($last_check_index, 'fail', 0);
		}
	}
	$bbscore->close();

	if(open(IO, '>'.$owner_alive_check_file)){
		my $time = &get_localtime_string();
		print IO "$time\n";
		close(IO);
	}

	$filelocker->unlock($owner_alive_check_file);
	$session->clear();
}


1;
