#!/usr/bin/perl
use strict;

our $system_data_dir;

use lib './lib';
require './lib/cgi-lib.pl';
require './btsconf.pl';
use BTS::Statics;
use BTS::Common;
use BTS::Error;
use BTS::Session;
use BTS::FileLocker;
use BTS::BBSCore;
use BTS::HttpRequest;
use BTS::Logger;
use KCatch;

use Jcode;
use Digest::MD5  qw(md5 md5_hex md5_base64);

&initialize_statics($system_data_dir);

our %input;
&ReadParse(\%input);

print "Content-type: text/plain; charset=Shift_JIS\n\n";

our %config;
our $filelocker = BTS::FileLocker->new($locker_temp_dir);
if($filelocker->lock($config_file)){
	%config = &read_config($config_file);
	$filelocker->unlock($config_file);
}else{
	print btserr(400);
	exit;
}
our $bbscore = BTS::BBSCore->new(
	$filelocker,
	$ownerlist_file,
	$boarderlist_file,
	$threadlist_file,
	$threaderlist_file,
	$datfile_dir,
	$config{'MaxLog'}
); 
our $logger = BTS::Logger->new(
	$filelocker,
	$log_dir,
	$config{'LogHoldDays'}
);

if(ipfilter(get_remote_host(), $compiled_iptable_bts_file) eq 1){
	print btserr(401);
	exit;
}

our $ver = $input{'ver'};
our $method = $input{'method'};
our $bm = $input{'bm'};
our $tm = $input{'tm'};
our $remote_url = $input{'url'};

if(ipfilter($remote_url, $compiled_urltable_bts_file) eq 1){
	print btserr(401);
	exit;
}

if($ver eq 2){
	if($method eq 'rgct'){
		&regist_category();
	}elsif($method eq 'rgcb'){
		&regist_category_back();
	}elsif($method eq 'rgth'){
		&regist_threader();
	}elsif($method eq 'rgt2'){
		&regist_threader2();
	}elsif($method eq 'rgtb'){
		&regist_threader_back();
	}elsif($method eq 'rtb2'){
		&regist_threader_back2();
	}elsif($method eq 'crth'){
		&create_thread();
	}elsif($method eq 'upth'){
		&update_thread();
	}elsif($method eq 'dlth'){
		&delete_thread();
	}elsif($method eq 'dltb'){
		&delete_thread_back();
	}elsif($method eq 'ping'){
		&recv_ping();
	}elsif($method eq 'pong'){
		&recv_pong();
	}elsif($method eq 'gett'){
		&get_table();
	}elsif($method eq 'gttb'){
		&get_table_back();
	}
}else{
	print btserr(500);
}

# JeSo^s[U[Ăяo
sub regist_category {
	my $session_id = $input{'sid'};
	my $category_code = $input{'cat'};
	my $subcategory_name = $input{'scat'};
	my $title = $input{"title"};

	my $remote_host = &get_remote_host();
	$logger->write("regist category request ($category_code, $subcategory_name) from $remote_url($remote_host)");
	
	$subcategory_name = jcode($subcategory_name)->sjis;
	$title = jcode($title)->sjis;

	if($config{'EnableTop'} eq 1){
		print btserr(341);
		return;
	}
	if($config{'NodeClass'} eq 'threader'){
		print btserr(342); # Xb_[̓{[_[ɂ͂ȂȂ
		return;
	}

	if($config{'HaveOwner'} eq 1){
		if(!$bbscore->open($bbscore->{mode_owner})){
			print btserr(400);
			return;
		}

		if($bbscore->get_count() >= $ownerlimit){
			print btserr(342); # ȏQoȂ
			$bbscore->close();
			return;
		}

		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->{url} eq $remote_url){
				print btserr(342); # ɓo^
				$bbscore->close();
				return;
			}
		}
		$bbscore->close();
	}

	if(!$bbscore->open($bbscore->{mode_threader})){
		print btserr(400);
		return;
	}
	my $threader_count = $bbscore->get_count();
	$bbscore->close();

	my $param = "ver=2&method=rgcb&sid=$session_id&tcnt=$threader_count";
	$param .= "&url=" . $config{"HomeUrl"} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest("$remote_url/$tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});	
	if($res_code ne 200){
		print $res_message;
		return;
	}

	# m[hXV
	$config{'HaveOwner'} = 		1;
	$config{'NodeClass'} = 		'boarder';

	if($filelocker->lock($config_file)){
		&write_config($config_file, %config);
		$filelocker->unlock($config_file);
	}else{
		print btserr(400);
		return;
	}

	# I[i[o^
	if(!$bbscore->open($bbscore->{mode_owner})){
		print btserr(400);
		return;
	}
	$bbscore->append_rec(
		BTS::Record::Owner->new(
			$title,
			$category_code,
			$subcategory_name,
			$remote_url,
			$bm,
			$tm,
			0
		)
	);
	$bbscore->close();

	print btserr(200);
}

# gbvǗ҂փR[obN
sub regist_category_back {
	my $session_id = $input{'sid'};
	my $threader_count = $input{'tcnt'};
	
	if($config{'EnableTop'} eq 0){
		print btserr(341);
		return;
	}

	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	my $remote_tracker = $session->read('remote_tracker');
	my $category_code = $session->read('category_code');
	my $subcategory_name = $session->read('subcategory_name');

	if($remote_tracker ne "$remote_url$tm"){
		print btserr(302);
		return;
	}
	if($tm eq '' or $bm eq '' or $remote_url eq ''){
		print btserr(303);
		return;
	}
	if($category_code eq '' or $subcategory_name eq ''){
		print btserr(304);
		return;
	}
	if(length($subcategory_name) > 18){
		print btserr(305);
		return;
	}
	if(is_existed_category($category_code) eq 0){
		print btserr(306);
		return;
	}

	$session->write('checked', 1);
	$session->write('url', $remote_url);
	$session->write('bm', $bm);
	$session->write('tm', $tm);
	$session->write('threader_count', $threader_count);

	print btserr(200);
}

# Xb_[Qo^i{[_[j
sub regist_threader {
	my $target_url = $input{'target'};
	my $session_id = $input{'sid'};

	if($config{'NodeClass'} ne 'boarder'){
		print btserr(343);
		return;
	}
	if($target_url eq ''){
		print btserr(303);
		return;
	}

	my $old_session_id = $session_id;
	my $session_id = md5_hex(localtime);
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	$session->write('caller_url', $remote_url);
	$session->write('caller_bm', $bm);
	$session->write('caller_tm', $tm);
	$session->write('target', $target_url);
	$session->write('sid', $old_session_id);

	my $param = "ver=2&method=rgt2&sid=$session_id&cat=" . $config{'NodeCategory'} . "&scat=". $config{'NodeSubCategory'} . "&title=" . $config{'OwnerTitle'};
	$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest($target_url, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		print $res_message;
		return;
	}
	
	my $checked = $session->read('checked');
	if($checked ne 1){
		print btserr(304);
		return;
	}

	my $user_url = $session->read('url');
	my $user_bm = $session->read('bm');
	my $user_tm = $session->read('tm');

	if(!$bbscore->open($bbscore->{mode_threader})){
		print btserr(400);
		return;
	}
	$bbscore->append_rec(
		BTS::Record::Threader->new(
			$user_url,
			$user_bm,
			$user_tm,
			0
		)
	);
	$bbscore->close();
	$session->clear();

	print btserr(200);
}

# Xb_[Qo^iXb_[j
sub regist_threader2 {
	my $owner_category = $input{'cat'};
	my $owner_subcategory = $input{'scat'};
	my $owner_title = $input{'title'};
	my $session_id = $input{'sid'};

	$owner_category = jcode($owner_category)->sjis;
	$owner_subcategory = jcode($owner_subcategory)->sjis;
	$owner_title = jcode($owner_title)->sjis;
	
	if($config{'EnableTop'} eq 1){
		print btserr(341);
		return;
	}
	if($config{'NodeClass'} eq 'boarder'){
		print btserr(342); # {[_[̓Xb_[ɂ͂ȂȂ
		return;
	}

	if($config{'HaveOwner'} eq 1){
		if(!$bbscore->open($bbscore->{mode_owner})){
			print btserr(400);
			return;
		}

		if($bbscore->get_count() >= $ownerlimit){
			print btserr(342); # ȏQoȂ
			$bbscore->close();
			return;
		}

		foreach (my $i=0;$i<$bbscore->get_count();$i++){
			my $rec = $bbscore->get_from_index($i);
			if($rec->url eq $remote_url){
				print btserr(342); # ɓo^
				$bbscore->close();
				return;
			}
		}
		$bbscore->close();
	}

	my $param = "ver=2&method=rgtb&sid=$session_id";
	$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest("$remote_url$tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		print $res_message;
		return;
	}
	
	if($filelocker->lock($config_file)){
		$config{'HaveOwner'} = 1;
		$config{'NodeClass'} = 'threader';
		&write_config($config_file, %config);
		$filelocker->unlock($config_file);
	}else{
		print btserr(400);
		return;
	}

	# I[i[o^
	if(!$bbscore->open($bbscore->{mode_owner})){
		print btserr(400);
		return;
	}
	$bbscore->append_rec(
		BTS::Record::Owner->new(
			$owner_title,
			$owner_category,
			$owner_subcategory,
			$remote_url,
			$bm,
			$tm,
			0
		)
	);
	$bbscore->close();

	print btserr(200);
}

# Xb_[R[obNi{[_[j
sub regist_threader_back {
	my $session_id = $input{'sid'};
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	my $caller_url = $session->read('caller_url');
	my $caller_bm = $session->read('caller_bm');
	my $caller_tm = $session->read('caller_tm');
	my $target = $session->read('target');
	my $old_session_id = $session->read('sid');

	if($target ne "$remote_url$tm"){
		print btserr(302);
		return;
	}

	# do^`FbN
	if(!$bbscore->open($bbscore->{mode_threader})){
		print btserr(400);
		return;
	}
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($rec->{url} eq $remote_url){
			$bbscore->close();
			print btserr(319);
			return;
		}
	}
	my $count = $bbscore->get_count() + 1;
	$bbscore->close();
	

	# o^̃Xb_[gbvy[Wɒʒm
	my $param = "ver=2&method=rtb2&&sid=$old_session_id&tcnt=$count";
	$param .= "&url=" . $config{'HomeUrl'} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest("$caller_url$caller_tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		print $res_message;
		return;
	}

	# gbvy[WȂZbVXV
	$session->write('checked', 1);
	$session->write('url', $remote_url);
	$session->write('bm', $bm);
	$session->write('tm', $tm);

	print btserr(200);
}

# b_[ʒmiI[i[j
sub regist_threader_back2 {
	my $threader_count = $input{'tcnt'};
	my $session_id = $input{'sid'};

	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	my $remote_tracker = $session->read('remote_tracker');
	my $category_code = $session->read('category_code');
	my $subcategory_name = $session->read('subcategory_name');

	if($config{'EnableTop'} ne 1){  # gbvy[W@\
		print btserr(344);
		return;
	}

	$session->write('checked', 1);
	$session->write('threader_count', $threader_count);

	print btserr(200);
}

# Xbh쐬˗iXb_[j
sub create_thread {
	my $subject = $input{'subject'};
	my $from = $input{'from'};
	my $mail = $input{'mail'};
	my $default_name = $input{'defn'};
	my $message = $input{'message'};
	my $key = $input{'key'};

	$subject = jcode($subject)->sjis;
	$from = jcode($from)->sjis;
	$mail = jcode($mail)->sjis;
	$default_name = jcode($default_name)->sjis;
	$message = jcode($message)->sjis;

	$subject = &erase_enter($subject);
	$from = &erase_enter($from);
	$mail = &erase_enter($mail);
	$default_name = &erase_enter($default_name);

	# I[i[ĝݍ쐬\
	my $existed_owner=0;
	if(!$bbscore->open($bbscore->{mode_owner})){
		print btserr(400);
		return;
	}
	foreach (my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($rec->{'url'} eq $remote_url){
			$existed_owner = 1;
			last;
		}
	}
	$bbscore->close();
	if($existed_owner eq 0 and $remote_url ne $config{'HomeUrl'}){
		# EĂȂ玀S
		print btserr(500);
		return;
	}

	if($key eq ""){
		print btserr(303);
		return;
	}
	if($default_name eq ""){
		$default_name = '';
	}
	if($from eq ""){
		$from = $default_name;
	}

	my $err = &check_post_error(1, $subject, $from, $mail, $message);
	if($err ne 200){
		print btserr($err);
		return;
	}

	$message = &escape_html_tags($message);
	$message =~ s/\r\n/<br>/g;
	$message =~ s/\n/<br>/g;
	$from = &escape_html_tags($from);
	$from = &get_crypted_name($from);
	$subject = &erase_enter($subject);
	$subject = &escape_html_tags($subject);
	
	if(!$bbscore->open($bbscore->{mode_thread})){
		print btserr(400);
		return;
	}
	$bbscore->insert_rec(0,
		BTS::Record::Thread->new(
			$key,
			$remote_url,
			$bm,
			$tm,
			$subject,
			1,
			$key,
			0,
			0,
			""
		)
	);
	my $maxlog = $config{'MaxLog'};
	if($config{'NodeClass'} eq 'boarder'){
		# {[_[Oێ1000Œ
		$maxlog = 1000;
	}
	$bbscore->delete_thread_with_maxlog($maxlog);
	$bbscore->close();
	if(!$bbscore->open($bbscore->{mode_response}, $key)){
		print btserr(400);
		return;
	}
	my $formated_time = &get_formated_localtime_string(0);
	$bbscore->append_rec(
		BTS::Record::Response->new(
			$from,
			$mail,
			"$formated_time ID:???",
			$message,
			$subject,
			$default_name,
			$config{'HomeUrl'}.$bts_module_name,
			0,
			0,
			""
		)
	);
	$bbscore->close();

	print btserr(200);
}

sub update_thread {
	my $key = $input{'key'};
	my $age = $input{'age'};
	my $count = $input{'count'};
	my $time = $input{'time'};

	if($config{'NodeClass'} ne 'boarder'){
		print btserr(303);
		return;
	}

	if(!$bbscore->open($bbscore->{mode_thread})){
		print btserr(400);
		return;
	}
	foreach(my $i=0;$i<$bbscore->get_count();$i++){
		my $rec = $bbscore->get_from_index($i);
		if($rec->{key} eq $key){
			$bbscore->update_rec($i, 'rescount', $count);
			$bbscore->update_rec($i, 'time', $time);
			$bbscore->age_thread($i, $age);
			last;
		}
	}
	$bbscore->close();

	$bbscore->build_subject_txt($subject_txt_file);

	print btserr(200);

}

sub delete_thread {
	my $key = $input{'key'};
	my $remote_host = $input{'host'};
	my $session_id = $input{'sid'};

	if(!$bbscore->open($bbscore->{mode_thread})){
		print btserr(400);
		return;
	}
	my $index = $bbscore->get_thread_index_from_key($key);
	if($index < 0){
		$bbscore->close();
		print btserr(303);
		return;
	}
	my $rec = $bbscore->get_from_index($index);
	my $target_url = $rec->{url};
	my $target_tm = $rec->{tm};
	my $delcount = $rec->{delcount} + 1;
	my $deleted;
	if($delcount > 10){
		$deleted = 1;
	}else{
		$deleted = 0;
	}
	$bbscore->close();
	
	# Ǘ҂ɍ폜\ʒmċႤ
	my $param = "ver=2&method=dltb&key=$key&&host=$remote_host&delcount=$delcount&deleted=$deleted&sid=$session_id";
	$param .= "&url=" . $config{"HomeUrl"} . "&bm=$bts_module_name&tm=$tracker_module_name";
	my $target_tracker = "$target_url$target_tm";
	my ($res_code, $res_message) = &httprequest($target_tracker, $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		print $res_message;
		return;
	}

	my $lastid = substr(md5_hex($remote_host), 0, 10);
	if(!$bbscore->open($bbscore->{mode_thread})){
		print btserr(400);
		return;
	}
	my $index = $bbscore->get_thread_index_from_key($key);
	my $rec = $bbscore->get_from_index($index);
	if($rec->{lastid} eq $lastid){
		print btserr(346);
		$bbscore->close();
		return;
	}
	if($delcount >= 10){
		$bbscore->update_rec($index, 'delcount', $delcount);
		$bbscore->update_rec($index, 'deleted', 1);
		$bbscore->update_rec($index, 'title', 'ځ`');
		$bbscore->update_rec($index, 'rescount', 0);
		$bbscore->update_rec($index, 'time', &get_localtime_string());
		$bbscore->response_delete($key);
	}else{
		$bbscore->update_rec($index, 'delcount', $delcount);
		$bbscore->update_rec($index, 'lastid', $lastid);
	}
	$bbscore->close();
	
	print btserr(200);
}

sub delete_thread_back {
	my $key = $input{'key'};
	my $remote_host = $input{'host'};
	my $delcount = $input{'delcount'};
	my $deleted = $input{'deleted'};
	my $session_id = $input{'sid'};

	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);
	my $s_key = $session->read('key');
	my $s_remote_host = $session->read('host');

	if($s_remote_host ne $remote_host){
		print btserr(304);
		return;
	}
	if($s_key ne $key){
		print btserr(304);
		return;
	}
	
	$session->write('checked', 1);
	$session->write('delcount', $delcount);
	$session->write('deleted', $deleted);

	print btserr(200);
}

sub recv_ping {
	my $cat = $input{'cat'};
	my $scat = $input{'scat'};
	my $sid = $input{'sid'};
	my $class = $input{'class'};

	$scat = jcode($scat)->sjis;

	if($class ne 'owner' and $class ne 'boarder' and $class ne 'threader'){
		print btserr(303);
		return;
	}
	# I[i[{[_[
	if($class eq 'owner'){
		if($bbscore->open($bbscore->{mode_owner})){
			my $existed_owner=0;
			foreach (my $i=0;$i<$bbscore->get_count();$i++){
				my $rec = $bbscore->get_from_index($i);
				if($rec->{url} eq $remote_url and $rec->{category} eq $cat and $rec->{subcategory} eq $scat){
					$existed_owner=1;
					last;
				}
			}
			$bbscore->close();
			if($existed_owner eq 0){
				print btserr(303);
				return;
			}
		}
	}

	# {[_[I[i[
	if($class eq 'boarder'){
		if($bbscore->open($bbscore->{mode_board})){
			my $found = 0;
			foreach (my $i=0;$i<$bbscore->get_count();$i++){
				my $rec = $bbscore->get_from_index($i);
				if($rec->{url} eq $remote_url and $rec->{category} eq $cat and $rec->{subcategory} eq $scat){
					$found = 1;
					last;
				}
			}
			$bbscore->close();

			if($found eq 0){
				print btserr(303);
				return;
			}
		}
	}

	# Xb_[{[_[
	if($class eq 'threader'){
		if($bbscore->open($bbscore->{mode_threader})){
			my $found = 0;
			foreach (my $i=0;$i<$bbscore->get_count();$i++){
				my $rec = $bbscore->get_from_index($i);
				if($rec->{url} eq $remote_url){
					$found = 1;
					last;
				}
			}
			$bbscore->close();

			if($found eq 0){
				print btserr(303);
				return;
			}
		}
	}

	my $param = "ver=2&method=pong&sid=$sid&class=$class";
	$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest("$remote_url$tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		print $res_message;
		return;
	}
	print btserr(200);
}

sub recv_pong {
	my $session_id = $input{'sid'};
	my $session=BTS::Session->new($filelocker, $session_temp_file, $session_id);

	$session->write('checked', 1);

	print btserr(200);
}

sub get_table {
	my $type = $input{'type'};
	my $sid = $input{'sid'};

	my $table;
	if($type eq 'urlbts'){
		if($filelocker->lock($urltable_bts_file)){
			$table = &read_textfile($urltable_bts_file);
			$filelocker->unlock($urltable_bts_file);
		}else{
			print btserr(400);
			return;
		}
	}elsif($type eq 'ipbts'){
		if($filelocker->lock($iptable_bts_file)){
			$table = &read_textfile($iptable_bts_file);
			$filelocker->unlock($iptable_bts_file);
		}else{
			print btserr(400);
			return;
		}
	}elsif($type eq 'ipuser'){
		if($filelocker->lock($iptable_user_file)){
			$table = &read_textfile($iptable_user_file);
			$filelocker->unlock($iptable_user_file);
		}else{
			print btserr(400);
			return;
		}
	}else{
		print btserr(303);
		return;
	}

	# url encode
	$table =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
	$table =~ tr/ /+/;

	my $param = "ver=2&method=gttb&sid=$sid&table=$table";
	$param .= "&url=" . $config{'HomeUrl'} ."&bm=$bts_module_name&tm=$tracker_module_name";
	my ($res_code, $res_message) = &httprequest("$remote_url$tm", $param, $config{'ProxyHost'}, $config{'ProxyPort'});
	if($res_code ne 200){
		print $res_message;
		return;
	}

	print btserr(200);
}

sub get_table_back {
	my $table = $input{'table'};
	my $sid = $input{'sid'};

	# url decode
	$table =~ tr/+/ /;
	$table =~ s/%([0-9A-Fa-f][0-9A-Fa-f])/pack('H2', $1)/eg;

	my $session=BTS::Session->new($filelocker, $session_temp_file, $sid);
	$session->write('checked', 1);
	$session->write('table', $table);

	print btserr(200);
}

