/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$BeanUtils == null ? (class$org$apache$commons$beanutils$BeanUtils = BeanUtils.class$("org.apache.commons.beanutils.BeanUtils")) : class$org$apache$commons$beanutils$BeanUtils));
    private static int debug = 0;
    static /* synthetic */ Class class$org$apache$commons$beanutils$BeanUtils;

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cloning bean: " + bean.getClass().getName()));
        }
        Class<?> clazz = bean.getClass();
        Object newBean = clazz.newInstance();
        PropertyUtils.copyProperties(newBean, bean);
        return newBean;
    }

    public static Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Describing bean: " + bean.getClass().getName()));
        }
        if (bean == null) {
            return new HashMap();
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(bean);
        HashMap<String, String> description = new HashMap<String, String>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            String name = descriptors[i].getName();
            if (descriptors[i].getReadMethod() != null) {
                description.put(name, BeanUtils.getProperty(bean, name));
            }
            ++i;
        }
        return description;
    }

    public static String[] getArrayProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getProperty(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<String> values = new ArrayList<String>();
            Iterator items = ((Collection)value).iterator();
            while (items.hasNext()) {
                Object item = items.next();
                if (item == null) {
                    values.add(null);
                    continue;
                }
                values.add(item.toString());
            }
            return values.toArray(new String[values.size()]);
        }
        if (value.getClass().isArray()) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                int n = Array.getLength(value);
                int i = 0;
                while (i < n) {
                    Object item = Array.get(value, i);
                    if (item == null) {
                        values.add(null);
                    } else {
                        values.add(item.toString());
                    }
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            return values.toArray(new String[values.size()]);
        }
        String[] results = new String[]{value.toString()};
        return results;
    }

    public static String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getIndexedProperty(bean, name, index);
        return ConvertUtils.convert(value);
    }

    public static String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getMappedProperty(bean, name, key);
        return ConvertUtils.convert(value);
    }

    public static String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getNestedProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return BeanUtils.getNestedProperty(bean, name);
    }

    public static String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object value = PropertyUtils.getSimpleProperty(bean, name);
        return ConvertUtils.convert(value);
    }

    public static void populate(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("BeanUtils.populate(" + bean + ", " + properties + ")"));
        }
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (name == null) continue;
            Object value = properties.get(name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("  name='" + name + "', value.class='" + (value == null ? "NONE" : value.getClass().getName()) + "', value='" + (value == null ? "NONE" : value) + "'"));
            }
            PropertyDescriptor descriptor = null;
            DynaProperty dynaProperty = null;
            try {
                if (bean instanceof DynaBean) {
                    int j;
                    String dynaName = name;
                    int i = dynaName.indexOf(91);
                    if (i >= 0) {
                        dynaName = dynaName.substring(0, i);
                    }
                    if ((j = dynaName.indexOf(40)) >= 0) {
                        dynaName = dynaName.substring(0, j);
                    }
                    DynaClass dynaClass = ((DynaBean)bean).getDynaClass();
                    dynaProperty = dynaClass.getDynaProperty(dynaName);
                } else {
                    descriptor = PropertyUtils.getPropertyDescriptor(bean, name);
                }
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"    getPropertyDescriptor", t);
                }
                descriptor = null;
                dynaProperty = null;
            }
            if (descriptor == null && dynaProperty == null) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)"    No such property, skipping");
                continue;
            }
            if (log.isTraceEnabled()) {
                if (descriptor != null) {
                    log.trace((Object)("    Property descriptor is '" + descriptor + "'"));
                } else {
                    log.trace((Object)("    DynaProperty descriptor is '" + descriptor + "'"));
                }
            }
            if (descriptor != null) {
                Method setter = null;
                if (descriptor instanceof IndexedPropertyDescriptor && name.indexOf(91) > 0) {
                    setter = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
                } else if (descriptor instanceof MappedPropertyDescriptor) {
                    setter = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
                }
                if (setter == null) {
                    setter = descriptor.getWriteMethod();
                }
                if (setter == null) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)"    No setter method, skipping");
                    continue;
                }
                Class<?>[] parameterTypes = setter.getParameterTypes();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("    Setter method is '" + setter.getName() + "(" + parameterTypes[0].getName() + (parameterTypes.length > 1 ? ", " + parameterTypes[1].getName() : "") + ")'"));
                }
                Class<?> parameterType = parameterTypes[0];
                if (parameterTypes.length > 1) {
                    parameterType = parameterTypes[1];
                }
                Object[] parameters = new Object[1];
                if (parameterType.isArray()) {
                    if (value instanceof String) {
                        String[] values = new String[]{(String)value};
                        parameters[0] = ConvertUtils.convert(values, parameterType);
                    } else {
                        parameters[0] = value instanceof String[] ? ConvertUtils.convert((String[])value, parameterType) : value;
                    }
                } else {
                    parameters[0] = value instanceof String ? ConvertUtils.convert((String)value, parameterType) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], parameterType) : value);
                }
                try {
                    PropertyUtils.setProperty(bean, name, parameters[0]);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"  CANNOT HAPPEN (setProperty()): ", (Throwable)e);
                }
                continue;
            }
            Object newValue = null;
            Class type = dynaProperty.getType();
            String dynaName = name;
            int index = -1;
            String key = null;
            int delim1 = name.indexOf(91);
            int delim2 = name.indexOf(93);
            if (delim1 >= 0) {
                dynaName = name.substring(0, delim1);
                try {
                    index = Integer.parseInt(name.substring(delim1 + 1, delim2));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            delim1 = name.indexOf(40);
            delim2 = name.indexOf(41);
            if (delim1 >= 0) {
                dynaName = name.substring(0, delim1);
                try {
                    key = name.substring(delim1 + 1, delim2);
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            if (type.isArray() && index < 0) {
                if (value instanceof String) {
                    String[] values = new String[]{(String)value};
                    newValue = ConvertUtils.convert(values, type);
                } else {
                    newValue = value instanceof String[] ? ConvertUtils.convert((String[])value, type) : (Object)value;
                }
            } else {
                newValue = type.isArray() ? (value instanceof String ? ConvertUtils.convert((String)value, type.getComponentType()) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type.getComponentType()) : (Object)value)) : (value instanceof String ? ConvertUtils.convert((String)value, type) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type) : value));
            }
            try {
                if (index >= 0) {
                    PropertyUtils.setIndexedProperty(bean, dynaName, index, newValue);
                    continue;
                }
                if (key != null) {
                    PropertyUtils.setMappedProperty(bean, dynaName, key, newValue);
                    continue;
                }
                PropertyUtils.setProperty(bean, name, newValue);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"    CANNOT HAPPEN (setProperty())", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

