/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogSource;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResourcesInitializer;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ApplicationConfig;

public class ValidatorPlugIn
implements PlugIn {
    private Log log = LogSource.getInstance((String)this.getClass().getName());
    private ApplicationConfig config = null;
    private ActionServlet servlet = null;
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.VALIDATOR_RESOURCES";
    protected ValidatorResources resources = null;
    private String pathname = null;
    private List lValidatorRules = new ArrayList();

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.lValidatorRules.add(pathname);
    }

    public void init(ApplicationConfig config) throws ServletException {
        this.config = config;
        this.servlet = config.getServlet();
        try {
            this.initResources();
            this.servlet.getServletContext().setAttribute(VALIDATOR_KEY, (Object)this.resources);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new UnavailableException("Cannot load validator resources from '" + this.lValidatorRules + "'");
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Destroying ValidatorPlugin");
        }
        this.servlet = null;
        this.config = null;
        this.destroyResources();
    }

    protected void initResources() throws IOException, ServletException {
        this.resources = new ValidatorResources();
        Iterator i = this.lValidatorRules.iterator();
        while (i.hasNext()) {
            String validatorRules = (String)i.next();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Loading validation rules file from '" + validatorRules + "'"));
            }
            InputStream input = null;
            BufferedInputStream bis = null;
            input = this.servlet.getServletContext().getResourceAsStream(validatorRules);
            if (input != null) {
                bis = new BufferedInputStream(input);
                try {
                    ValidatorResourcesInitializer.initialize((ValidatorResources)this.resources, (InputStream)bis, (boolean)false);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            this.log.error((Object)("Skipping validation rules file from '" + validatorRules + "'.  No stream could be opened."));
        }
        this.resources.process();
    }

    protected void destroyResources() {
        this.resources = null;
    }
}

