/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public class DelegatingConnection
implements Connection {
    protected Connection _conn = null;
    protected boolean _closed = false;

    public DelegatingConnection(Connection connection) {
        this._conn = connection;
    }

    public Connection getDelegate() {
        return this._conn;
    }

    public Connection getInnermostDelegate() {
        Connection connection = this._conn;
        while (connection != null && connection instanceof DelegatingConnection) {
            if (this != (connection = ((DelegatingConnection)connection).getDelegate())) continue;
            return null;
        }
        return connection;
    }

    public void setDelegate(Connection connection) {
        this._conn = connection;
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._conn.clearWarnings();
    }

    public void close() throws SQLException {
        this.passivate();
        this._conn.close();
    }

    public void commit() throws SQLException {
        this.checkOpen();
        this._conn.commit();
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this._conn.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.createStatement(n, n2);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this._conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this._conn.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this._conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this._conn.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this._conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._conn.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this._conn.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this._conn.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkOpen();
        return this._conn.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        return this._conn.prepareStatement(string, n, n2);
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        this._conn.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        this._conn.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
        this._conn.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        this._conn.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        this._conn.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this._conn.setTypeMap(map);
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void activate() {
        this._closed = false;
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).activate();
        }
    }

    protected void passivate() {
        this._closed = true;
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).passivate();
        }
    }
}

