/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.commons.dbcp.DelegatingPreparedStatement;

public class DelegatingStatement
implements Statement {
    protected Statement _stmt = null;
    protected boolean _closed = false;

    public DelegatingStatement(Statement statement) {
        this._stmt = statement;
    }

    public Statement getDelegate() {
        return this._stmt;
    }

    public Statement getInnermostDelegate() {
        Statement statement = this._stmt;
        while (statement != null && statement instanceof DelegatingStatement) {
            if (this != (statement = ((DelegatingStatement)statement).getDelegate())) continue;
            return null;
        }
        return statement;
    }

    public void setDelegate(Statement statement) {
        this._stmt = statement;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        return this._stmt.executeQuery(string);
    }

    public int executeUpdate(String string) throws SQLException {
        this.checkOpen();
        return this._stmt.executeUpdate(string);
    }

    public void close() throws SQLException {
        this.passivate();
        this._stmt.close();
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this._stmt.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setMaxRows(n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkOpen();
        this._stmt.setEscapeProcessing(bl);
    }

    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this._stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.checkOpen();
        this._stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this._stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this._stmt.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.checkOpen();
        this._stmt.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        this.checkOpen();
        return this._stmt.execute(string);
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this._stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this._stmt.getMoreResults();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkOpen();
        this._stmt.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this._stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this._stmt.getResultSetType();
    }

    public void addBatch(String string) throws SQLException {
        this.checkOpen();
        this._stmt.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        this._stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        return this._stmt.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this._stmt.getConnection();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void activate() {
        this._closed = false;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).activate();
        }
    }

    protected void passivate() {
        this._closed = true;
        if (this._stmt instanceof DelegatingPreparedStatement) {
            ((DelegatingPreparedStatement)this._stmt).passivate();
        }
    }
}

