/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.pool.ObjectPool;

public class PoolingDataSource
implements DataSource {
    protected PrintWriter _logWriter = null;
    protected ObjectPool _pool = null;

    public PoolingDataSource() {
        this(null);
    }

    public PoolingDataSource(ObjectPool objectPool) {
        this._pool = objectPool;
    }

    public void setPool(ObjectPool objectPool) throws IllegalStateException, NullPointerException {
        if (null != this._pool) {
            throw new IllegalStateException("Pool already set");
        }
        if (null == objectPool) {
            throw new NullPointerException("Pool must not be null.");
        }
        this._pool = objectPool;
    }

    public synchronized Connection getConnection() throws SQLException {
        try {
            return (Connection)this._pool.borrowObject();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public int getLoginTimeout() {
        throw new UnsupportedOperationException();
    }

    public void setLoginTimeout(int n) {
        throw new UnsupportedOperationException();
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }
}

