/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableLinkedList;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class GenericObjectPool
implements ObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    protected int _maxIdle = 8;
    protected int _maxActive = 8;
    protected long _maxWait = -1L;
    protected byte _whenExhaustedAction = 1;
    protected boolean _testOnBorrow = false;
    protected boolean _testOnReturn = false;
    protected boolean _testWhileIdle = false;
    protected long _timeBetweenEvictionRunsMillis = -1L;
    protected int _numTestsPerEvictionRun = 3;
    protected long _minEvictableIdleTimeMillis = 1800000L;
    protected CursorableLinkedList _pool = null;
    protected PoolableObjectFactory _factory = null;
    protected int _numActive = 0;
    protected Evictor _evictor = null;

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this(poolableObjectFactory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, Config config) {
        this(poolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n) {
        this(poolableObjectFactory, n, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l) {
        this(poolableObjectFactory, n, by, l, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n, by, l, 8, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2) {
        this(poolableObjectFactory, n, by, l, n2, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n, by, l, n2, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2, long l2, int n3, long l3, boolean bl3) {
        this._factory = poolableObjectFactory;
        this._maxActive = n;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this._maxWait = l;
        this._maxIdle = n2;
        this._testOnBorrow = bl;
        this._testOnReturn = bl2;
        this._timeBetweenEvictionRunsMillis = l2;
        this._numTestsPerEvictionRun = n3;
        this._minEvictableIdleTimeMillis = l3;
        this._testWhileIdle = bl3;
        this._pool = new CursorableLinkedList();
        if (this._timeBetweenEvictionRunsMillis > 0L) {
            this._evictor = new Evictor();
            Thread thread = new Thread(this._evictor);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public int getMaxActive() {
        return this._maxActive;
    }

    public void setMaxActive(int n) {
        this._maxActive = n;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.notifyAll();
        }
    }

    public byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    public synchronized void setWhenExhaustedAction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                this.notifyAll();
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    public synchronized void setMaxWait(long l) {
        this._maxWait = l;
    }

    public int getMaxIdle() {
        return this._maxIdle;
    }

    public void setMaxIdle(int n) {
        this._maxIdle = n;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            this.notifyAll();
        }
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this._testOnBorrow = bl;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this._testOnReturn = bl;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        if (this._timeBetweenEvictionRunsMillis > 0L && l <= 0L) {
            this._evictor.cancel();
            this._evictor = null;
            this._timeBetweenEvictionRunsMillis = l;
        } else if (this._timeBetweenEvictionRunsMillis <= 0L && l > 0L) {
            this._timeBetweenEvictionRunsMillis = l;
            this._evictor = new Evictor();
            Thread thread = new Thread(this._evictor);
            thread.setDaemon(true);
            thread.start();
        } else {
            this._timeBetweenEvictionRunsMillis = l;
        }
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int n) {
        this._numTestsPerEvictionRun = n;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this._minEvictableIdleTimeMillis = l;
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean bl) {
        this._testWhileIdle = bl;
    }

    public synchronized void setConfig(Config config) {
        this.setMaxIdle(config.maxIdle);
        this.setMaxActive(config.maxActive);
        this.setMaxWait(config.maxWait);
        this.setWhenExhaustedAction(config.whenExhaustedAction);
        this.setTestOnBorrow(config.testOnBorrow);
        this.setTestOnReturn(config.testOnReturn);
        this.setTestWhileIdle(config.testWhileIdle);
        this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
        this.notifyAll();
    }

    public synchronized Object borrowObject() throws Exception {
        ObjectTimestampPair objectTimestampPair;
        long l = System.currentTimeMillis();
        block11: while (true) {
            objectTimestampPair = null;
            try {
                objectTimestampPair = (ObjectTimestampPair)this._pool.removeFirst();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (null == objectTimestampPair) {
                Object object;
                if (this._maxActive > 0 && this._numActive < this._maxActive) {
                    object = this._factory.makeObject();
                    objectTimestampPair = new ObjectTimestampPair(object);
                } else {
                    switch (this._whenExhaustedAction) {
                        case 2: {
                            object = this._factory.makeObject();
                            objectTimestampPair = new ObjectTimestampPair(object);
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this._maxWait <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this._maxWait);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this._maxWait <= 0L || System.currentTimeMillis() - l < this._maxWait) continue block11;
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this._whenExhaustedAction + " not recognized.");
                        }
                    }
                }
            }
            this._factory.activateObject(objectTimestampPair.value);
            if (!this._testOnBorrow || this._factory.validateObject(objectTimestampPair.value)) break;
            try {
                this._factory.passivateObject(objectTimestampPair.value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._factory.destroyObject(objectTimestampPair.value);
        }
        ++this._numActive;
        return objectTimestampPair.value;
    }

    public synchronized void clear() {
        Iterator iterator = this._pool.iterator();
        while (iterator.hasNext()) {
            try {
                this._factory.destroyObject(((ObjectTimestampPair)iterator.next()).value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            iterator.remove();
        }
        this._pool.clear();
        this.notifyAll();
    }

    public int numActive() {
        return this._numActive;
    }

    public int numIdle() {
        return this._pool.size();
    }

    public synchronized void returnObject(Object object) throws Exception {
        --this._numActive;
        if (this._maxIdle > 0 && (this._pool.size() >= this._maxIdle || this._testOnReturn && !this._factory.validateObject(object))) {
            try {
                this._factory.passivateObject(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._factory.destroyObject(object);
        } else {
            try {
                this._factory.passivateObject(object);
                this._pool.addFirst((Object)new ObjectTimestampPair(object));
            }
            catch (Exception exception) {
                this._factory.destroyObject(object);
            }
        }
        this.notifyAll();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this._pool = null;
        this._factory = null;
        if (null != this._evictor) {
            this._evictor.cancel();
            this._evictor = null;
        }
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        if (0 < this.numActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }

    synchronized String debugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Active: ").append(this.numActive()).append("\n");
        stringBuffer.append("Idle: ").append(this.numIdle()).append("\n");
        stringBuffer.append("Idle Objects:\n");
        Iterator iterator = this._pool.iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            ObjectTimestampPair objectTimestampPair = (ObjectTimestampPair)iterator.next();
            stringBuffer.append("\t").append(objectTimestampPair.value).append("\t").append(l - objectTimestampPair.tstamp).append("\n");
        }
        return stringBuffer.toString();
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }

    class Evictor
    implements Runnable {
        protected boolean _cancelled = false;

        Evictor() {
        }

        void cancel() {
            this._cancelled = true;
        }

        public void run() {
            CursorableLinkedList.Cursor cursor = null;
            while (!this._cancelled) {
                long l = 0L;
                GenericObjectPool genericObjectPool = GenericObjectPool.this;
                synchronized (genericObjectPool) {
                    l = GenericObjectPool.this._timeBetweenEvictionRunsMillis;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(GenericObjectPool.this._timeBetweenEvictionRunsMillis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    GenericObjectPool genericObjectPool2 = GenericObjectPool.this;
                    synchronized (genericObjectPool2) {
                        if (!GenericObjectPool.this._pool.isEmpty()) {
                            if (null == cursor) {
                                cursor = GenericObjectPool.this._pool.cursor(GenericObjectPool.this._pool.size());
                            } else if (!cursor.hasPrevious()) {
                                cursor.close();
                                cursor = GenericObjectPool.this._pool.cursor(GenericObjectPool.this._pool.size());
                            }
                            int n = 0;
                            int n2 = this.getNumTests();
                            while (n < n2) {
                                if (!cursor.hasPrevious()) {
                                    cursor.close();
                                    cursor = GenericObjectPool.this._pool.cursor(GenericObjectPool.this._pool.size());
                                } else {
                                    ObjectTimestampPair objectTimestampPair = (ObjectTimestampPair)cursor.previous();
                                    if (System.currentTimeMillis() - objectTimestampPair.tstamp > GenericObjectPool.this._minEvictableIdleTimeMillis) {
                                        try {
                                            cursor.remove();
                                            GenericObjectPool.this._factory.destroyObject(objectTimestampPair.value);
                                        }
                                        catch (Exception exception) {}
                                    } else if (GenericObjectPool.this._testWhileIdle) {
                                        boolean bl = false;
                                        try {
                                            GenericObjectPool.this._factory.activateObject(objectTimestampPair.value);
                                            bl = true;
                                        }
                                        catch (Exception exception) {
                                            cursor.remove();
                                            try {
                                                GenericObjectPool.this._factory.passivateObject(objectTimestampPair.value);
                                            }
                                            catch (Exception exception2) {
                                                // empty catch block
                                            }
                                            GenericObjectPool.this._factory.destroyObject(objectTimestampPair.value);
                                        }
                                        if (bl) {
                                            if (!GenericObjectPool.this._factory.validateObject(objectTimestampPair.value)) {
                                                cursor.remove();
                                                try {
                                                    GenericObjectPool.this._factory.passivateObject(objectTimestampPair.value);
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                GenericObjectPool.this._factory.destroyObject(objectTimestampPair.value);
                                            } else {
                                                try {
                                                    GenericObjectPool.this._factory.passivateObject(objectTimestampPair.value);
                                                }
                                                catch (Exception exception) {
                                                    cursor.remove();
                                                    GenericObjectPool.this._factory.destroyObject(objectTimestampPair.value);
                                                }
                                            }
                                        }
                                    }
                                }
                                ++n;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null != cursor) {
                cursor.close();
            }
        }

        private int getNumTests() {
            if (GenericObjectPool.this._numTestsPerEvictionRun >= 0) {
                return GenericObjectPool.this._numTestsPerEvictionRun;
            }
            return (int)Math.ceil((double)GenericObjectPool.this._pool.size() / Math.abs((double)GenericObjectPool.this._numTestsPerEvictionRun));
        }
    }

    class ObjectTimestampPair {
        Object value;
        long tstamp;

        ObjectTimestampPair(Object object) {
            this.value = object;
            this.tstamp = System.currentTimeMillis();
        }

        ObjectTimestampPair(Object object, long l) {
            this.value = object;
            this.tstamp = l;
        }
    }
}

