/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlDriver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class gweMysqlDataSource
implements DataSource,
Referenceable,
Serializable {
    private static gweMysqlDriver driver = null;
    private static final String factoryName = "gwe.sql.gweMysqlDataSourceFactory";
    private int seconds = 0;
    private transient PrintWriter logger = null;
    private String networkProtocol = "jdbc:mysql:";
    private String serverName = "";
    private Integer portNumber = new Integer(3306);
    private String databaseName = "";
    private String dataSourceName = null;
    private String description = "";
    private String user = null;
    private String password = null;
    private String characterEncoding = "Shift_JIS";
    private Boolean add5CAfter5C = new Boolean(false);
    private Boolean useNewIO = new Boolean(false);
    private Boolean debugSQL = new Boolean(false);

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        if (this.characterEncoding != null) {
            properties.setProperty("characterEncoding", this.characterEncoding);
        }
        properties.setProperty("add5CAfter5C", this.add5CAfter5C.toString());
        properties.setProperty("useNewIO", this.useNewIO.toString());
        properties.setProperty("debugSQL", this.debugSQL.toString());
        String string3 = this.networkProtocol + "//" + this.serverName + ":" + this.portNumber + "/" + this.databaseName;
        return driver.connect(string3, properties);
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), factoryName, null);
        reference.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        reference.add(new StringRefAddr("serverName", this.getServerName()));
        reference.add(new StringRefAddr("portNumber", this.getPortNumber().toString()));
        reference.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("characterEncoding", this.getCharacterEncoding()));
        reference.add(new StringRefAddr("add5CAfter5C", this.isAdd5CAfter5C().toString()));
        reference.add(new StringRefAddr("useNewIO", this.isUseNewIO().toString()));
        reference.add(new StringRefAddr("debugSQL", this.isDebugSQL().toString()));
        return reference;
    }

    public synchronized void println(String string) {
        if (this.logger != null) {
            this.logger.println(string);
            this.logger.flush();
        }
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logger = printWriter;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.seconds = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.seconds;
    }

    public void setNetworkProtocol(String string) {
        this.networkProtocol = string;
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setPortNumber(Integer n) {
        this.portNumber = n;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setAdd5CAfter5C(Boolean bl) {
        this.add5CAfter5C = bl;
    }

    public Boolean isAdd5CAfter5C() {
        return this.add5CAfter5C;
    }

    public void setUseNewIO(Boolean bl) {
        this.useNewIO = bl;
    }

    public Boolean isUseNewIO() {
        return this.useNewIO;
    }

    public void setDebugSQL(Boolean bl) {
        this.debugSQL = bl;
    }

    public Boolean isDebugSQL() {
        return this.debugSQL;
    }

    static {
        try {
            driver = (gweMysqlDriver)Class.forName("gwe.sql.gweMysqlDriver").newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not Load Driver gwe.sql.gweMysqlDriver class");
        }
    }
}

