/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.ProjectEdition;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.taskdefs.optional.ide.VAJWorkspaceScanner;

public class VAJLoadProjects
extends Task {
    Vector projectDescriptions = new Vector();
    Vector expandedProjectDescriptions = new Vector();

    public VAJProjectDescription createVAJProject() {
        VAJProjectDescription d = new VAJProjectDescription();
        this.projectDescriptions.addElement(d);
        return d;
    }

    public void execute() {
        this.expandDescriptions();
        this.log("Loading " + this.expandedProjectDescriptions.size() + " project(s) into workspace");
        Enumeration e = this.expandedProjectDescriptions.elements();
        while (e.hasMoreElements()) {
            VAJProjectDescription d = (VAJProjectDescription)e.nextElement();
            ProjectEdition pe = VAJLoadProjects.findProjectEdition(d.getName(), d.getVersion());
            try {
                this.log("Loading " + d.getName() + ", Version " + d.getVersion() + ", into Workspace", 3);
                pe.loadIntoWorkspace();
            }
            catch (IvjException ex) {
                throw VAJUtil.createBuildException("Project " + d.getName() + " could not be loaded.", ex);
            }
        }
    }

    public void expandDescriptions() {
        VAJProjectDescription d;
        Enumeration e;
        String[] projectNames;
        try {
            projectNames = VAJUtil.getWorkspace().getRepository().getProjectNames();
        }
        catch (IvjException e2) {
            throw VAJUtil.createBuildException("VA Exception occured: ", e2);
        }
        int i = 0;
        while (i < projectNames.length) {
            e = this.projectDescriptions.elements();
            while (e.hasMoreElements()) {
                d = (VAJProjectDescription)e.nextElement();
                String pattern = d.getName();
                if (!VAJWorkspaceScanner.match(pattern, projectNames[i])) continue;
                d.setProjectFound();
                this.expandedProjectDescriptions.addElement(new VAJProjectDescription(projectNames[i], d.getVersion()));
                break;
            }
            ++i;
        }
        e = this.projectDescriptions.elements();
        while (e.hasMoreElements()) {
            d = (VAJProjectDescription)e.nextElement();
            if (d.projectFound()) continue;
            this.log("No Projects match the name " + d.getName(), 1);
        }
    }

    public static Vector findMatchingProjects(String pattern) {
        String[] projectNames;
        try {
            projectNames = VAJUtil.getWorkspace().getRepository().getProjectNames();
        }
        catch (IvjException e) {
            throw VAJUtil.createBuildException("VA Exception occured: ", e);
        }
        Vector<String> matchingProjects = new Vector<String>();
        int i = 0;
        while (i < projectNames.length) {
            if (VAJWorkspaceScanner.match(pattern, projectNames[i])) {
                matchingProjects.addElement(projectNames[i]);
            }
            ++i;
        }
        return matchingProjects;
    }

    public static ProjectEdition findProjectEdition(String name, String versionName) {
        try {
            ProjectEdition[] editions = null;
            editions = VAJUtil.getWorkspace().getRepository().getProjectEditions(name);
            if (editions == null) {
                throw new BuildException("Project " + name + " doesn't exist");
            }
            ProjectEdition pe = null;
            int i = 0;
            while (i < editions.length && pe == null) {
                if (versionName.equals(editions[i].getVersionName())) {
                    pe = editions[i];
                }
                ++i;
            }
            if (pe == null) {
                throw new BuildException("Version " + versionName + " of Project " + name + " doesn't exist");
            }
            return pe;
        }
        catch (IvjException e) {
            throw VAJUtil.createBuildException("VA Exception occured: ", e);
        }
    }

    public class VAJProjectDescription {
        private String name;
        private String version;
        private boolean projectFound;

        public VAJProjectDescription() {
        }

        public VAJProjectDescription(String n, String v) {
            this.name = n;
            this.version = v;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean projectFound() {
            return this.projectFound;
        }

        public void setName(String newName) {
            if (newName == null || newName.equals("")) {
                throw new BuildException("name attribute must be set");
            }
            this.name = newName;
        }

        public void setVersion(String newVersion) {
            if (newVersion == null || newVersion.equals("")) {
                throw new BuildException("version attribute must be set");
            }
            this.version = newVersion;
        }

        public void setProjectFound() {
            this.projectFound = true;
        }
    }
}

