//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;
/**
 *<PRE>
 * 
 * BugDetail1ActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public abstract class BaseAction extends Action {
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
    public ActionForward execute(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		ActionForward forward = null;
		try {
			//debug
			log.debug("doAction start--------------------------------");
			
			forward = doAction(mapping, form, request, response);
			
			//debug
			log.debug("doAction end----------------------------------");
			
		} catch (Exception e) {
			
			e.printStackTrace();
			throw e;
		}
		return forward;
	}
	/**
	 * 
	 */
	public abstract ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception;
//===========================================================================
// common methods
//===========================================================================
	/**
	 * session̎擾
	 */
	protected HttpSession getSession(HttpServletRequest request) {
		
		return getSession(request, false);	//VK擾Ȃ
	}
	/**
	 *  ZbV̎擾
	 *
	 *	ZbV擾BVK擾tOtruȅꍇVKɃZbV蒼
	 *	falsȅꍇ̃ZbVo
	 *	̃ZbVoȂꍇASessionTimeoutException𓊂
	 *
	 *	@param	request		HTTPvIuWFNg
	 *	@param	newFlag		VK擾tO
	 */
	public HttpSession getSession(HttpServletRequest request, boolean newFlag) {
		//ZbV̎擾
		HttpSession session = request.getSession(newFlag);
		//ZbV擾ł
		if (session == null) {
			//擾łȂꍇA[UOCɒڃANZXĂ
			//^CAEgĂB
			//ZbVȂOthrowB
			throw new SessionTimeoutException();
		}
		return session;
	}
	/**
	 *  Agr[g̎擾(ftHgFK{)
	 *
	 *	@param	session		ZbV
	 *	@param	keyword		Agr[g
	 */
	public Object getAttribute(HttpSession session, String keyword) {
		return getAttribute(session, keyword, true);
	}
	/**
	 *  Agr[g̎擾
	 *
	 *	ZbVAgr[g擾B
	 *	Agr[goȂꍇAIlligalSessionException𓊂
	 *
	 *	@param	session		ZbV
	 *	@param	keyword		Agr[g
	 *
	 */
	public Object getAttribute(HttpSession session, String keyword, boolean required) {
		Object obj = null;
	 	
		obj = session.getAttribute(keyword);	//Agr[g̎擾
		//K{H
		if (required) {
			if (obj == null) {
				//擾łȂꍇAoO
				throw new SessionTimeoutException("no attribute found name = " + keyword);
			}
		}
		return obj;
	}
}
