//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * BugDependsNX
 * 
 *</PRE>
 * @version	0.0, 2002/09/24
 * @author	A 
 */
//===========================================================================
public class BugDependsTree implements Comparator
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	oOԍ
	 */
	private int m_bno = 0;
	/**
	 *	qoOTree
	 */
	private TreeSet m_childTree = null;
	/**
	 *	eoOTree
	 */
	private TreeSet m_parentTree = null;
	/**
	 *	HTMLeLXg
	 */
	private StringBuffer m_sb = null;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	RXgN^
	 *
	 * @parem	int	oOԍ
	 */
	public BugDependsTree(int bno)
	{
		m_bno = bno;
	}

	/**
	 *	oOԍ̎擾
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 *	qTree̐
	 */
	public TreeSet getChilds()
	{
		m_childTree = new TreeSet(this);
		Collection collection = BugDepends.getBugDepends(m_bno);
		if (collection != null) {
			Iterator ite = collection.iterator();
			while (ite.hasNext()) {
				m_childTree.add(new BugDependsTree(((BugDepends)ite.next()).getDependBno()));
			}
		}
		return m_childTree;
	}
	/**
	 *	SĂ̎qTree̐
	 */
	public TreeSet getAllChilds()
	{
		TreeSet set = new TreeSet(this);
		getAllChilds(this, set);
		return set;
	}
	/**
	 *	SĂ̎qTree̐(p)
	 */
	private TreeSet getAllChilds(BugDependsTree tree, TreeSet set)
	{
		BugDependsTree childTree = null;
		Iterator ite = tree.getChilds().iterator();
		while (ite.hasNext()) {
			childTree = (BugDependsTree)ite.next();
			if (set.add(childTree)) {
				getAllChilds(childTree, set);
			}
		}
		return set;
	}
	/**
	 *	eTree̐
	 */
	public TreeSet getParents()
	{
		m_parentTree = new TreeSet(this);
		Collection collection = BugDepends.getChildBugDepends(m_bno);
		if (collection != null) {
			Iterator ite = collection.iterator();
			while (ite.hasNext()) {
				m_parentTree.add(new BugDependsTree(((BugDepends)ite.next()).getBno()));
			}
		}
		return m_parentTree;
	}
	/**
	 *	SĂ̐eTree̐
	 */
	public TreeSet getAllParents()
	{
		TreeSet set = new TreeSet(this);
		getAllParents(this, set);
		return set;
	}
	/**
	 *	SĂ̐eTree̐(p)
	 */
	private TreeSet getAllParents(BugDependsTree tree, TreeSet set)
	{
		BugDependsTree parentTree = null;
		Iterator ite = tree.getParents().iterator();
		while (ite.hasNext()) {
			parentTree = (BugDependsTree)ite.next();
			if (set.add(parentTree)) {
				getAllParents(parentTree, set);
			}
		}
		return set;
	}
	/**
	 *	HTML̐
	 */
	public String getHtml()
	{
		if (m_sb == null) {
			m_sb = new StringBuffer();
			//oOCX^X̐
			Bug bug = new Bug(m_bno);
			if (bug != null) {
				m_sb.append("<li>");
				m_sb.append("<a href=\"../showAll.do?bno=" + m_bno + "\">");
				m_sb.append(bug.getBnoString());					//oOԍ
				m_sb.append(" ");
				m_sb.append(bug.getStatusString());				//Xe[^X
				m_sb.append(" ");
				m_sb.append("[" + bug.getDispatchName() + "]");	//fBXpb`於
				m_sb.append(" - ");
				m_sb.append(bug.getTitle());						//^Cg
				m_sb.append("</a>\n");
			} else {
				//蓾Ȃ͂
				m_sb.append("<li><a href=\"#\">Qԍ = " + m_bno + "݂͑Ȃ</a>\n");
			}
		}
		return m_sb.toString();
	}
	/**
	 *	dispTree̐
	 */
	public String getDispChildTree()
	{
		StringBuffer sb = new StringBuffer();
		sb = dispChildTree(this, new StringBuffer());
		
		return sb.toString();
	}
	/**
	 *	dispChildTree̐
	 */
	private StringBuffer dispChildTree(BugDependsTree tree, StringBuffer sb)
	{
		BugDependsTree childTree = null;
		Iterator ite = tree.getChilds().iterator();
		while (ite.hasNext()) {
			childTree = (BugDependsTree)ite.next();
			sb.append("<ul>");
			sb.append(childTree.getHtml());
			dispChildTree(childTree, sb);
		}
		sb.append("</ul>");
		
		return sb;
	}
	/**
	 *	dispTree̐
	 */
	public String getDispParentTree()
	{
		StringBuffer sb = new StringBuffer();
		sb = dispParentTree(this, new StringBuffer());
		
		return sb.toString();
	}
	/**
	 *	dispParentTree̐
	 */
	private StringBuffer dispParentTree(BugDependsTree tree, StringBuffer sb)
	{
		BugDependsTree parentTree = null;
		Iterator ite = tree.getParents().iterator();
		while (ite.hasNext()) {
			parentTree = (BugDependsTree)ite.next();
			sb.append("<ul>");
			sb.append(parentTree.getHtml());
			dispParentTree(parentTree, sb);
		}
		sb.append("</ul>");
		
		return sb;
	}
	/**
	 *	comparaTo
	 */
	public int compare(Object o1, Object o2)
	{
		int ret = 0;
		
		if (((BugDependsTree)o1).getBno() < ((BugDependsTree)o2).getBno()) {
			ret = -1;
		} else if (((BugDependsTree)o1).getBno() == ((BugDependsTree)o2).getBno()) {
			ret = 0;
		} else if (((BugDependsTree)o1).getBno() > ((BugDependsTree)o2).getBno()) {
			ret = 1;
		}
		return ret;
	}

//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [BugDependsTree] --- \n");
		sb.append("bno      : " + m_bno + "\n");
		sb.append("html     : " + getHtml() + "\n");
		sb.append("--- [BugDependsTree] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << BugDependsTree Test Start >> -----------");
		unitTest1();	//dispTreeeXg
		
		System.out.println("------- << BugDependsTree Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		int bno = 6;	//oOԍ
		//l̃Zbg
		BugDependsTree tree = new BugDependsTree(bno);
		
		System.out.println("[NX]");
		System.out.println(tree.toString());
		
		System.out.println("[Tree\HTML]");
		System.out.println(tree.getDispChildTree());
		
		System.out.println("[SĂ̎qTree]");
		Iterator ite = tree.getAllChilds().iterator();
		while (ite.hasNext()) {
			System.out.println("bno = " + ((BugDependsTree)ite.next()).getBno());
		}
		
		System.out.println("[SĂ̐eTree]");
		Iterator parentIte = tree.getAllParents().iterator();
		while (parentIte.hasNext()) {
			System.out.println("bno = " + ((BugDependsTree)parentIte.next()).getBno());
		}
		
	}

}