//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * ChoiceBugNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class ChoiceBug extends Bug
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	@\
	 */
	private String m_functionString = null;
	/**
	 *	TuVXe
	 */
	private String m_subsystemString = null;
	/**
	 *	Ώ
	 */
	private String m_resolutionString = null;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public ChoiceBug()
	{
		
	}
//======================================
// Property
//======================================
	/**
	 * @\̂̎擾
	 * 
	 * @return @\
	 */
	public String getFunctionString()
	{
		return m_functionString;
	}
	/**
	 * @\̂̃Zbg
	 * 
	 * @param functionString @\
	 */
	public void setFunctionString(String functionString)
	{
		m_functionString = functionString;
	}
	/**
	 * TuVXê̎擾
	 * 
	 * @return TuVXe
	 */
	public String getSubsystemString()
	{
		return m_subsystemString;
	}
	/**
	 * TuVXễZbg
	 * 
	 * @param SubsystemString TuVXe
	 */
	public void setSubsystemString(String subsystemString)
	{
		m_subsystemString = subsystemString;
	}
	/**
	 * Ώ̎擾
	 * 
	 * @return Ώ
	 */
	public String getResolutionString()
	{
		return m_resolutionString;
	}
	/**
	 * Ώ̃Zbg
	 * 
	 * @param resolutionString Ώ
	 */
	public void setResolutionString(String resolutionString)
	{
		m_resolutionString = resolutionString;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [ChoiceBug] --- \n");
		sb.append("bno       : " + getBnoString() + "\n");
		sb.append("fucntion  : " + m_functionString + "\n");
		sb.append("title     : " + getTitle() + "\n");
		sb.append("status    : " + getStatusString() + "\n");
		sb.append("Compo     : " + getComponentString() + "\n");
		sb.append("statusBoed: " + getStatusWhitebord() + "\n");
		sb.append("issuDate  : " + getIssuDateString() + "\n");
		sb.append("updateDate: " + getBugUpdateDateString() + "\n");
		sb.append("confirmDate: " + getComfirmDateString() + "\n");
		sb.append("--- [ChoiceBug] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << ChoiceBug Test Start >> -----------");
		unitTest1();	//eXg
		System.out.println("------- << ChoiceBug Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		String where = "bno = ?";
		ArrayList params = new ArrayList();
		params.add("1");
		
		Collection list = BugFinder.findChoiceBug(where, params);
		//\
		display(list);
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			ChoiceBug ChoiceBug = (ChoiceBug)ite.next();
			
			System.out.println(ChoiceBug.toString());
		}
	}
}