/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.util.DualIterator;
import com.limegroup.gnutella.util.ForgetfulHashMap;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ResponseVerifier {
    private ForgetfulHashMap mapper = new ForgetfulHashMap(1000);
    private static final String DELIMITERS = "+ ";
    private static final long Mandragore_SIZE = 8192L;

    public synchronized void record(QueryRequest queryRequest) {
        this.record(queryRequest, null);
    }

    public synchronized void record(QueryRequest queryRequest, MediaType mediaType) {
        byte[] byArray = queryRequest.getGUID();
        this.mapper.put(new GUID(byArray), new RequestData(queryRequest.getQuery(), queryRequest.getRichQuery(), mediaType, queryRequest.isWhatIsNewRequest()));
    }

    public synchronized boolean matchesQuery(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.queryWords == null) {
            return false;
        }
        if (requestData.whatIsNew) {
            return true;
        }
        int n = FilterSettings.MIN_MATCHING_WORDS.getValue();
        if (ResponseVerifier.score(requestData.queryWords, response.getName()) > n) {
            return true;
        }
        LimeXMLDocument limeXMLDocument = response.getDocument();
        if (limeXMLDocument != null) {
            DualIterator dualIterator = new DualIterator(limeXMLDocument.getKeyWords().iterator(), limeXMLDocument.getKeyWordsIndivisible().iterator());
            while (dualIterator.hasNext()) {
                String string = (String)dualIterator.next();
                if (ResponseVerifier.score(requestData.queryWords, string) <= n) continue;
                return true;
            }
        }
        return false;
    }

    public static int score(String string, LimeXMLDocument limeXMLDocument, RemoteFileDesc remoteFileDesc) {
        return ResponseVerifier.score(ResponseVerifier.getSearchTerms(string, limeXMLDocument), remoteFileDesc.getFileName());
    }

    private static int score(List list, String string) {
        int n = 0;
        int n2 = list.size();
        if (n2 == 0) {
            return 100;
        }
        int n3 = 0;
        while (n3 < n2) {
            String string2 = (String)list.get(n3);
            if (StringUtils.contains(string, string2, true)) {
                ++n;
            }
            ++n3;
        }
        return (int)(100.0f * ((float)n / (float)n2));
    }

    public boolean matchesType(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null || requestData.type == null) {
            return true;
        }
        String string = response.getName();
        return requestData.type.matches(string);
    }

    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        RequestData requestData = (RequestData)this.mapper.get(new GUID(byArray));
        if (requestData == null) {
            return false;
        }
        return response.getSize() == 8192L && response.getName().equals(String.valueOf(requestData.query) + ".exe");
    }

    public String toString() {
        return this.mapper.toString();
    }

    private static List getSearchTerms(String string, LimeXMLDocument limeXMLDocument) {
        String[] stringArray = null;
        HashSet<String> hashSet = new HashSet<String>();
        stringArray = StringUtils.split(string.toLowerCase(), DELIMITERS);
        int n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n]);
            ++n;
        }
        List list = null;
        if (limeXMLDocument != null) {
            list = limeXMLDocument.getKeyWords();
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                String string2 = (String)list.remove(0);
                hashSet.add(string2.toLowerCase());
                ++n3;
            }
        }
        return Collections.unmodifiableList(new ArrayList(hashSet));
    }

    private static class RequestData {
        final String query;
        final LimeXMLDocument richQuery;
        final List queryWords;
        final MediaType type;
        final boolean whatIsNew;

        RequestData(String string, MediaType mediaType) {
            this(string, null, mediaType, false);
        }

        RequestData(String string, LimeXMLDocument limeXMLDocument, MediaType mediaType, boolean bl) {
            this.query = string;
            this.richQuery = limeXMLDocument;
            this.queryWords = ResponseVerifier.getSearchTerms(string, limeXMLDocument);
            this.type = mediaType;
            this.whatIsNew = bl;
        }

        public boolean xmlQuery() {
            return this.richQuery != null;
        }
    }
}

