/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionChecker
implements Runnable {
    private volatile boolean _connected;
    private int _unsuccessfulAttempts;
    private static final Log LOG;
    private static String[] STANDARD_HOSTS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.connection.ConnectionChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        STANDARD_HOSTS = new String[]{"http://www.wanadoo.fr", "http://www.tiscali.com", "http://www.ntt.com", "http://www.tonline.com", "http://www.download.com", "http://www.ibm.com", "http://www.sun.com", "http://www.apple.com", "http://www.ebay.com", "http://www.sun.com", "http://www.monster.com", "http://www.uunet.com", "http://www.real.com", "http://www.level3.com", "http://www.microsoft.com", "http://www.sco.com", "http://www.google.com", "http://www.cnn.com", "http://www.amazon.com", "http://www.espn.com", "http://www.yahoo.com", "http://www.oracle.com", "http://www.dell.com", "http://www.ge.com", "http://www.sprint.com", "http://www.att.com", "http://www.mci.com", "http://www.cisco.com", "http://www.intel.com", "http://www.motorola.com", "http://www.hp.com", "http://www.gateway.com", "http://www.sony.com", "http://www.ford.com", "http://www.gm.com", "http://www.aol.com", "http://www.verizon.com", "http://www.passport.com", "http://www.go.com", "http://www.overture.com", "http://www.earthlink.net", "http://www.bellsouth.net", "http://www.excite.com", "http://www.paypal.com", "http://www.altavista.com", "http://www.weather.com", "http://www.mapquest.com", "http://www.geocities.com", "http://www.juno.com", "http://www.msnbc.com", "http://www.lycos.com", "http://www.comcast.com", "http://www.overture.com"};
    }

    private ConnectionChecker() {
    }

    public static ConnectionChecker checkForLiveConnection() {
        LOG.trace((Object)"checking for live connection");
        ConnectionChecker connectionChecker = new ConnectionChecker();
        ManagedThread managedThread = new ManagedThread(connectionChecker, "check for live connection");
        managedThread.setDaemon(true);
        managedThread.start();
        return connectionChecker;
    }

    public void run() {
        try {
            List list = Arrays.asList((Object[])STANDARD_HOSTS);
            Collections.shuffle((List)list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.connectToHost(string);
                if (this._connected) {
                    return;
                }
                if (this._unsuccessfulAttempts <= 2) continue;
                RouterService.getConnectionManager().noInternetConnection();
                return;
            }
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    public boolean hasConnected() {
        return this._connected;
    }

    private void connectToHost(String string) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connecting to: " + string));
        }
        HeadMethod headMethod = new HeadMethod(string);
        headMethod.addRequestHeader("Cache-Control", "no-cache");
        headMethod.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        headMethod.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        headMethod.setFollowRedirects(false);
        HttpClient httpClient = HttpClientManager.getNewClient(20000, 3000);
        try {
            try {
                httpClient.executeMethod((HttpMethod)headMethod);
                this._connected = true;
            }
            catch (IOException iOException) {
                LOG.warn((Object)"Exception while handling server", (Throwable)iOException);
                ++this._unsuccessfulAttempts;
            }
        }
        finally {
            headMethod.releaseConnection();
            headMethod.abort();
        }
    }
}

