/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.downloader.CantConnectException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.FileIncompleteException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.ReaderIsNullException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.CountingInputStream;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG;
    public static final int BUF_LENGTH = 1024;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    private static final BandwidthThrottle THROTTLE;
    static int MIN_PARTIAL_FILE_BYTES;
    private RemoteFileDesc _rfd;
    private boolean _isPush;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private volatile int _totalAmountRead;
    private volatile int _amountRead;
    private volatile int _amountToRead;
    private int _initialReadingPoint;
    private int _contentLength;
    private boolean _bodyConsumed = true;
    private ByteReader _byteReader;
    private Socket _socket;
    private OutputStream _output;
    private InputStream _input;
    private File _incompleteFile;
    private boolean _outIsCorrupted;
    private AlternateLocationCollection _altLocsReceived;
    private Set _goodLocs;
    private Set _badLocs;
    private Set _writtenGoodLocs;
    private Set _writtenBadLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private volatile boolean _isActive = false;
    private Interval _requestedInterval = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.HTTPDownloader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        THROTTLE = new BandwidthThrottle(Float.MAX_VALUE, false);
        MIN_PARTIAL_FILE_BYTES = 0x100000;
    }

    public HTTPDownloader(RemoteFileDesc remoteFileDesc, File file) {
        this(null, remoteFileDesc, file);
        this._isPush = false;
    }

    public HTTPDownloader(Socket socket, RemoteFileDesc remoteFileDesc, File file) {
        if (remoteFileDesc == null) {
            throw new NullPointerException("null rfd");
        }
        this._isPush = true;
        this._rfd = remoteFileDesc;
        this._socket = socket;
        this._incompleteFile = file;
        this._filename = remoteFileDesc.getFileName();
        this._index = remoteFileDesc.getIndex();
        this._guid = remoteFileDesc.getClientGUID();
        this._amountToRead = remoteFileDesc.getSize();
        this._port = remoteFileDesc.getPort();
        this._host = remoteFileDesc.getHost();
        this._chatEnabled = remoteFileDesc.chatEnabled();
        this._browseEnabled = remoteFileDesc.browseHostEnabled();
        URN uRN = remoteFileDesc.getSHA1Urn();
        this._altLocsReceived = uRN == null ? null : AlternateLocationCollection.create(uRN);
        this._goodLocs = new HashSet();
        this._badLocs = new HashSet();
        this._writtenGoodLocs = new HashSet();
        this._writtenBadLocs = new HashSet();
        this._amountRead = 0;
        this._totalAmountRead = 0;
    }

    AlternateLocationCollection getAltLocsReceived() {
        return this._altLocsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuccessfulAltLoc(AlternateLocation alternateLocation) {
        Set set = this._badLocs;
        synchronized (set) {
            this._writtenBadLocs.remove((Object)alternateLocation);
            this._badLocs.remove((Object)alternateLocation);
        }
        set = this._goodLocs;
        synchronized (set) {
            if (!this._writtenGoodLocs.contains((Object)alternateLocation)) {
                this._goodLocs.add((Object)alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailedAltLoc(AlternateLocation alternateLocation) {
        Set set = this._goodLocs;
        synchronized (set) {
            this._writtenGoodLocs.remove((Object)alternateLocation);
            this._goodLocs.remove((Object)alternateLocation);
        }
        set = this._badLocs;
        synchronized (set) {
            if (!this._writtenBadLocs.contains((Object)alternateLocation)) {
                this._badLocs.add((Object)alternateLocation);
            }
        }
    }

    public void connectTCP(int n) throws IOException {
        try {
            if (this._socket == null) {
                long l = System.currentTimeMillis();
                this._socket = Sockets.connect(this._host, this._port, n);
                NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - l));
            }
            Sockets.setKeepAlive(this._socket, true);
            this._input = this._socket.getInputStream();
            this._output = new BufferedOutputStream(this._socket.getOutputStream());
        }
        catch (IOException iOException) {
            throw new CantConnectException();
        }
        this._socket.setSoTimeout(8000);
        this._byteReader = new ByteReader(this._input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(int n, int n2, boolean bl) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, RangeNotAvailableException, ProblemReadingHeaderException, UnknownCodeException {
        Object object;
        Object object2;
        HTTPHeaderValue hTTPHeaderValue;
        if (n < 0) {
            throw new IllegalArgumentException("invalid start: " + n);
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("stop(" + n2 + ") <= start(" + n + ")");
        }
        this._amountToRead = n2 - n;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0;
        this._initialReadingPoint = n;
        this._bodyConsumed = false;
        this._contentLength = 0;
        HashSet hashSet = new HashSet();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this._output);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        String string = String.valueOf(this._initialReadingPoint);
        bufferedWriter.write("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1\r\n");
        bufferedWriter.write("HOST: " + this._host + ":" + this._port + "\r\n");
        bufferedWriter.write("User-Agent: " + CommonUtils.getHttpServer() + "\r\n");
        if (bl) {
            bufferedWriter.write("X-Queue: 0.1\r\n");
            hashSet.add((Object)ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        if (this.isPartialFileValid()) {
            hTTPHeaderValue = AlternateLocation.create(this._rfd.getSHA1Urn());
            this.addSuccessfulAltLoc((AlternateLocation)hTTPHeaderValue);
        }
        if ((hTTPHeaderValue = this._rfd.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, hTTPHeaderValue, (Writer)bufferedWriter);
        }
        HashSet hashSet2 = null;
        Set set = this._goodLocs;
        synchronized (set) {
            if (this._goodLocs.size() > 0) {
                hashSet2 = new HashSet();
                object2 = this._goodLocs.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    hashSet2.add(object);
                    this._writtenGoodLocs.add(object);
                }
                this._goodLocs.clear();
            }
        }
        if (hashSet2 != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)hashSet2), (Writer)bufferedWriter);
        }
        hashSet2 = null;
        set = this._badLocs;
        synchronized (set) {
            if (this._badLocs.size() > 0) {
                hashSet2 = new HashSet();
                object2 = this._badLocs.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    hashSet2.add(object);
                    this._writtenBadLocs.add(object);
                }
                this._badLocs.clear();
            }
        }
        if (hashSet2 != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.NALTS, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)hashSet2), (Writer)bufferedWriter);
        }
        bufferedWriter.write("Range: bytes=" + string + "-" + (n2 - 1) + "\r\n");
        this._requestedInterval = new Interval(this._initialReadingPoint, n2 - 1);
        if (ChatSettings.CHAT_ENABLED.getValue() && RouterService.acceptedIncomingConnection() && !NetworkUtils.isPrivateAddress(RouterService.getAddress())) {
            int n3 = RouterService.getPort();
            object2 = NetworkUtils.ip2string(RouterService.getAddress());
            bufferedWriter.write("X-Node: " + (String)object2 + ":" + n3 + "\r\n");
            hashSet.add((Object)ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                bufferedWriter.write("Chat: " + (String)object2 + ":" + n3 + "\r\n");
                hashSet.add((Object)ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (hashSet.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)hashSet), (Writer)bufferedWriter);
        }
        bufferedWriter.write("\r\n");
        bufferedWriter.flush();
        this.readHeaders();
    }

    public void consumeBodyIfNecessary() {
        LOG.trace((Object)"enter consumeBodyIfNecessary");
        try {
            if (!this._bodyConsumed) {
                this.consumeBody(this._contentLength);
            }
        }
        catch (IOException iOException) {}
        this._bodyConsumed = true;
    }

    public ConnectionStatus requestHashTree() {
        String string;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port));
        }
        try {
            string = "GET " + this._thexUri + " HTTP/1.1\r\n";
            this._output.write(string.getBytes());
            string = "HOST: " + this._host + ":" + this._port + "\r\n";
            this._output.write(string.getBytes());
            string = "User-Agent: " + CommonUtils.getHttpServer() + "\r\n";
            this._output.write(string.getBytes());
            string = "\r\n";
            this._output.write(string.getBytes());
            this._output.flush();
        }
        catch (IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"connection failed during sending hashtree request");
            }
            return ConnectionStatus.getConnected();
        }
        try {
            string = this._byteReader.readLine();
            if (string == null) {
                throw new IOException("disconnected");
            }
            int n = HTTPDownloader.parseHTTPCode(string, this._rfd);
            if (n < 200 || n >= 300) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("invalid HTTP code: " + n));
                }
                this._rfd.setTHEXFailed();
                return this.consumeResponse(n);
            }
            int n2 = this.consumeHeaders(null);
            InputStream inputStream = this._input;
            if (n2 != -1) {
                inputStream = new CountingInputStream(this._input);
            }
            try {
                HashTree hashTree = HashTree.createHashTree(inputStream, this._rfd.getSHA1Urn().toString(), this._root32, this._rfd.getSize());
                this._thexSucceeded = true;
                return ConnectionStatus.getThexResponse(hashTree);
            }
            catch (IOException iOException) {
                if (inputStream instanceof CountingInputStream) {
                    LOG.debug((Object)"failed with contentLength", (Throwable)iOException);
                    this._rfd.setTHEXFailed();
                    int n3 = ((CountingInputStream)inputStream).getAmountRead();
                    return this.consumeBody(n2 - n3);
                }
                throw iOException;
            }
        }
        catch (IOException iOException) {
            LOG.debug((Object)"failed without contentLength", (Throwable)iOException);
            this._rfd.setTHEXFailed();
            return ConnectionStatus.getConnected();
        }
    }

    private int consumeHeaders(int[] nArray) throws IOException {
        String string;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming headers"));
        }
        int n = -1;
        while ((string = this._byteReader.readLine()) != null && !string.equals("")) {
            if (HTTPHeaderName.CONTENT_LENGTH.matchesStartOfString(string)) {
                String string2 = HTTPUtils.extractHeaderValue(string);
                if (string2 == null) continue;
                try {
                    n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                continue;
            }
            if (nArray == null || !HTTPHeaderName.QUEUE.matchesStartOfString(string)) continue;
            this.parseQueueHeaders(string, nArray);
        }
        return n;
    }

    private ConnectionStatus consumeResponse(int n) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " consuming response, code: " + n));
        }
        int[] nArray = new int[]{-1, -1, -1};
        int n2 = this.consumeHeaders(nArray);
        if (n == 503) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = nArray[2];
            if (n3 != -1 && n4 != -1 && n5 != -1) {
                return ConnectionStatus.getQueued(n5, n3);
            }
        }
        return this.consumeBody(n2);
    }

    private ConnectionStatus consumeBody(int n) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("enter consumeBody(" + n + ")"));
        }
        if (n < 0) {
            throw new IOException("unknown content-length, can't consume");
        }
        byte[] byArray = new byte[1024];
        while (n > 0) {
            int n2 = Math.min(byArray.length, n);
            int n3 = this._input.read(byArray, 0, n2);
            if (n3 == -1) break;
            n -= n3;
        }
        return ConnectionStatus.getConnected();
    }

    private void readHeaders() throws IOException {
        int n;
        int n2;
        Interval interval;
        if (this._byteReader == null) {
            throw new ReaderIsNullException();
        }
        String string = this._byteReader.readLine();
        if (string == null || string.equals("")) {
            throw new IOException();
        }
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
        }
        int n3 = HTTPDownloader.parseHTTPCode(string, this._rfd);
        int[] nArray = new int[]{-1, -1, -1};
        while ((string = this._byteReader.readLine()) != null && !string.equals("")) {
            if (!CommonUtils.isJava118()) {
                BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
            }
            if (string.toUpperCase().startsWith("CONTENT-RANGE:")) {
                interval = this.parseContentRange(string);
                n2 = interval.low;
                n = interval.high + 1;
                if (n2 < this._initialReadingPoint || n > this._initialReadingPoint + this._amountToRead) {
                    throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1) + "... given low: " + n2 + ", high: " + n);
                }
                this._initialReadingPoint = n2;
                this._amountToRead = n - n2;
                continue;
            }
            if (HTTPHeaderName.CONTENT_LENGTH.matchesStartOfString(string)) {
                this._contentLength = HTTPDownloader.readContentLength(string);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.matchesStartOfString(string)) {
                this.checkContentUrnHeader(string, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(string)) {
                this.checkContentUrnHeader(string, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.matchesStartOfString(string)) {
                this.readAlternateLocations(string);
                continue;
            }
            if (HTTPHeaderName.QUEUE.matchesStartOfString(string)) {
                this.parseQueueHeaders(string, nArray);
                continue;
            }
            if (HTTPHeaderName.SERVER.matchesStartOfString(string)) {
                this._server = HTTPDownloader.readServer(string);
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.matchesStartOfString(string)) {
                this.parseAvailableRangesHeader(string, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.matchesStartOfString(string)) {
                HTTPDownloader.parseRetryAfterHeader(string, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.matchesStartOfString(string)) {
                HTTPDownloader.parseCreationTimeHeader(string, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.matchesStartOfString(string)) {
                this.parseFeatureHeader(string);
                continue;
            }
            if (!HTTPHeaderName.THEX_URI.matchesStartOfString(string)) continue;
            this.parseTHEXHeader(string);
        }
        if (n3 < 200 || n3 >= 300) {
            if (n3 == 404) {
                throw new FileNotFoundException();
            }
            if (n3 == 410) {
                throw new NotSharingException();
            }
            if (n3 == 416) {
                if (this._rfd.isPartialSource()) {
                    interval = this._rfd.getAvailableRanges().getAllIntervals();
                    while (interval.hasNext()) {
                        Interval interval2 = (Interval)interval.next();
                        if (!this._requestedInterval.isSubrange(interval2)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (n3 == 503) {
                int n4 = nArray[0];
                n2 = nArray[1];
                n = nArray[2];
                if (n4 != -1 && n2 != -1 && n != -1) {
                    throw new QueuedException(n4, n2, n);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(n3);
        }
    }

    private void checkContentUrnHeader(String string, URN uRN) throws ContentUrnMismatchException {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (this._root32 == null && string2.indexOf("urn:bitprint:") > -1) {
            this._root32 = string2.substring(string2.lastIndexOf(".") + 1).trim();
        }
        if (uRN == null) {
            return;
        }
        URN uRN2 = null;
        try {
            uRN2 = URN.createSHA1Urn(string2);
        }
        catch (IOException iOException) {
            return;
        }
        if (!uRN.equals(uRN2)) {
            throw new ContentUrnMismatchException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAlternateLocations(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                AlternateLocation alternateLocation = AlternateLocation.create(stringTokenizer.nextToken().trim(), this._rfd.getSHA1Urn());
                URN uRN = alternateLocation.getSHA1Urn();
                if (uRN == null) continue;
                String string3 = NetworkUtils.ip2string(alternateLocation.getHost().getHostBytes());
                if (!IPFilter.instance().allow(string3)) continue;
                if (this._altLocsReceived == null) {
                    this._altLocsReceived = AlternateLocationCollection.create(uRN);
                }
                boolean bl = false;
                if (!uRN.equals(this._altLocsReceived.getSHA1Urn())) continue;
                AlternateLocationCollection alternateLocationCollection = this._altLocsReceived;
                synchronized (alternateLocationCollection) {
                    bl = this._altLocsReceived.add(alternateLocation);
                }
                if (!ManagedDownloader.RECORD_STATS || !bl) continue;
                DownloadStat.ALTERNATE_COLLECTED.incrementStat();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && UploadSettings.ALLOW_PARTIAL_SHARING.getValue() && !this._outIsCorrupted && RouterService.acceptedIncomingConnection() && this._incompleteFile.length() > (long)MIN_PARTIAL_FILE_BYTES && NetworkUtils.isValidPort(RouterService.getPort()) && NetworkUtils.isValidAddress(RouterService.getAddress()) && !NetworkUtils.isPrivateAddress(RouterService.getAddress());
    }

    public static String readServer(String string) {
        int n = string.indexOf(58);
        if (n != -1 && n < string.length() - 1) {
            return string.substring(n + 1).trim();
        }
        return "";
    }

    public static int readContentLength(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static int parseHTTPCode(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + string);
        }
        remoteFileDesc.setHTTP11(string2.indexOf("1.1") > 0);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseQueueHeaders(String var1_1, int[] var2_2) {
        if (var1_1 == null) {
            return;
        }
        var3_3 = new StringTokenizer(var1_1, " ,:=");
        if (!var3_3.hasMoreTokens()) {
            return;
        }
        var4_4 = var3_3.nextToken();
        if (var4_4.equalsIgnoreCase("X-Queue")) ** GOTO lbl28
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.nextToken();
            try {
                if (var4_4.equalsIgnoreCase("pollMin")) {
                    var5_5 = var3_3.nextToken();
                    var2_2[0] = Integer.parseInt(var5_5);
                    continue;
                }
                if (var4_4.equalsIgnoreCase("pollMax")) {
                    var5_5 = var3_3.nextToken();
                    var2_2[1] = Integer.parseInt(var5_5);
                    continue;
                }
                if (!var4_4.equalsIgnoreCase("position")) continue;
                var5_5 = var3_3.nextToken();
                var2_2[2] = Integer.parseInt(var5_5);
                continue;
            }
            catch (NumberFormatException v0) {
                Arrays.fill((int[])var2_2, (int)-1);
                continue;
            }
            catch (NoSuchElementException v1) {
                Arrays.fill((int[])var2_2, (int)-1);
            }
lbl28:
            // 7 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl29:
        // 1 sources

    }

    private Interval parseContentRange(String string) throws IOException {
        int n;
        int n2;
        int n3;
        try {
            int n4 = string.indexOf("bytes") + 6;
            int n5 = string.indexOf(47);
            if (string.substring(n4, n5).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like */?, " + string));
                }
                return new Interval(0, this._amountToRead - 1);
            }
            int n6 = string.lastIndexOf("-");
            n3 = Integer.parseInt(string.substring(n4, n6));
            n2 = Integer.parseInt(string.substring(n6 + 1, n5));
            if (n2 < n3) {
                throw new ProblemReadingHeaderException("invalid range, high (" + n2 + ") less than low (" + n3 + ")");
            }
            if (string.substring(n5 + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this._rfd + " Content-Range like #-#/*, " + string));
                }
                return new Interval(n3, n2);
            }
            n = Integer.parseInt(string.substring(n5 + 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(string);
        }
        if (n2 == n) {
            --n3;
            --n2;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this._rfd + " Content-Range like #-#/#, " + string));
        }
        return new Interval(n3, n2);
    }

    private void parseAvailableRangesHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        IntervalSet intervalSet = new IntervalSet();
        string = string.toLowerCase();
        int n = string.indexOf("bytes") + 6;
        while (n != -1 && n < string.length()) {
            int n2 = string.indexOf(45, n);
            if (n2 == -1) break;
            Interval interval = null;
            try {
                int n3;
                int n4 = Integer.parseInt(string.substring(n, n2).trim());
                n = n2 + 1;
                n2 = string.indexOf(44, n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                if ((n3 = Integer.parseInt(string.substring(n, n2).trim())) >= remoteFileDesc.getSize()) {
                    n3 = remoteFileDesc.getSize() - 1;
                }
                if (n4 > n3) continue;
                interval = new Interval(n4, n3);
                n = n2 + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException(numberFormatException);
            }
            intervalSet.add(interval);
        }
        remoteFileDesc.setAvailableRanges(intervalSet);
    }

    private static void parseRetryAfterHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        string = HTTPUtils.extractHeaderValue(string);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        n = Math.max(n, 60);
        n = Math.min(n, 3600);
        remoteFileDesc.setRetryAfter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseCreationTimeHeader(String string, RemoteFileDesc remoteFileDesc) throws IOException {
        string = HTTPUtils.extractHeaderValue(string);
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException(numberFormatException);
        }
        if (remoteFileDesc.getSHA1Urn() != null) {
            CreationTimeCache creationTimeCache;
            CreationTimeCache creationTimeCache2 = creationTimeCache = CreationTimeCache.instance();
            synchronized (creationTimeCache2) {
                Long l2 = creationTimeCache.getCreationTime(remoteFileDesc.getSHA1Urn());
                if (l2 == null || l2 > l) {
                    creationTimeCache.addTime(remoteFileDesc.getSHA1Urn(), l);
                }
            }
        }
    }

    private void parseFeatureHeader(String string) {
        string = HTTPUtils.extractHeaderValue(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase().trim() : string2.substring(0, n).toLowerCase().trim();
            if (string3.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (!string3.equals("browse")) continue;
            this._browseEnabled = true;
        }
    }

    private void parseTHEXHeader(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(this._host) + ":" + this._port + ">" + string));
        }
        if ((string = HTTPUtils.extractHeaderValue(string)).indexOf(";") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            this._thexUri = stringTokenizer.nextToken();
            this._root32 = stringTokenizer.nextToken();
        } else {
            this._thexUri = string;
        }
    }

    public void doDownload(VerifyingFile verifyingFile) throws IOException {
        this._socket.setSoTimeout(600000);
        long l = this._initialReadingPoint;
        try {
            int n;
            this._isActive = true;
            int n2 = -1;
            byte[] byArray = new byte[1024];
            while (this._amountRead < (n = this._amountToRead)) {
                int n3 = n - this._amountRead;
                Assert.that(n3 > 0);
                int n4 = THROTTLE.request(Math.min(1024, n3));
                n2 = this._byteReader.read(byArray, 0, n4);
                if (n2 == -1) break;
                if (!CommonUtils.isJava118()) {
                    BandwidthStat.HTTP_BODY_DOWNSTREAM_BANDWIDTH.addData(n2);
                }
                verifyingFile.writeBlock(l, n2, byArray);
                this._outIsCorrupted = verifyingFile.isCorrupted();
                l += (long)n2;
                this._amountRead += n2;
            }
            if (this._amountRead < this._amountToRead) {
                throw new FileIncompleteException();
            }
        }
        finally {
            this._bodyConsumed = true;
            this._isActive = false;
            if (!this.isHTTP11()) {
                this._byteReader.close();
            }
        }
    }

    public void stop() {
        if (this._byteReader != null) {
            this._byteReader.close();
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._input != null) {
                this._input.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._output != null) {
                this._output.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void stopAt(int n) {
        this._amountToRead = n - this._initialReadingPoint;
    }

    public int getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public int getAmountRead() {
        return this._amountRead;
    }

    public int getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public int getAmountToRead() {
        return this._amountToRead;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isPush() {
        return this._isPush;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.getTotalAmountRead());
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean bl) {
        THROTTLE.setSwitching(bl);
    }

    private HTTPDownloader(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this._byteReader = new ByteReader(byteArrayInputStream);
        this._altLocsReceived = null;
        this._goodLocs = null;
        this._badLocs = null;
        this._writtenGoodLocs = null;
        this._writtenBadLocs = null;
        this._rfd = new RemoteFileDesc("127.0.0.1", 1, 0L, "a", 0, new byte[16], 0, false, 0, false, null, null, false, false, "", 0L, null);
    }
}

