/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientManager {
    private static final Log LOG;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int TIMEOUT = 8000;
    private static final int MAXIMUM_REDIRECTS = 10;
    private static final long IDLE_TIME = 30000L;
    private static final HttpConnectionManager MANAGER;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.http.HttpClientManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        if (!CommonUtils.isJava118()) {
            MANAGER = new MultiThreadedHttpConnectionManager();
            ((MultiThreadedHttpConnectionManager)MANAGER).setIdleConnectionTime(30000L);
        } else {
            MANAGER = null;
        }
    }

    public static HttpClient getNewClient() {
        return HttpClientManager.getNewClient(5000, 8000);
    }

    public static HttpClient getNewClient(int n, int n2) {
        HttpClient httpClient = CommonUtils.isJava118() ? new HttpClient() : new HttpClient(MANAGER);
        httpClient.setConnectionTimeout(n);
        httpClient.setTimeout(n2);
        int n3 = ConnectionSettings.CONNECTION_METHOD.getValue();
        if (n3 == 1) {
            httpClient.getHostConfiguration().setProxy(ConnectionSettings.PROXY_HOST.getValue(), ConnectionSettings.PROXY_PORT.getValue());
        } else if (n3 == 4 || n3 == 5) {
            HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
            String string = ConnectionSettings.PROXY_HOST.getValue();
            int n4 = ConnectionSettings.PROXY_PORT.getValue();
            String string2 = null;
            String string3 = null;
            if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
                string2 = ConnectionSettings.PROXY_USERNAME.getValue();
                string3 = ConnectionSettings.PROXY_PASS.getValue();
            }
            if (n3 == 4) {
                hostConfiguration.setSOCKSProxySettings(4, string, n4, string2, string3);
            } else {
                hostConfiguration.setSOCKSProxySettings(5, string, n4, string2, string3);
            }
        }
        return httpClient;
    }

    public static void executeMethodRedirecting(HttpClient httpClient, HttpMethod httpMethod) throws IOException, HttpException {
        HttpClientManager.executeMethodRedirecting(httpClient, httpMethod, 10);
    }

    public static void executeMethodRedirecting(HttpClient httpClient, HttpMethod httpMethod, int n) throws IOException, HttpException {
        int n2 = 0;
        while (n2 < n) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Attempting connection (" + n2 + ") to " + httpMethod.getURI().getEscapedURI()));
            }
            httpClient.executeMethod(httpMethod);
            switch (httpMethod.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (!httpMethod.getFollowRedirects()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn((Object)"Redirect requested but not supported");
                        }
                        throw new HttpException("Redirect requested");
                    }
                    Header header = httpMethod.getResponseHeader("location");
                    if (header == null) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn((Object)"Redirect requested, no location header");
                        }
                        throw new HttpException("Redirected without a location");
                    }
                    String string = header.getValue();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Redirected requested to: " + string));
                    }
                    URI uRI = new URI(string.toCharArray());
                    Header[] headerArray = httpMethod.getRequestHeaders();
                    httpMethod.recycle();
                    HostConfiguration hostConfiguration = httpMethod.getHostConfiguration();
                    hostConfiguration.setHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    httpMethod.setFollowRedirects(true);
                    int n3 = 0;
                    while (n3 < headerArray.length) {
                        if (!headerArray[n3].getName().equals("Host")) {
                            httpMethod.addRequestHeader(headerArray[n3]);
                        }
                        ++n3;
                    }
                    httpMethod.setPath(uRI.getEscapedPath());
                    httpMethod.setQueryString(uRI.getEscapedQuery());
                    httpMethod.removeRequestHeader("Authorization");
                    break;
                }
                default: {
                    return;
                }
            }
            ++n2;
        }
        throw new HttpException("Maximum redirects encountered, bailing");
    }
}

