/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache
implements Serializable {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final transient Log LOG;
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.tigertree.TigerTreeCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
    }

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fileDesc) {
        HashTree hashTree = (HashTree)TREE_MAP.get((Object)fileDesc.getSHA1Urn());
        if (hashTree == null) {
            QUEUE.add(new HashRunner(fileDesc));
        }
        return hashTree;
    }

    public synchronized HashTree getHashTree(URN uRN) {
        HashTree hashTree = (HashTree)TREE_MAP.get((Object)uRN);
        return hashTree;
    }

    public synchronized void purgeTree(URN uRN) {
        TREE_MAP.remove((Object)uRN);
    }

    public static synchronized void addHashTree(URN uRN, HashTree hashTree) {
        if (hashTree.isGoodDepth()) {
            TREE_MAP.put((Object)uRN, (Object)hashTree);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + uRN + ";" + hashTree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + uRN + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * Exception decompiling
     */
    private static Map createMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (RouterService.getFileManager().getFileDescForUrn(uRN) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(uRN) != null || Math.random() > (double)(map.size() / 200)) continue;
            map.remove((Object)uRN);
        }
    }

    public synchronized void persistCache() {
        TigerTreeCache.removeOldEntries(TREE_MAP);
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new FileOutputStream(CACHE_FILE));
                objectOutputStream.writeObject(TREE_MAP);
            }
            catch (Exception exception) {
                ErrorService.error(exception);
            }
        }
        catch (Throwable throwable) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (objectOutputStream != null) {
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fileDesc) {
            this.FD = fileDesc;
        }

        public void run() {
            try {
                URN uRN = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(uRN) == null) {
                    HashTree hashTree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(uRN, hashTree);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

