/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.I18NConvert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;

public final class CommonUtils {
    private static final String LIMEWIRE_VERSION = "4.0.10";
    private static String testVersion = null;
    private static final int _majorVersionNumber = CommonUtils.getMajorVersionNumberInternal("4.0.10");
    private static final int _minorVersionNumber = CommonUtils.getMinorVersionNumberInternal("4.0.10");
    private static final int _serviceVersionNumber = CommonUtils.getServiceVersionNumberInternal("4.0.10");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final Properties PROPS = System.getProperties();
    private static boolean _isWindows = false;
    private static boolean _isWindowsNT = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsNTor2000orXP = false;
    private static boolean _isWindows2000orXP = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _isWindowsMe = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static boolean _isOS2 = false;
    private static final char[] ILLEGAL_CHARS_ANY_OS;
    private static final char[] ILLEGAL_CHARS_UNIX;
    private static final char[] ILLEGAL_CHARS_WINDOWS;
    private static boolean _isJava118;
    private static final String HTTP_SERVER;
    private static final String LIMEWIRE_PREFS_DIR_NAME = ".cabos";
    private static final File CURRENT_DIRECTORY;
    private static boolean _isPro;
    static File SETTINGS_DIRECTORY;
    static /* synthetic */ Class class$0;

    static {
        char[] cArray = new char[6];
        cArray[0] = 47;
        cArray[1] = 10;
        cArray[2] = 13;
        cArray[3] = 9;
        cArray[5] = 12;
        ILLEGAL_CHARS_ANY_OS = cArray;
        ILLEGAL_CHARS_UNIX = new char[]{'`'};
        ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
        _isJava118 = false;
        CURRENT_DIRECTORY = new File(PROPS.getProperty("user.dir"));
        _isPro = false;
        SETTINGS_DIRECTORY = null;
        String string = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean bl = _isWindows = string.indexOf("windows") != -1;
        if (string.indexOf("windows nt") != -1 || string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindowsNTor2000orXP = true;
        }
        if (string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindows2000orXP = true;
        }
        if (string.indexOf("windows nt") != -1) {
            _isWindowsNT = true;
        }
        if (string.indexOf("windows xp") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        }
        if (string.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = string.indexOf("solaris") != -1;
        _isLinux = string.indexOf("linux") != -1;
        boolean bl2 = _isOS2 = string.indexOf("os/2") != -1;
        if (string.startsWith("mac os")) {
            if (string.endsWith("x")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
        if (CommonUtils.getJavaVersion().startsWith("1.1.8")) {
            _isJava118 = true;
        }
        HTTP_SERVER = "LimeWire/4.0.10 (Cabos/0.6.3)";
    }

    private CommonUtils() {
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        if (testVersion == null) {
            return LIMEWIRE_VERSION;
        }
        return testVersion;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    public static int getServiceVersionNumber() {
        return _serviceVersionNumber;
    }

    static int getMajorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(0, n);
                return new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    public static boolean isTestingVersion() {
        return LIMEWIRE_VERSION.equals("@version@");
    }

    static int getMinorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(n + 1);
                int n2 = string2.indexOf(".");
                String string3 = string2.substring(0, n2);
                return new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 7;
    }

    static int getServiceVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n;
                int n2 = string.indexOf(".");
                int n3 = string.indexOf(".", n2 + 1);
                int n4 = n = n3 + 1;
                while (n4 < string.length() && Character.isDigit(string.charAt(n4))) {
                    ++n4;
                }
                if (n != n4) {
                    String string2 = string.substring(n, n4);
                    return new Integer(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public static String getVendor() {
        return "Cabos 0.6.3";
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static String getOSVersion() {
        return PROPS.getProperty("os.version");
    }

    public static File getCurrentDirectory() {
        return CURRENT_DIRECTORY;
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isUltrapeerOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isMacClassic && !_isWindowsNT;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsNTor2000orXP() {
        return _isWindowsNTor2000orXP;
    }

    public static boolean isWindows2000orXP() {
        return _isWindows2000orXP;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isJaguarOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.2");
    }

    public static boolean isPantherOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.3");
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isJava118() {
        return _isJava118;
    }

    public static boolean isJava13OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJava14OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static int copy(File file, int n, File file2) {
        int n2 = n;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                while (n2 > 0) {
                    int n3 = inputStream.read(byArray, 0, Math.min(1024, n2));
                    if (n3 != -1) {
                        n2 -= n3;
                        outputStream.write(byArray, 0, n3);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        return n - n2;
    }

    public static boolean copy(File file, File file2) {
        long l = file.length();
        return (long)CommonUtils.copy(file, (int)l, file2) == l;
    }

    public static File getUserHomeDir() {
        return new File(PROPS.getProperty("user.home"));
    }

    public static String getUserName() {
        return PROPS.getProperty("user.name");
    }

    public static synchronized File getUserSettingsDir() {
        Object object;
        if (SETTINGS_DIRECTORY != null) {
            return SETTINGS_DIRECTORY;
        }
        File file = new File(CommonUtils.getUserHomeDir(), LIMEWIRE_PREFS_DIR_NAME);
        if (CommonUtils.isMacOSX()) {
            object = new File(CommonUtils.getUserHomeDir(), "Library/Application Support");
            file = new File((File)object, "Cabos");
        }
        if (!file.isDirectory()) {
            file.delete();
            if (!file.mkdirs()) {
                object = "could not create preferences directory: " + file;
                throw new RuntimeException((String)object);
            }
        }
        if (!file.canWrite()) {
            throw new RuntimeException("settings dir not writable");
        }
        if (!file.canRead()) {
            throw new RuntimeException("settings dir not readable");
        }
        SETTINGS_DIRECTORY = file;
        return file;
    }

    public static File getResourceFile(String string) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.util.CommonUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            return new File(string);
        }
        return new File(CommonUtils.decode(uRL.getFile()));
    }

    public static InputStream getResourceStream(String string) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.util.CommonUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("null resource: " + string);
        }
        return uRL.openStream();
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(string);
                    }
                    n += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        try {
            byte[] byArray = string2.getBytes("8859_1");
            string2 = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string2;
    }

    public static String convertFileName(String string) {
        block7: {
            int n;
            block6: {
                string = I18NConvert.instance().compose(string);
                if (string.length() > 180) {
                    n = string.lastIndexOf(46);
                    if (n == -1) {
                        string = string.substring(0, 180);
                    } else {
                        int n2 = string.length() - n;
                        int n3 = n2 > 11 ? n + 11 : string.length();
                        string = String.valueOf(string.substring(0, 180 - n2)) + string.substring(n, n3);
                    }
                }
                n = 0;
                while (n < ILLEGAL_CHARS_ANY_OS.length) {
                    string = string.replace(ILLEGAL_CHARS_ANY_OS[n], '_');
                    ++n;
                }
                if (!_isWindows) break block6;
                n = 0;
                while (n < ILLEGAL_CHARS_WINDOWS.length) {
                    string = string.replace(ILLEGAL_CHARS_WINDOWS[n], '_');
                    ++n;
                }
                break block7;
            }
            if (!_isLinux && !_isSolaris) break block7;
            n = 0;
            while (n < ILLEGAL_CHARS_UNIX.length) {
                string = string.replace(ILLEGAL_CHARS_UNIX[n], '_');
                ++n;
            }
        }
        return string;
    }

    public static boolean recordStats() {
        return !CommonUtils.isJava118();
    }
}

