/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Vector;

public class ProcessingQueue {
    private final List QUEUE = new Vector();
    private final String NAME;
    private final boolean MANAGED;
    private Thread _runner = null;

    public ProcessingQueue(String string) {
        this(string, true);
    }

    public ProcessingQueue(String string, boolean bl) {
        this.NAME = string;
        this.MANAGED = bl;
    }

    public synchronized void add(Runnable runnable) {
        this.QUEUE.add((Object)runnable);
        this.notify();
        if (this._runner == null) {
            this.startRunner();
        }
    }

    private synchronized void startRunner() {
        this._runner = this.MANAGED ? new ManagedThread(new Processor(), this.NAME) : new Thread((Runnable)new Processor(), this.NAME);
        this._runner.setDaemon(true);
        this._runner.start();
    }

    private class Processor
    implements Runnable {
        Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Object object;
                    if (ProcessingQueue.this.QUEUE.size() <= 0) {
                        object = ProcessingQueue.this;
                        synchronized (object) {
                            if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                                continue;
                            }
                            try {
                                ProcessingQueue.this.wait(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                                continue;
                            }
                            break;
                        }
                    }
                    object = (Runnable)ProcessingQueue.this.QUEUE.remove(0);
                    object.run();
                }
            }
            catch (Throwable throwable) {
                ProcessingQueue processingQueue = ProcessingQueue.this;
                synchronized (processingQueue) {
                    if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                        ProcessingQueue.this.startRunner();
                    } else {
                        ProcessingQueue.this._runner = null;
                    }
                    throw throwable;
                }
            }
            ProcessingQueue processingQueue = ProcessingQueue.this;
            synchronized (processingQueue) {
                if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                    ProcessingQueue.this.startRunner();
                } else {
                    ProcessingQueue.this._runner = null;
                }
                return;
            }
        }
    }
}

