/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.TransferUpdate;

public class AqMain {
    private static InputStreamReader reader = null;
    private static OutputStreamWriter writer = null;
    private static Socket rSocket = null;
    protected static boolean shouldShutdown = false;

    public static void main(String[] stringArray) {
        try {
            rSocket = new Socket("localhost", 1024);
            reader = new InputStreamReader(rSocket.getInputStream(), "UTF-8");
            writer = new OutputStreamWriter(rSocket.getOutputStream(), "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        AqEvent.signalEvent(97);
        AqEventHandler aqEventHandler = new AqEventHandler();
        ErrorService.setErrorCallback(aqEventHandler);
        MessageService.setCallback(aqEventHandler);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        }
        RouterService routerService = new RouterService(aqEventHandler);
        routerService.start();
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
        AqEvent.signalEvent(98);
        AqMain.readLoop();
        RouterService.shutdown();
        AqMain.shutdown();
        System.exit(0);
    }

    private static void readLoop() {
        LinkedList linkedList = new LinkedList();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while (!shouldShutdown && (n = reader.read()) != -1) {
                char c = (char)n;
                if (c == '|' || c == '\n') {
                    linkedList.add((Object)stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n') continue;
                    try {
                        AqDispatcher.dispatchCommand((List)linkedList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    linkedList.clear();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.write("\n");
                writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                reader.close();
                writer.close();
                rSocket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

