/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOSocket;
import com.limegroup.gnutella.io.Shutdownable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BufferInputStream
extends InputStream
implements Shutdownable {
    private static final Log LOG;
    private final Object LOCK = new Object();
    private final NIOSocket handler;
    private final ByteBuffer buffer;
    private final SelectableChannel channel;
    private boolean shutdown = false;
    private boolean finished = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.BufferInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    BufferInputStream(ByteBuffer byteBuffer, NIOSocket nIOSocket, SelectableChannel selectableChannel) {
        this.handler = nIOSocket;
        this.buffer = byteBuffer;
        this.channel = selectableChannel;
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    void finished() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            block4: {
                this.waitImpl();
                if (!this.finished || this.buffer.position() != 0) break block4;
                return -1;
            }
            this.buffer.flip();
            byte by = this.buffer.get();
            this.buffer.compact();
            NIODispatcher.instance().interestRead(this.channel, true);
            return by & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        Object object = this.LOCK;
        synchronized (object) {
            block7: {
                this.waitImpl();
                if (!this.finished || this.buffer.position() != 0) break block7;
                return -1;
            }
            this.buffer.flip();
            int n3 = Math.min(this.buffer.remaining(), n2);
            this.buffer.get(byArray, n, n3);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            NIODispatcher.instance().interestRead(this.channel, true);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            return this.buffer.position();
        }
    }

    private void waitImpl() throws IOException {
        int n = this.handler.getSoTimeout();
        boolean bl = false;
        while (this.buffer.position() == 0 && !this.finished) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            if (bl && n != 0) {
                throw new java.io.InterruptedIOException("read timed out (" + n + ")");
            }
            try {
                this.LOCK.wait(n);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException);
            }
            bl = true;
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() throws IOException {
        NIODispatcher.instance().shutdown(this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

