/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LicenseCache {
    private static final Log LOG;
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "licenses.cache");
    private Map licenses;
    private Map data;
    private boolean dirty = false;
    private static final LicenseCache INSTANCE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.licenses.LicenseCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new LicenseCache();
    }

    private LicenseCache() {
        this.deserialize();
    }

    public static LicenseCache instance() {
        return INSTANCE;
    }

    synchronized void addVerifiedLicense(License license) {
        this.licenses.put(license.getLicenseURI(), license);
        this.dirty = true;
    }

    synchronized void addData(Object object, Object object2) {
        this.data.put(object, object2);
        this.dirty = true;
    }

    synchronized License getLicense(String string, URI uRI) {
        License license = (License)this.licenses.get(uRI);
        if (license != null) {
            return license.copy(string, uRI);
        }
        return null;
    }

    synchronized Object getData(Object object) {
        return this.data.get(object);
    }

    synchronized boolean isVerifiedAndValid(URN uRN, URI uRI) {
        License license = (License)this.licenses.get(uRI);
        return license != null && license.isValid(uRN);
    }

    private void deserialize() {
        ObjectInputStream objectInputStream = null;
        try {
            try {
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                HashMap hashMap = (HashMap)objectInputStream.readObject();
                if (hashMap != null) {
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Object k = entry.getKey();
                        Object v = entry.getValue();
                        if (k instanceof URI && v instanceof License) continue;
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Invalid k[" + k + "], v[" + v + "]"));
                        }
                        iterator.remove();
                    }
                } else {
                    hashMap = new HashMap();
                }
                this.licenses = hashMap;
                this.data = (Map)objectInputStream.readObject();
                this.removeOldEntries();
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Can't read licenses", throwable);
            }
        }
        catch (Throwable throwable) {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.licenses == null) {
                this.licenses = new HashMap();
            }
            if (this.data == null) {
                this.data = new HashMap();
            }
            throw throwable;
        }
        if (objectInputStream != null) {
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.licenses == null) {
            this.licenses = new HashMap();
        }
        if (this.data == null) {
            this.data = new HashMap();
        }
    }

    private void removeOldEntries() {
        long l = System.currentTimeMillis() - 604800000L;
        Iterator iterator = this.licenses.values().iterator();
        while (iterator.hasNext()) {
            License license = (License)iterator.next();
            if (license.getLastVerifiedTime() >= l) continue;
            this.dirty = true;
            iterator.remove();
        }
    }

    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
                objectOutputStream.writeObject(this.licenses);
                objectOutputStream.writeObject(this.data);
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }
        catch (Throwable throwable) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (objectOutputStream != null) {
            try {
                objectOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.dirty = false;
    }
}

