/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.udpconnect.UDPConnection;
import com.limegroup.gnutella.uploader.BannedUploadState;
import com.limegroup.gnutella.uploader.BrowseHostUploadState;
import com.limegroup.gnutella.uploader.BrowserControlUploadState;
import com.limegroup.gnutella.uploader.FileNotFoundUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.LimitReachedUploadState;
import com.limegroup.gnutella.uploader.MalformedRequestState;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.uploader.PushProxyUploadState;
import com.limegroup.gnutella.uploader.QueuedUploadState;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.THEXUploadState;
import com.limegroup.gnutella.uploader.UnavailableRangeUploadState;
import com.limegroup.gnutella.uploader.UpdateFileState;
import com.limegroup.gnutella.util.CountingOutputStream;
import com.limegroup.gnutella.util.MultiRRIterator;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HTTPUploader
implements Uploader {
    private static final Log LOG;
    private CountingOutputStream _ostream;
    private InputStream _fis;
    private Socket _socket;
    private int _totalAmountReadBefore;
    private int _totalAmountRead;
    private int _amountRead;
    private int _amountRequested;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _fileSize;
    private final int _index;
    private String _userAgent;
    private boolean _headersParsed;
    private final String _fileName;
    private final String _hostName;
    private int _stateNum = 0;
    private int _lastTransferStateNum;
    private HTTPMessage _state;
    private boolean _firstReply = true;
    private boolean _containedRangeRequest = false;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private boolean _supportsQueueing = false;
    private final boolean _hadPassword;
    private boolean _isForcedShare = false;
    private boolean _wantsFalts = false;
    private int _FWTVersion = 0;
    private final StalledUploadWatchdog STALLED_WATCHDOG;
    private URN _requestedURN;
    private FileDesc _fileDesc;
    private boolean _clientAcceptsXGnutellaQueryreplies = false;
    private InetAddress _nodeAddress = null;
    private int _nodePort = -1;
    private Map _parameters = null;
    private BandwidthTrackerImpl bandwidthTracker = null;
    private Set _writtenLocs;
    private Set _writtenPushLocs;
    private static final int MAX_LOCATIONS = 10;
    private static final int MAX_PUSH_LOCATIONS = 5;
    private HTTPRequestMethod _method;
    private final boolean debugOn = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.uploader.HTTPUploader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public HTTPUploader(HTTPRequestMethod hTTPRequestMethod, String string, Socket socket, int n, Map map, StalledUploadWatchdog stalledUploadWatchdog, boolean bl) {
        this.STALLED_WATCHDOG = stalledUploadWatchdog;
        this._socket = socket;
        this._hostName = this._socket.getInetAddress().getHostAddress();
        this._fileName = string;
        this._index = n;
        this._writtenLocs = null;
        this._hadPassword = bl;
        this.reinitialize(hTTPRequestMethod, map);
    }

    public void reinitialize(HTTPRequestMethod hTTPRequestMethod, Map map) {
        this._method = hTTPRequestMethod;
        this._amountRequested = 0;
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._headersParsed = false;
        this._stateNum = 0;
        this._state = null;
        this._nodePort = 0;
        this._supportsQueueing = false;
        this._requestedURN = null;
        this._clientAcceptsXGnutellaQueryreplies = false;
        this._parameters = map;
        this._totalAmountReadBefore = 0;
        if (this.bandwidthTracker == null) {
            this.bandwidthTracker = new BandwidthTrackerImpl();
            this._totalAmountRead = 0;
            this._amountRead = 0;
        } else {
            this._totalAmountRead += this._amountRead;
            this._amountRead = 0;
        }
    }

    public void setFileDesc(FileDesc fileDesc) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("trying to set the fd for uploader " + this + " with " + fileDesc));
        }
        this._fileDesc = fileDesc;
        this._fileSize = (int)fileDesc.getFileSize();
        if (this._writtenLocs == null) {
            this._writtenLocs = new HashSet();
        }
        if (this._writtenPushLocs == null) {
            this._writtenPushLocs = new HashSet();
        }
        if (this._fis != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this + " had an existing stream"));
            }
            try {
                this._fis.close();
            }
            catch (IOException iOException) {}
        }
        this._fis = this._fileDesc.createInputStream();
        this._isForcedShare = FileManager.isForcedShare(this._fileDesc);
    }

    public void initializeStreams() throws IOException {
        this._ostream = new CountingOutputStream(this._socket.getOutputStream());
    }

    public void writeResponse() throws IOException {
        block2: {
            this._ostream.setIsCounting(this._stateNum == 15);
            try {
                this._method.writeHttpResponse(this._state, this._ostream);
            }
            catch (IOException iOException) {
                if (this.amountUploaded() >= this.getAmountRequested()) break block2;
                throw iOException;
            }
        }
        this._firstReply = false;
    }

    public void stop() {
        try {
            if (this._ostream != null) {
                this._ostream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void closeFileStreams() {
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void setState(int n) {
        this._stateNum = n;
        switch (n) {
            case 3: {
                this._state = new NormalUploadState(this, this.STALLED_WATCHDOG);
                break;
            }
            case 9: {
                int n2 = RouterService.getUploadManager().positionInQueue(this._socket);
                this._state = new QueuedUploadState(n2, this);
                break;
            }
            case 2: {
                this._state = new LimitReachedUploadState(this);
                break;
            }
            case 1: {
                this._state = new FreeloaderUploadState();
                break;
            }
            case 8: {
                this._state = new BrowseHostUploadState(this);
                break;
            }
            case 16: {
                this._state = new BrowserControlUploadState(this);
                break;
            }
            case 12: {
                this._state = new PushProxyUploadState(this);
                break;
            }
            case 10: {
                this._state = new UpdateFileState(this);
                break;
            }
            case 7: {
                this._state = new FileNotFoundUploadState();
                break;
            }
            case 11: {
                this._state = new MalformedRequestState();
                break;
            }
            case 13: {
                this._state = new UnavailableRangeUploadState(this);
                break;
            }
            case 14: {
                this._state = new BannedUploadState();
                break;
            }
            case 15: {
                this._state = new THEXUploadState(this, this.STALLED_WATCHDOG);
                break;
            }
            case 0: 
            case 4: 
            case 5: {
                this._state = null;
                break;
            }
            default: {
                Assert.that(false, "Invalid state: " + n);
            }
        }
        if (this._state != null) {
            this._lastTransferStateNum = n;
        }
    }

    OutputStream getOutputStream() {
        return this._ostream;
    }

    InputStream getInputStream() {
        return this._fis;
    }

    public InetAddress getConnectedHost() {
        if (this._socket == null) {
            return null;
        }
        return this._socket.getInetAddress();
    }

    boolean isUDPTransfer() {
        return this._socket instanceof UDPConnection;
    }

    public boolean getCloseConnection() {
        Assert.that(this._state != null);
        return this._state.getCloseConnection();
    }

    public HTTPRequestMethod getMethod() {
        return this._method;
    }

    public int getQueuePosition() {
        if (this._lastTransferStateNum != 9 || this._stateNum == 5) {
            return -1;
        }
        return RouterService.getUploadManager().positionInQueue(this._socket);
    }

    void setAmountUploaded(int n) {
        int n2 = n - this._amountRead;
        if (n2 > 0) {
            if (this.isForcedShare()) {
                BandwidthStat.HTTP_BODY_UPSTREAM_INNETWORK_BANDWIDTH.addData(n2);
            } else {
                BandwidthStat.HTTP_BODY_UPSTREAM_BANDWIDTH.addData(n2);
            }
        }
        this._amountRead = n;
    }

    public boolean isInactive() {
        switch (this._stateNum) {
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    Map getParameters() {
        return this._parameters;
    }

    public int getUploadBegin() {
        return this._uploadBegin;
    }

    public int getUploadEnd() {
        return this._uploadEnd;
    }

    public void setUploadBeginAndEnd(int n, int n2) {
        this._uploadBegin = n;
        this._uploadEnd = n2;
        this._amountRequested = this._uploadEnd - this._uploadBegin;
    }

    public boolean containedRangeRequest() {
        return this._containedRangeRequest;
    }

    public int getFileSize() {
        if (this._stateNum == 15) {
            return this._fileDesc.getHashTree().getOutputLength();
        }
        return this._fileSize;
    }

    public int getAmountRequested() {
        if (this._stateNum == 15) {
            return this._fileDesc.getHashTree().getOutputLength();
        }
        return this._amountRequested;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getState() {
        return this._stateNum;
    }

    public int getLastTransferState() {
        return this._lastTransferStateNum;
    }

    public String getHost() {
        return this._hostName;
    }

    public boolean isChatEnabled() {
        return this._chatEnabled;
    }

    public boolean isBrowseHostEnabled() {
        return this._browseEnabled;
    }

    public int getGnutellaPort() {
        return this._nodePort;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public boolean isHeaderParsed() {
        return this._headersParsed;
    }

    public boolean isForcedShare() {
        return this._isForcedShare;
    }

    public boolean supportsQueueing() {
        return this._supportsQueueing && this.isValidQueueingAgent();
    }

    public boolean isTHEXRequest() {
        return "N2X?".equals(this._parameters.get("service_id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getNextSetOfAltsToSend() {
        AlternateLocationCollection alternateLocationCollection = RouterService.getAltlocManager().getDirect(this._fileDesc.getSHA1Urn());
        HashSet<AlternateLocation> hashSet = null;
        long l = System.currentTimeMillis();
        AlternateLocationCollection alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            Iterator iterator = alternateLocationCollection.iterator();
            int n = 0;
            while (iterator.hasNext() && n < 10) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                if (this._writtenLocs.contains(alternateLocation)) continue;
                if (alternateLocation.canBeSent(1)) {
                    this._writtenLocs.add(alternateLocation);
                    if (hashSet == null) {
                        hashSet = new HashSet<AlternateLocation>();
                    }
                    hashSet.add(alternateLocation);
                    ++n;
                    alternateLocation.send(l, 1);
                    continue;
                }
                if (alternateLocation.canBeSentAny()) continue;
                iterator.remove();
            }
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getNextSetOfPushAltsToSend() {
        if (!this._wantsFalts) {
            return Collections.EMPTY_SET;
        }
        AlternateLocationCollection alternateLocationCollection = RouterService.getAltlocManager().getPush(this._fileDesc.getSHA1Urn(), true);
        AlternateLocationCollection alternateLocationCollection2 = this._FWTVersion > 0 ? AlternateLocationCollection.EMPTY : RouterService.getAltlocManager().getPush(this._fileDesc.getSHA1Urn(), false);
        HashSet<PushAltLoc> hashSet = null;
        long l = System.currentTimeMillis();
        AlternateLocationCollection alternateLocationCollection3 = alternateLocationCollection2;
        synchronized (alternateLocationCollection3) {
            AlternateLocationCollection alternateLocationCollection4 = alternateLocationCollection;
            synchronized (alternateLocationCollection4) {
                MultiRRIterator multiRRIterator = new MultiRRIterator(new Iterator[]{alternateLocationCollection.iterator(), alternateLocationCollection2.iterator()});
                int n = 0;
                while (multiRRIterator.hasNext() && n < 5) {
                    PushAltLoc pushAltLoc = (PushAltLoc)multiRRIterator.next();
                    if (this._writtenPushLocs.contains(pushAltLoc)) continue;
                    if (pushAltLoc.getPushAddress().getProxies().isEmpty()) {
                        multiRRIterator.remove();
                        continue;
                    }
                    if (pushAltLoc.canBeSent(1)) {
                        pushAltLoc.send(l, 1);
                        this._writtenPushLocs.add(pushAltLoc);
                        if (hashSet == null) {
                            hashSet = new HashSet<PushAltLoc>();
                        }
                        hashSet.add(pushAltLoc);
                        ++n;
                        continue;
                    }
                    if (pushAltLoc.canBeSentAny()) continue;
                    multiRRIterator.remove();
                }
            }
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    private boolean isValidQueueingAgent() {
        if (this._userAgent == null) {
            return true;
        }
        return !this._userAgent.startsWith("Morpheus 3.0.2");
    }

    protected boolean isFirstReply() {
        return this._firstReply;
    }

    public InetAddress getNodeAddress() {
        return this._nodeAddress;
    }

    public int getNodePort() {
        return this._nodePort;
    }

    public int amountUploaded() {
        if (this._stateNum == 15) {
            if (this._ostream == null) {
                return 0;
            }
            return this._ostream.getAmountWritten();
        }
        return this._amountRead;
    }

    public int getTotalAmountUploaded() {
        if (this._stateNum == 15) {
            if (this._ostream == null) {
                return 0;
            }
            return this._ostream.getAmountWritten();
        }
        if (this._totalAmountReadBefore > 0) {
            return this._totalAmountReadBefore + this._amountRead;
        }
        return this._totalAmountRead + this._amountRead;
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    boolean getClientAcceptsXGnutellaQueryreplies() {
        return this._clientAcceptsXGnutellaQueryreplies;
    }

    public URN getRequestedURN() {
        return this._requestedURN;
    }

    public void readHeader(InputStream inputStream) throws IOException {
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._containedRangeRequest = false;
        this._clientAcceptsXGnutellaQueryreplies = false;
        this._totalAmountReadBefore = 0;
        ByteReader byteReader = new ByteReader(inputStream);
        try {
            try {
                String string;
                while ((string = byteReader.readLine()) != null) {
                    if (string.equals("")) {
                        break;
                    }
                    if (this.isForcedShare()) {
                        BandwidthStat.HTTP_HEADER_DOWNSTREAM_INNETWORK_BANDWIDTH.addData(string.length());
                    } else {
                        BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("HTTPUploader.readHeader(): str = " + string));
                    }
                    if (!this.readChatHeader(string) && !this.readRangeHeader(string) && !this.readUserAgentHeader(string) && !this.readContentURNHeader(string) && !this.readAltLocationHeader(string) && !this.readNAltLocationHeader(string) && !this.readFAltLocationHeader(string) && !this.readNFAltLocationHeader(string) && !this.readAcceptHeader(string) && !this.readQueueVersion(string) && !this.readNodeHeader(string) && !this.readFeatureHeader(string) && !this.readXDownloadedHeader(string)) continue;
                }
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {
                String string;
                while ((string = byteReader.readLine()) != null && !string.equals("")) {
                }
                throw problemReadingHeaderException;
            }
        }
        finally {
            if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                this._uploadEnd = this._fileSize;
            }
            this._amountRequested = this._uploadEnd - this._uploadBegin;
            this._headersParsed = true;
        }
    }

    private boolean readChatHeader(String string) throws IOException {
        int n;
        String string2;
        if (string.toUpperCase().indexOf("CHAT:") == -1) {
            return false;
        }
        try {
            string2 = string.substring(5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        string2 = string2.trim();
        int n2 = string2.indexOf(":");
        String string3 = string2.substring(0, n2);
        string3 = string3.trim();
        String string4 = string2.substring(n2 + 1);
        string4 = string4.trim();
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        this._chatEnabled = true;
        this._browseEnabled = true;
        this._nodePort = n;
        return true;
    }

    private boolean readXDownloadedHeader(String string) throws IOException {
        if (!HTTPHeaderName.DOWNLOADED.matchesStartOfString(string)) {
            return false;
        }
        try {
            string = HTTPUtils.extractHeaderValue(string);
            if (string != null) {
                this._totalAmountReadBefore = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return true;
    }

    private boolean readRangeHeader(String string) throws IOException {
        String string2;
        String string3;
        int n;
        if (StringUtils.indexOfIgnoreCase(string, "Range:") == -1) {
            return false;
        }
        this._containedRangeRequest = true;
        try {
            n = string.indexOf("bytes");
            if (n < 0) {
                throw new ProblemReadingHeaderException("bytes not present in range");
            }
            string3 = string.substring(n += 6);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        string3 = string3.trim();
        try {
            n = string3.charAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        if (n == 45) {
            String string4;
            try {
                string4 = string3.substring(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ProblemReadingHeaderException();
            }
            string4 = string4.trim();
            try {
                this._uploadBegin = Math.max(0, this._fileSize - Integer.parseInt(string4));
                this._uploadEnd = this._fileSize;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException();
            }
        }
        int n2 = string3.indexOf("-");
        if (n2 == -1) {
            throw new ProblemReadingHeaderException();
        }
        String string5 = string3.substring(0, n2).trim();
        try {
            this._uploadBegin = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProblemReadingHeaderException();
        }
        try {
            string2 = string3.substring(n2 + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ProblemReadingHeaderException();
        }
        string2 = string2.trim();
        if (!string2.equals("")) {
            try {
                this._uploadEnd = Integer.parseInt(string2) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProblemReadingHeaderException();
            }
        }
        return true;
    }

    private boolean readUserAgentHeader(String string) throws FreeloaderUploadingException {
        if (StringUtils.indexOfIgnoreCase(string, "User-Agent:") == -1) {
            return false;
        }
        if (!(SharingSettings.ALLOW_BROWSER.getValue() || this._stateNum == 8 || this._stateNum == 16 || this._stateNum == 12 || this._fileName.toUpperCase().startsWith("LIMEWIRE") || string.indexOf("Mozilla") == -1 && string.indexOf("Morpheus") == -1 && string.indexOf("DA") == -1 && string.indexOf("Download") == -1 && string.indexOf("FlashGet") == -1 && string.indexOf("GetRight") == -1 && string.indexOf("Go!Zilla") == -1 && string.indexOf("Inet") == -1 && string.indexOf("MIIxpc") == -1 && string.indexOf("MSProxy") == -1 && string.indexOf("Mass") == -1 && string.indexOf("MLdonkey") == -1 && string.indexOf("MyGetRight") == -1 && string.indexOf("NetAnts") == -1 && string.indexOf("NetZip") == -1 && string.indexOf("RealDownload") == -1 && string.indexOf("SmartDownload") == -1 && string.indexOf("Teleport") == -1 && string.indexOf("WebDownloader") == -1 || this._hadPassword)) {
            throw new FreeloaderUploadingException();
        }
        this._userAgent = string.substring(11).trim();
        return true;
    }

    private boolean readContentURNHeader(String string) {
        if (!HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(string)) {
            return false;
        }
        this._requestedURN = HTTPUploader.parseContentUrn(string);
        return true;
    }

    private boolean readAltLocationHeader(String string) {
        if (!HTTPHeaderName.ALT_LOCATION.matchesStartOfString(string)) {
            return false;
        }
        if (this._fileDesc != null) {
            this.parseAlternateLocations(string, true);
        }
        return true;
    }

    private boolean readNAltLocationHeader(String string) {
        if (!HTTPHeaderName.NALTS.matchesStartOfString(string)) {
            return false;
        }
        if (this._fileDesc != null) {
            this.parseAlternateLocations(string, false);
        }
        return true;
    }

    private boolean readFAltLocationHeader(String string) {
        if (!HTTPHeaderName.FALT_LOCATION.matchesStartOfString(string)) {
            return false;
        }
        this._wantsFalts = true;
        if (this._fileDesc != null) {
            this.parseAlternateLocations(string, true);
        }
        return true;
    }

    private boolean readNFAltLocationHeader(String string) {
        if (!HTTPHeaderName.BFALT_LOCATION.matchesStartOfString(string)) {
            return false;
        }
        this._wantsFalts = true;
        if (this._fileDesc != null) {
            this.parseAlternateLocations(string, false);
        }
        return true;
    }

    private boolean readAcceptHeader(String string) {
        if (StringUtils.indexOfIgnoreCase(string, "accept:") == -1) {
            return false;
        }
        if (StringUtils.indexOfIgnoreCase(string, "application/x-gnutella-packets") != -1) {
            this._clientAcceptsXGnutellaQueryreplies = true;
        }
        return true;
    }

    private boolean readQueueVersion(String string) {
        if (!HTTPHeaderName.QUEUE_HEADER.matchesStartOfString(string)) {
            return false;
        }
        this._supportsQueueing = true;
        return true;
    }

    private boolean readNodeHeader(String string) {
        if (!HTTPHeaderName.NODE.matchesStartOfString(string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(HTTPUtils.extractHeaderValue(string), ":");
        InetAddress inetAddress = null;
        int n = -1;
        if (stringTokenizer.countTokens() == 2) {
            try {
                inetAddress = InetAddress.getByName(stringTokenizer.nextToken().trim());
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (NetworkUtils.isValidPort(n)) {
                    this._nodeAddress = inetAddress;
                    this._nodePort = n;
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return true;
    }

    private boolean readFeatureHeader(String string) {
        if (!HTTPHeaderName.FEATURES.matchesStartOfString(string)) {
            return false;
        }
        string = HTTPUtils.extractHeaderValue(string);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading feature header: " + string));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase().trim() : string2.substring(0, n).toLowerCase().trim();
            if (string3.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (string3.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (string3.equals("queue")) {
                this._supportsQueueing = true;
                continue;
            }
            if (string3.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!string3.equals("fwt")) continue;
            try {
                this._FWTVersion = (int)HTTPUtils.parseFeatureToken(string2);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {}
        }
        return true;
    }

    private static URN parseContentUrn(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return URN.INVALID;
        }
        try {
            return URN.createSHA1Urn(string2);
        }
        catch (IOException iOException) {
            return URN.INVALID;
        }
    }

    private void parseAlternateLocations(String string, boolean bl) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        URN uRN = this._fileDesc.getSHA1Urn();
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                AlternateLocation alternateLocation = AlternateLocation.create(stringTokenizer.nextToken().trim(), this._fileDesc.getSHA1Urn());
                Assert.that(alternateLocation.getSHA1Urn().equals(uRN));
                if (alternateLocation.isMe()) continue;
                if (alternateLocation instanceof PushAltLoc) {
                    ((PushAltLoc)alternateLocation).updateProxies(bl);
                }
                if (bl) {
                    RouterService.getAltlocManager().add(alternateLocation, null);
                } else {
                    RouterService.getAltlocManager().remove(alternateLocation, null);
                }
                if (alternateLocation instanceof DirectAltLoc) {
                    this._writtenLocs.add(alternateLocation);
                    continue;
                }
                this._writtenPushLocs.add(alternateLocation);
            }
            catch (IOException iOException) {}
        }
    }

    public void measureBandwidth() {
        int n = this._totalAmountRead + this._amountRead;
        if (this._ostream != null) {
            n += this._ostream.getAmountWritten();
        }
        this.bandwidthTracker.measureBandwidth(n);
    }

    public float getMeasuredBandwidth() {
        float f = 0.0f;
        try {
            f = this.bandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        return f;
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public boolean wantsFAlts() {
        return this._wantsFalts;
    }

    public int wantsFWTAlts() {
        return this._FWTVersion;
    }

    private void debug(String string) {
    }

    public String toString() {
        return "<" + this._hostName + ":" + this._index + ">";
    }
}

