/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class CircularByteBuffer {
    private final ByteBuffer in;
    private final ByteBuffer out;
    private boolean lastOut = true;

    public CircularByteBuffer(int n, boolean bl) {
        this.in = bl ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        this.out = this.in.duplicate();
    }

    public final int remainingIn() {
        int n;
        int n2 = this.in.position();
        if (n2 > (n = this.out.position())) {
            return this.in.capacity() - n2 + n;
        }
        if (n2 < n) {
            return n - n2;
        }
        return this.lastOut ? this.in.capacity() : 0;
    }

    public final int remainingOut() {
        return this.in.capacity() - this.remainingIn();
    }

    public void put(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() > this.remainingIn()) {
            throw new BufferOverflowException();
        }
        if (byteBuffer.remaining() > this.in.remaining()) {
            int n = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + this.in.remaining());
            this.in.put(byteBuffer);
            this.in.rewind();
            byteBuffer.limit(n);
        }
        this.in.put(byteBuffer);
        this.lastOut = false;
    }

    public void put(CircularByteBuffer circularByteBuffer) {
        if (circularByteBuffer.remainingOut() > this.remainingIn()) {
            throw new BufferOverflowException();
        }
        if (this.in.remaining() < circularByteBuffer.remainingOut()) {
            circularByteBuffer.out.limit(this.in.remaining());
            this.in.put(circularByteBuffer.out);
            this.in.rewind();
            circularByteBuffer.out.limit(circularByteBuffer.out.capacity());
        }
        this.in.put(circularByteBuffer.out);
        this.lastOut = false;
    }

    public byte get() {
        if (this.remainingOut() < 1) {
            throw new BufferUnderflowException();
        }
        if (!this.out.hasRemaining()) {
            this.out.rewind();
        }
        this.lastOut = true;
        return this.out.get();
    }

    public void get(byte[] byArray) {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n, int n2) {
        if (this.remainingOut() < n2) {
            throw new BufferUnderflowException();
        }
        if (this.out.remaining() < n2) {
            int n3 = this.out.remaining();
            this.out.get(byArray, n, n3);
            n += n3;
            n2 -= n3;
            this.out.rewind();
        }
        this.out.get(byArray, n, n2);
        this.lastOut = true;
    }

    public void get(ByteBuffer byteBuffer) {
        if (this.remainingOut() < byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.out.remaining() < byteBuffer.remaining()) {
            byteBuffer.put(this.out);
            this.out.rewind();
        }
        byteBuffer.put(this.out);
        this.lastOut = true;
    }

    public int write(WritableByteChannel writableByteChannel) throws IOException {
        int n = 0;
        int n2 = 0;
        while (this.remainingOut() > 0) {
            if (!this.out.hasRemaining()) {
                this.out.rewind();
            }
            if (this.in.position() > this.out.position()) {
                this.out.limit(this.in.position());
            }
            int n3 = this.out.position();
            try {
                n2 = writableByteChannel.write(this.out);
            }
            finally {
                if (this.out.position() > n3) {
                    this.lastOut = true;
                }
            }
            this.out.limit(this.out.capacity());
            if (n2 == 0) break;
            n += n2;
        }
        return n;
    }

    public int read(ReadableByteChannel readableByteChannel) throws IOException {
        int n = 0;
        int n2 = 0;
        while (this.remainingIn() > 0) {
            if (!this.in.hasRemaining()) {
                this.in.rewind();
            }
            if (this.out.position() > this.in.position()) {
                this.in.limit(this.out.position());
            }
            int n3 = this.in.position();
            try {
                n2 = readableByteChannel.read(this.in);
            }
            finally {
                if (this.in.position() > n3) {
                    this.lastOut = false;
                }
            }
            this.in.limit(this.in.capacity());
            if (n2 == 0) break;
            n += n2;
        }
        return n;
    }
}

