/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.downloader.Interval;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IntervalSet {
    private final List intervals = new ArrayList();

    public static IntervalSet createSingletonSet(long l, long l2) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(new Interval(l, l2));
        return intervalSet;
    }

    public void add(Interval interval) {
        int n = interval.low;
        int n2 = interval.high;
        Interval interval2 = null;
        Interval interval3 = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval4 = (Interval)iterator.next();
            if (n <= interval4.low && interval4.high <= n2) {
                iterator.remove();
                continue;
            }
            if (n >= interval4.low && interval4.high >= n2) {
                return;
            }
            if (n <= interval4.high + 1 && interval4.low < n) {
                interval2 = interval4;
            }
            if (interval4.low - 1 <= n2 && interval4.high > n2) {
                interval3 = interval4;
            }
            if (interval3 != null || interval4.low > n2) break;
        }
        if (interval2 == null && interval3 == null) {
            this.addImpl(new Interval(n, n2));
        } else if (interval2 != null && interval3 != null) {
            this.removeImpl(interval3);
            this.removeImpl(interval2);
            this.addImpl(new Interval(interval2.low, interval3.high));
        } else if (interval3 != null) {
            this.removeImpl(interval3);
            this.addImpl(new Interval(n, interval3.high));
        } else {
            this.removeImpl(interval2);
            this.addImpl(new Interval(interval2.low, n2));
        }
    }

    public void add(IntervalSet intervalSet) {
        Iterator iterator = intervalSet.getAllIntervals();
        while (iterator.hasNext()) {
            this.add((Interval)iterator.next());
        }
    }

    public void delete(Interval interval) {
        int n = interval.low;
        int n2 = interval.high;
        Interval interval2 = null;
        Interval interval3 = null;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval4 = (Interval)iterator.next();
            if (interval4.high >= n && interval4.low <= n2) {
                iterator.remove();
                if (interval4.high <= n2) {
                    if (interval4.low >= n) continue;
                    interval2 = new Interval(interval4.low, n - 1);
                    continue;
                }
                if (interval4.low >= n) {
                    interval3 = new Interval(n2 + 1, interval4.high);
                    break;
                }
                interval2 = new Interval(interval4.low, n - 1);
                interval3 = new Interval(n2 + 1, interval4.high);
                break;
            }
            if (interval4.low >= n2) break;
        }
        if (interval2 != null) {
            this.add(interval2);
        }
        if (interval3 != null) {
            this.add(interval3);
        }
    }

    public void delete(IntervalSet intervalSet) {
        Iterator iterator = intervalSet.getAllIntervals();
        while (iterator.hasNext()) {
            this.delete((Interval)iterator.next());
        }
    }

    public Interval getFirst() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (Interval)this.intervals.get(0);
    }

    public Interval getLast() throws NoSuchElementException {
        if (this.intervals.isEmpty()) {
            throw new NoSuchElementException();
        }
        Interval interval = (Interval)this.intervals.get(this.intervals.size() - 1);
        return interval;
    }

    public int getNumberOfIntervals() {
        return this.intervals.size();
    }

    public boolean contains(Interval interval) {
        Iterator iterator = this.getAllIntervals();
        while (iterator.hasNext()) {
            Interval interval2 = (Interval)iterator.next();
            if (interval2.low > interval.low || interval2.high < interval.high) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Interval interval) {
        int n = interval.low;
        int n2 = interval.high;
        Iterator iterator = this.getAllIntervals();
        while (iterator.hasNext()) {
            Interval interval2 = (Interval)iterator.next();
            if (n <= interval2.low && interval2.high <= n2) {
                return true;
            }
            if (n >= interval2.low && interval2.high >= n2) {
                return true;
            }
            if (n <= interval2.high + 1 && interval2.low < n) {
                return true;
            }
            if (interval2.low - 1 > n2 || interval2.high <= n2) continue;
            return true;
        }
        return false;
    }

    public List getOverlapIntervals(Interval interval) {
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        long l = interval.low;
        long l2 = interval.high;
        if (l > l2) {
            return arrayList;
        }
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval2 = (Interval)iterator.next();
            if (l <= (long)interval2.low && (long)interval2.high <= l2) {
                arrayList.add(interval2);
                continue;
            }
            if (l <= (long)interval2.high && (long)interval2.low < l) {
                arrayList.add(new Interval(l, Math.min(l2, (long)interval2.high)));
            }
            if ((long)interval2.low > l2 || (long)interval2.high <= l2) continue;
            arrayList.add(new Interval(Math.max((long)interval2.low, l), l2));
        }
        return arrayList;
    }

    public Iterator getAllIntervals() {
        return this.intervals.iterator();
    }

    public List getAllIntervalsAsList() {
        return new ArrayList(this.intervals);
    }

    public int getSize() {
        int n = 0;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            n += interval.high - interval.low + 1;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public IntervalSet invert(int n) {
        IntervalSet intervalSet = new IntervalSet();
        if (n < 1) {
            return intervalSet;
        }
        if (this.intervals.size() == 0) {
            Interval interval = new Interval(0L, n - 1);
            intervalSet.add(interval);
            return intervalSet;
        }
        int n2 = -1;
        Interval interval = null;
        boolean bl = false;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            interval = (Interval)iterator.next();
            if (interval.low != 0 && n2 < interval.low) {
                if (n2 + 1 > interval.low - 1) {
                    if (!bl) {
                        bl = true;
                        this.fix();
                        iterator = this.intervals.iterator();
                        n2 = -1;
                        interval = null;
                        continue;
                    }
                    throw new IllegalArgumentException("constructing invalid interval  while trying to invert \n" + this.toString() + " \n with size " + n + " low:" + n2 + " interval.low:" + interval.low);
                }
                intervalSet.add(new Interval(n2 + 1, interval.low - 1));
            }
            n2 = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < n - 1) {
            intervalSet.add(new Interval(interval.high + 1, n - 1));
        }
        return intervalSet;
    }

    public Iterator getNeededIntervals(int n) {
        return this.invert(n).getAllIntervals();
    }

    public Object clone() {
        IntervalSet intervalSet = new IntervalSet();
        Iterator iterator = this.getAllIntervals();
        while (iterator.hasNext()) {
            intervalSet.intervals.add(iterator.next());
        }
        return intervalSet;
    }

    private void addImpl(Interval interval) {
        int n = Collections.binarySearch(this.intervals, interval, IntervalComparator.INSTANCE);
        if (n >= 0) {
            throw new IllegalStateException("interval (" + interval + ") already in list: " + this.intervals);
        }
        n = -(n + 1);
        this.intervals.add(n, interval);
    }

    private void removeImpl(Interval interval) {
        int n = Collections.binarySearch(this.intervals, interval, IntervalComparator.INSTANCE);
        if (n < 0) {
            throw new IllegalStateException("interval (" + interval + ") doesn't exist in list: " + this.intervals);
        }
        this.intervals.remove(n);
    }

    public String toString() {
        return this.intervals.toString();
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.intervals.size() * 8];
        int n = 0;
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            interval.toBytes(byArray, n);
            n += 8;
        }
        return byArray;
    }

    public static IntervalSet parseBytes(byte[] byArray) throws IOException {
        if (byArray.length % 8 != 0) {
            throw new IOException();
        }
        IntervalSet intervalSet = new IntervalSet();
        int n = 0;
        while (n < byArray.length / 8) {
            int n2 = (int)ByteOrder.uint2long(ByteOrder.beb2int(byArray, n * 8));
            int n3 = (int)ByteOrder.uint2long(ByteOrder.beb2int(byArray, n * 8 + 4));
            if (n3 < n2 || n3 < 0 || n2 < 0) {
                throw new IOException();
            }
            intervalSet.add(new Interval(n2, n3));
            ++n;
        }
        return intervalSet;
    }

    private void fix() {
        String string = this.intervals.toString();
        ArrayList arrayList = new ArrayList(this.intervals);
        this.intervals.clear();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            this.add((Interval)object.next());
        }
        object = this.intervals.toString();
        Assert.silent(false, "IntervalSet invariants broken.\nPre  Fixing: " + string + "\n" + "Post Fixing: " + (String)object);
    }

    private static class IntervalComparator
    implements Comparator {
        private static final IntervalComparator INSTANCE = new IntervalComparator();

        IntervalComparator() {
        }

        public int compare(Object object, Object object2) {
            Interval interval = (Interval)object;
            Interval interval2 = (Interval)object2;
            if (interval.low > interval2.low) {
                return 1;
            }
            if (interval.low < interval2.low) {
                return -1;
            }
            return 0;
        }
    }
}

