/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MetaDataEditor;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimeXMLReplyCollection {
    private static final Log LOG;
    private final String schemaURI;
    private final Map mainMap;
    private final Map oldMap;
    private final Map trieMap;
    private boolean dirty = false;
    private final File dataFile;
    public static final int NORMAL = 0;
    public static final int FILE_DEFECTIVE = 1;
    public static final int RW_ERROR = 2;
    public static final int BAD_ID3 = 3;
    public static final int FAILED_TITLE = 4;
    public static final int FAILED_ARTIST = 5;
    public static final int FAILED_ALBUM = 6;
    public static final int FAILED_YEAR = 7;
    public static final int FAILED_COMMENT = 8;
    public static final int FAILED_TRACK = 9;
    public static final int FAILED_GENRE = 10;
    public static final int HASH_FAILED = 11;
    public static final int INCORRECT_FILETYPE = 12;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.xml.LimeXMLReplyCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public LimeXMLReplyCollection(String string) {
        this.schemaURI = string;
        this.trieMap = new HashMap();
        this.dataFile = new File(LimeXMLProperties.instance().getXMLDocsDir(), String.valueOf(LimeXMLSchema.getDisplayString(this.schemaURI)) + ".sxml");
        this.mainMap = new HashMap();
        this.oldMap = this.readMapFromDisk();
    }

    LimeXMLDocument initialize(FileDesc fileDesc, List list) {
        URN uRN = fileDesc.getSHA1Urn();
        LimeXMLDocument limeXMLDocument = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LimeXMLDocument limeXMLDocument2 = (LimeXMLDocument)iterator.next();
            if (!limeXMLDocument2.getSchemaURI().equals(this.schemaURI)) continue;
            limeXMLDocument = limeXMLDocument2;
            break;
        }
        if (limeXMLDocument == null) {
            limeXMLDocument = (LimeXMLDocument)this.oldMap.get(uRN);
        }
        if (limeXMLDocument != null && (limeXMLDocument = this.validate(limeXMLDocument, fileDesc.getFile(), fileDesc)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding old document for file: " + fileDesc.getFile() + ", doc: " + limeXMLDocument));
            }
            this.addReply(fileDesc, limeXMLDocument);
        }
        return limeXMLDocument;
    }

    LimeXMLDocument createIfNecessary(FileDesc fileDesc) {
        LimeXMLDocument limeXMLDocument = null;
        URN uRN = fileDesc.getSHA1Urn();
        if (!this.mainMap.containsKey(uRN)) {
            File file = fileDesc.getFile();
            if (!(fileDesc.getLimeXMLDocuments().size() != 0 && LimeXMLUtils.isSupportedMultipleFormat(file) || (limeXMLDocument = this.constructDocument(file)) == null)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding newly constructed document for file: " + file + ", doc: " + limeXMLDocument));
                }
                this.addReply(fileDesc, limeXMLDocument);
            }
        }
        return limeXMLDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFinished() {
        Map map = this.mainMap;
        synchronized (map) {
            if (this.oldMap.equals(this.mainMap)) {
                this.dirty = false;
            }
            this.oldMap.clear();
        }
    }

    private LimeXMLDocument validate(LimeXMLDocument limeXMLDocument, File file, FileDesc fileDesc) {
        if (!limeXMLDocument.isCurrent()) {
            LimeXMLDocument limeXMLDocument2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("reconstructing old document: " + file));
            }
            if ((limeXMLDocument2 = this.constructDocument(file)) != null) {
                limeXMLDocument = this.update(limeXMLDocument, limeXMLDocument2);
            } else {
                limeXMLDocument.setCurrent();
            }
        }
        if (!limeXMLDocument.isValid() && (limeXMLDocument = this.constructDocument(file)) == null) {
            return null;
        }
        if (AudioMetaData.isCorrupted(limeXMLDocument)) {
            limeXMLDocument = AudioMetaData.fixCorruption(limeXMLDocument);
            this.mediaFileToDisk(fileDesc, file.getPath(), limeXMLDocument, false);
        }
        return limeXMLDocument;
    }

    private LimeXMLDocument update(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        Object object;
        HashMap hashMap = new HashMap();
        Object object2 = limeXMLDocument2.getNameValueSet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            hashMap.put(object.getKey(), object.getValue());
        }
        object2 = limeXMLDocument.getNameValueSet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            if (hashMap.containsKey(object.getKey())) continue;
            hashMap.put(object.getKey(), object.getValue());
        }
        object2 = new ArrayList(hashMap.size());
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            object2.add(new NameValue((String)entry.getKey(), entry.getValue()));
        }
        return new LimeXMLDocument((Collection)object2, limeXMLDocument2.getSchemaURI());
    }

    private LimeXMLDocument constructDocument(File file) {
        if (LimeXMLUtils.isSupportedFormatForSchema(file, this.schemaURI)) {
            try {
                LimeXMLDocument limeXMLDocument = MetaDataReader.readDocument(file);
                if (limeXMLDocument.getSchemaURI().equals(this.schemaURI)) {
                    return limeXMLDocument;
                }
            }
            catch (IOException iOException) {
                LOG.warn((Object)"Error creating document", (Throwable)iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getKeyWords() {
        ArrayList arrayList = new ArrayList();
        Map map = this.mainMap;
        synchronized (map) {
            Iterator iterator = this.mainMap.values().iterator();
            while (iterator.hasNext()) {
                LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator.next();
                arrayList.addAll(limeXMLDocument.getKeyWords());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getKeyWordsIndivisible() {
        ArrayList arrayList = new ArrayList();
        Map map = this.mainMap;
        synchronized (map) {
            Iterator iterator = this.mainMap.values().iterator();
            while (iterator.hasNext()) {
                LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator.next();
                arrayList.addAll(limeXMLDocument.getKeyWordsIndivisible());
            }
        }
        return arrayList;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument limeXMLDocument) {
        Map map = this.mainMap;
        synchronized (map) {
            Iterator iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                LinkedList<LimeXMLDocument> linkedList;
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                String string2 = I18NConvert.instance().getNorm((String)entry.getValue());
                Trie trie = (Trie)this.trieMap.get(string);
                if (trie == null) {
                    trie = new Trie(true);
                    this.trieMap.put(string, trie);
                }
                if ((linkedList = (LinkedList<LimeXMLDocument>)trie.get(string2)) == null) {
                    linkedList = new LinkedList<LimeXMLDocument>();
                    trie.add(string2, linkedList);
                }
                linkedList.add(limeXMLDocument);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument limeXMLDocument) {
        Map map = this.mainMap;
        synchronized (map) {
            Iterator iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                String string;
                List list;
                Map.Entry entry = (Map.Entry)iterator.next();
                String string2 = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(string2);
                if (trie == null || (list = (List)trie.get(string = I18NConvert.instance().getNorm((String)entry.getValue()))) == null) continue;
                list.remove(limeXMLDocument);
                if (list.size() != 0) continue;
                trie.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fileDesc, LimeXMLDocument limeXMLDocument) {
        URN uRN = fileDesc.getSHA1Urn();
        Map map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            this.mainMap.put(uRN, limeXMLDocument);
            this.addKeywords(limeXMLDocument);
        }
        fileDesc.addLimeXMLDocument(limeXMLDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Map map = this.mainMap;
        synchronized (map) {
            return this.mainMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument getDocForHash(URN uRN) {
        Map map = this.mainMap;
        synchronized (map) {
            return (LimeXMLDocument)this.mainMap.get(uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getMatchingReplies(LimeXMLDocument limeXMLDocument) {
        Object object;
        Iterator iterator;
        HashSet hashSet = null;
        Object object2 = this.mainMap;
        synchronized (object2) {
            iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                String string;
                Iterator iterator2;
                object = (Map.Entry)iterator.next();
                String string2 = (String)object.getKey();
                Trie trie = (Trie)this.trieMap.get(string2);
                if (trie == null || !(iterator2 = trie.getPrefixedBy(string = (String)object.getValue())).hasNext()) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                while (iterator2.hasNext()) {
                    List list = (List)iterator2.next();
                    hashSet.addAll(list);
                }
            }
        }
        if (hashSet == null || hashSet.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        object2 = null;
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (LimeXMLDocument)iterator.next();
            if (!LimeXMLUtils.match((LimeXMLDocument)object, limeXMLDocument, false)) continue;
            if (object2 == null) {
                object2 = new LinkedList();
            }
            object2.add(object);
        }
        if (object2 == null || object2.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fileDesc, LimeXMLDocument limeXMLDocument) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Replacing doc in FD (" + fileDesc + ") with new doc (" + limeXMLDocument + ")"));
        }
        LimeXMLDocument limeXMLDocument2 = null;
        URN uRN = fileDesc.getSHA1Urn();
        Map map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            limeXMLDocument2 = this.mainMap.put(uRN, limeXMLDocument);
            if (limeXMLDocument2 == null) {
                Assert.that(false, "attempted to replace doc that did not exist!!");
            }
            this.removeKeywords(limeXMLDocument2);
            this.addKeywords(limeXMLDocument);
        }
        fileDesc.replaceLimeXMLDocument(limeXMLDocument2, limeXMLDocument);
        return limeXMLDocument2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fileDesc) {
        LimeXMLDocument limeXMLDocument;
        Map map = this.mainMap;
        synchronized (map) {
            limeXMLDocument = (LimeXMLDocument)this.mainMap.remove(fileDesc.getSHA1Urn());
            if (limeXMLDocument != null) {
                this.dirty = true;
            }
        }
        if (limeXMLDocument != null) {
            fileDesc.removeLimeXMLDocument(limeXMLDocument);
            this.removeKeywords(limeXMLDocument);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removed: " + limeXMLDocument));
        }
        return limeXMLDocument != null;
    }

    public int mediaFileToDisk(FileDesc fileDesc, String string, LimeXMLDocument limeXMLDocument, boolean bl) {
        MetaDataEditor metaDataEditor;
        int n = -1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("writing: " + string + " to disk."));
        }
        if ((metaDataEditor = this.getEditorIfNeeded(string, limeXMLDocument, bl)) != null) {
            if (metaDataEditor.getCorrectDocument() == null) {
                n = this.commitMetaData(string, metaDataEditor);
            } else {
                this.removeDoc(fileDesc);
                this.addReply(fileDesc, metaDataEditor.getCorrectDocument());
                n = 0;
            }
        }
        Assert.that(n != 12, "trying to write data to unwritable file");
        return n;
    }

    private MetaDataEditor getEditorIfNeeded(String string, LimeXMLDocument limeXMLDocument, boolean bl) {
        MetaDataEditor metaDataEditor = MetaDataEditor.getEditorForFile(string);
        if (metaDataEditor == null) {
            return null;
        }
        metaDataEditor.populate(limeXMLDocument);
        MetaDataEditor metaDataEditor2 = MetaDataEditor.getEditorForFile(string);
        LimeXMLDocument limeXMLDocument2 = null;
        try {
            limeXMLDocument2 = MetaDataReader.readDocument(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
        metaDataEditor2.populate(limeXMLDocument2);
        if (metaDataEditor.equals(metaDataEditor2)) {
            LOG.debug((Object)"tag read from disk is same as XML doc.");
            return null;
        }
        if (bl) {
            if (metaDataEditor2.betterThan(metaDataEditor)) {
                LOG.debug((Object)"Data on disk is better, using disk data.");
                metaDataEditor2.setCorrectDocument(limeXMLDocument2);
                return metaDataEditor2;
            }
            LOG.debug((Object)"Retrieving better fields from disk.");
            metaDataEditor.pickBetterFields(metaDataEditor2);
        }
        return metaDataEditor;
    }

    private int commitMetaData(String string, MetaDataEditor metaDataEditor) {
        int n = metaDataEditor.commitMetaData(string);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wrote data: " + n));
        }
        if (n == 1 || n == 2 || n == 3 || n == 12) {
            return n;
        }
        RouterService.getFileManager().fileChanged(new File(string));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMapToDisk() {
        boolean bl = false;
        Map map = this.mainMap;
        synchronized (map) {
            block9: {
                if (this.dirty) break block9;
                return true;
            }
            ObjectOutputStream objectOutputStream = null;
            try {
                try {
                    objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile)));
                    objectOutputStream.writeObject(this.mainMap);
                    objectOutputStream.flush();
                    bl = true;
                }
                catch (Throwable throwable) {
                    LOG.trace((Object)"Unable to write", throwable);
                }
            }
            finally {
                IOUtils.close(objectOutputStream);
            }
            this.dirty = false;
        }
        return bl;
    }

    private Map readMapFromDisk() {
        ConverterObjectInputStream converterObjectInputStream = null;
        Map map = null;
        try {
            try {
                converterObjectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(this.dataFile)));
                map = (Map)converterObjectInputStream.readObject();
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Unable to read LimeXMLCollection", throwable);
            }
        }
        finally {
            IOUtils.close(converterObjectInputStream);
        }
        return map == null ? new HashMap() : map;
    }
}

