/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.IpPortImpl;
import java.net.UnknownHostException;

public class IpPortContentAuthority
implements ContentAuthority {
    private IpPort authority;
    private String host;
    private int port;

    public IpPortContentAuthority(IpPort ipPort) {
        this.authority = ipPort;
        this.host = ipPort.getAddress();
        this.port = ipPort.getPort();
    }

    public IpPortContentAuthority(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public void send(Message message) {
        UDPService.instance().send(message, this.authority);
    }

    public boolean initialize() {
        if (this.authority == null) {
            try {
                this.authority = new IpPortImpl(this.host, this.port);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        return true;
    }

    public IpPort getIpPort() {
        return this.authority;
    }
}

