/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.DefaultBootstrapServers;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BootstrapServerManager {
    private static final Log LOG;
    private static final BootstrapServerManager INSTANCE;
    public static final int CACHE_OFF = 0;
    public static final int FETCH_SCHEDULED = 1;
    public static final int FETCH_IN_PROGRESS = 2;
    public static final int FETCHED_TOO_MANY = 3;
    public static final int NO_CACHES_LEFT = 4;
    private static final int MAX_RESPONSES = 50;
    private static final int MAX_CACHES = 5;
    private static final int ENDPOINTS_TO_ADD = 10;
    private static final int MAX_BOOTSTRAP_SERVERS = 1000;
    public static int MAX_HOSTS_PER_REQUEST;
    public static int UPDATE_DELAY_MSEC;
    private final List SERVERS = new ArrayList();
    private BootstrapServer _lastConnectable;
    private Random _rand = new Random();
    private volatile boolean _hostFetchInProgress = false;
    private volatile int _lastIndex = 0;
    private volatile int _responsesAdded = 0;
    private boolean dirty = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.bootstrap.BootstrapServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        INSTANCE = new BootstrapServerManager();
        MAX_HOSTS_PER_REQUEST = 20;
        UPDATE_DELAY_MSEC = 3600000;
    }

    public static BootstrapServerManager instance() {
        return INSTANCE;
    }

    protected BootstrapServerManager() {
    }

    public synchronized void addBootstrapServer(BootstrapServer bootstrapServer) {
        if (bootstrapServer == null) {
            throw new NullPointerException("null bootstrap server not allowed");
        }
        if (!this.SERVERS.contains(bootstrapServer)) {
            this.dirty = true;
            this.SERVERS.add(bootstrapServer);
        }
        if (this.SERVERS.size() > 1000) {
            this.removeServer((BootstrapServer)this.SERVERS.get(0));
        }
    }

    public synchronized void bootstrapServersAdded() {
        this.addDefaultsIfNeeded();
        Collections.shuffle(this.SERVERS);
    }

    public synchronized void resetData() {
        this._lastIndex = 0;
        this._responsesAdded = 0;
        Collections.shuffle(this.SERVERS);
    }

    public boolean isEndpointFetchInProgress() {
        return this._hostFetchInProgress;
    }

    public synchronized void write(FileWriter fileWriter) throws IOException {
        Iterator iterator = this.getBootstrapServers();
        while (iterator.hasNext()) {
            BootstrapServer bootstrapServer = (BootstrapServer)iterator.next();
            fileWriter.write(bootstrapServer.toString());
            fileWriter.write("\n");
        }
        this.dirty = false;
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized Iterator getBootstrapServers() {
        return this.SERVERS.iterator();
    }

    public synchronized void fetchBootstrapServersAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return;
        }
        this.addDefaultsIfNeeded();
        this.requestAsync(new UrlfileRequest(), "GWebCache urlfile");
    }

    public synchronized int fetchEndpointsAsync() {
        if (!ConnectionSettings.USE_GWEBCACHE.getValue()) {
            return 0;
        }
        this.addDefaultsIfNeeded();
        if (!this._hostFetchInProgress) {
            if (this._responsesAdded >= 50 && this._lastIndex >= 5) {
                return 3;
            }
            if (this._lastIndex >= this.size()) {
                return 4;
            }
            this._hostFetchInProgress = true;
            this.requestAsync(new HostfileRequest(), "GWebCache hostfile");
            return 1;
        }
        return 2;
    }

    public synchronized void sendUpdatesAsync(Endpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("cannot accept null update IP");
        }
        this.addDefaultsIfNeeded();
        try {
            if (!NetworkUtils.isPrivateAddress(endpoint.getHostBytes())) {
                this.requestAsync(new UpdateRequest(endpoint), "GWebCache update");
            }
        }
        catch (UnknownHostException unknownHostException) {}
    }

    private void addDefaultsIfNeeded() {
        if (this.SERVERS.size() > 0) {
            return;
        }
        DefaultBootstrapServers.addDefaults(this);
        Collections.shuffle(this.SERVERS);
    }

    private void requestAsync(final GWebCacheRequest gWebCacheRequest, String string) {
        if (gWebCacheRequest == null) {
            throw new NullPointerException("asynchronous request to null cache");
        }
        ThreadFactory.startThread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    BootstrapServerManager.this.requestBlocking(gWebCacheRequest);
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    gWebCacheRequest.done();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    gWebCacheRequest.done();
                    return;
                }
            }
        }, string);
    }

    private void requestBlocking(GWebCacheRequest gWebCacheRequest) {
        if (gWebCacheRequest == null) {
            throw new NullPointerException("blocking request to null cache");
        }
        int n = 0;
        while (gWebCacheRequest.needsMoreData() && n < MAX_HOSTS_PER_REQUEST) {
            BootstrapServer bootstrapServer = gWebCacheRequest.nextServer();
            if (bootstrapServer == null) break;
            this.requestFromOneHost(gWebCacheRequest, bootstrapServer);
            ++n;
        }
    }

    /*
     * Exception decompiling
     */
    private void requestFromOneHost(GWebCacheRequest var1_1, BootstrapServer var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 589->593)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized int size() {
        return this.SERVERS.size();
    }

    protected int randomServer() {
        return this._rand.nextInt(this.SERVERS.size());
    }

    protected synchronized void removeServer(BootstrapServer bootstrapServer) {
        this.dirty = true;
        this.SERVERS.remove(bootstrapServer);
        this._lastIndex = Math.max(0, this._lastIndex - 1);
    }

    private abstract class GWebCacheRequest {
        GWebCacheRequest() {
        }

        protected abstract String parameters();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleError(BootstrapServer bootstrapServer) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Error on server: " + bootstrapServer));
            }
            BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
            synchronized (bootstrapServerManager) {
                BootstrapServerManager.this.removeServer(bootstrapServer);
                if (BootstrapServerManager.this._lastConnectable == bootstrapServer) {
                    BootstrapServerManager.this._lastConnectable = null;
                }
            }
        }

        protected abstract boolean handleResponseData(BootstrapServer var1, String var2);

        protected abstract boolean needsMoreData();

        protected abstract BootstrapServer nextServer();

        protected void done() {
        }
    }

    private final class HostfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        HostfileRequest() {
        }

        protected String parameters() {
            return "hostfile=1";
        }

        protected boolean handleResponseData(BootstrapServer bootstrapServer, String string) {
            try {
                Endpoint endpoint = new Endpoint(string, true);
                RouterService.getHostCatcher().add(endpoint, 2);
                ++this.responses;
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                bootstrapServerManager._responsesAdded = bootstrapServerManager._responsesAdded + 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleError(bootstrapServer);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected void done() {
            BootstrapServerManager.this._hostFetchInProgress = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BootstrapServer nextServer() {
            BootstrapServer bootstrapServer = null;
            HostfileRequest hostfileRequest = this;
            synchronized (hostfileRequest) {
                if (BootstrapServerManager.this._lastIndex >= BootstrapServerManager.this.SERVERS.size()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Used up all servers, last: " + BootstrapServerManager.this._lastIndex));
                    }
                } else {
                    bootstrapServer = (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this._lastIndex);
                    BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                    bootstrapServerManager._lastIndex = bootstrapServerManager._lastIndex + 1;
                }
            }
            return bootstrapServer;
        }

        public String toString() {
            return "hostfile request";
        }
    }

    private final class UrlfileRequest
    extends GWebCacheRequest {
        private int responses = 0;

        UrlfileRequest() {
        }

        protected String parameters() {
            return "urlfile=1";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleResponseData(BootstrapServer bootstrapServer, String string) {
            try {
                BootstrapServer bootstrapServer2 = new BootstrapServer(string);
                BootstrapServerManager bootstrapServerManager = BootstrapServerManager.this;
                synchronized (bootstrapServerManager) {
                    BootstrapServerManager.this.addBootstrapServer(bootstrapServer2);
                }
                ++this.responses;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added bootstrap host: " + bootstrapServer2));
                }
                ConnectionSettings.LAST_GWEBCACHE_FETCH_TIME.setValue(System.currentTimeMillis());
            }
            catch (ParseException parseException) {
                this.handleError(bootstrapServer);
                return false;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return this.responses < 10;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "urlfile request";
        }
    }

    private final class UpdateRequest
    extends GWebCacheRequest {
        private boolean gotResponse = false;
        private Endpoint myIP;

        protected UpdateRequest(Endpoint endpoint) {
            this.myIP = endpoint;
        }

        protected String parameters() {
            String string = null;
            if (BootstrapServerManager.this._lastConnectable != null) {
                string = "url=" + URLEncoder.encode(BootstrapServerManager.this._lastConnectable.getURLString());
            }
            String string2 = null;
            if (this.myIP != null) {
                string2 = "ip=" + this.myIP.getAddress() + ":" + this.myIP.getPort();
            }
            if (string == null && string2 == null) {
                return "";
            }
            if (string != null && string2 == null) {
                return string;
            }
            if (string == null && string2 != null) {
                return string2;
            }
            Assert.that(string != null && string2 != null);
            return String.valueOf(string2) + "&" + string;
        }

        protected boolean handleResponseData(BootstrapServer bootstrapServer, String string) {
            if (StringUtils.startsWithIgnoreCase(string, "OK")) {
                this.gotResponse = true;
            }
            return true;
        }

        protected boolean needsMoreData() {
            return !this.gotResponse;
        }

        protected BootstrapServer nextServer() {
            if (BootstrapServerManager.this.SERVERS.size() == 0) {
                return null;
            }
            return (BootstrapServer)BootstrapServerManager.this.SERVERS.get(BootstrapServerManager.this.randomServer());
        }

        public String toString() {
            return "update request";
        }
    }
}

