/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageReceiver;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MessageReader
implements ChannelReadObserver {
    private static final long MAX_MESSAGE_SIZE = 65536L;
    private static final int HEADER_SIZE = 23;
    private static final int PAYLOAD_LENGTH_OFFSET = 19;
    private static final ByteBuffer EMPTY_PAYLOAD = ByteBuffer.allocate(0);
    private final ByteBuffer header;
    private ByteBuffer payload;
    private final MessageReceiver receiver;
    private InterestReadChannel channel;
    private boolean shutdown = false;

    public MessageReader(MessageReceiver messageReceiver) {
        this(null, messageReceiver);
    }

    public MessageReader(InterestReadChannel interestReadChannel, MessageReceiver messageReceiver) {
        if (messageReceiver == null) {
            throw new NullPointerException("null receiver");
        }
        this.channel = interestReadChannel;
        this.receiver = messageReceiver;
        this.header = ByteBuffer.allocate(23);
        this.header.order(ByteOrder.LITTLE_ENDIAN);
        this.payload = null;
    }

    public void setReadChannel(InterestReadChannel interestReadChannel) {
        if (interestReadChannel == null) {
            throw new NullPointerException("cannot set null channel!");
        }
        this.channel = interestReadChannel;
    }

    public InterestReadChannel getReadChannel() {
        return this.channel;
    }

    public void handleRead() throws IOException {
        while (true) {
            int n = 0;
            while (this.header.hasRemaining() && (n = this.channel.read(this.header)) > 0) {
            }
            if (this.header.hasRemaining()) {
                if (n != -1) break;
                throw new IOException("EOF");
            }
            if (this.payload == null) {
                int n2 = this.header.getInt(19);
                if (n2 < 0 || (long)n2 > 65536L) {
                    throw new IOException("should i implement skipping?");
                }
                if (n2 == 0) {
                    this.payload = EMPTY_PAYLOAD;
                } else {
                    try {
                        this.payload = ByteBuffer.allocate(n2);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("message too large.");
                    }
                }
            }
            while (this.payload.hasRemaining() && (n = this.channel.read(this.payload)) > 0) {
            }
            if (this.payload.hasRemaining()) {
                if (n != -1) break;
                throw new IOException("eof");
            }
            try {
                Message message = MessageFactory.createMessage(this.header.array(), this.payload.array(), this.receiver.getSoftMax(), this.receiver.getNetwork());
                this.receiver.processReadMessage(message);
            }
            catch (BadPacketException badPacketException) {}
            if (n == -1) {
                throw new IOException("eof");
            }
            this.payload = null;
            this.header.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        MessageReader messageReader = this;
        synchronized (messageReader) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        this.receiver.messagingClosed();
    }

    public void handleIOException(IOException iOException) {
        throw new RuntimeException("unsupported operation", iOException);
    }
}

