/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadState;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.io.IOStateObserver;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.statistics.NumericalDownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.Sockets;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker {
    private static final Log LOG;
    private static final int MIN_SPLIT_SIZE = 16384;
    private static final float MIN_ACCEPTABLE_SPEED;
    private static final int UNKNOWN_SPEED = -1;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 20000;
    private static final int UDP_PUSH_CONNECT_TIME = 6000;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    public static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    private final ManagedDownloader _manager;
    private final RemoteFileDesc _rfd;
    private final VerifyingFile _commonOutFile;
    private volatile boolean _interrupted;
    private volatile HTTPDownloader _downloader;
    private volatile boolean _shouldRelease;
    private final String _workerName;
    private DirectConnector _connectObserver;
    private DownloadState _currentState;
    private volatile boolean _stealing;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.DownloadWorker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    }

    DownloadWorker(ManagedDownloader managedDownloader, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile) {
        this._manager = managedDownloader;
        this._rfd = remoteFileDesc;
        this._commonOutFile = verifyingFile;
        this._currentState = new DownloadState();
        this._workerName = LOG.isDebugEnabled() ? "DownloadWorker for " + this._manager.getSaveFile().getName() + " #" + System.identityHashCode(this) : "DownloaderWorker";
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting worker: " + this._workerName));
        }
        this.establishConnection();
    }

    private void initializeAlternateLocations() {
        AlternateLocation alternateLocation;
        int n = 0;
        Iterator iterator = this._manager.getValidAlts().iterator();
        while (iterator.hasNext() && n < 10) {
            alternateLocation = (AlternateLocation)iterator.next();
            this._downloader.addSuccessfulAltLoc(alternateLocation);
            ++n;
        }
        n = 0;
        iterator = this._manager.getInvalidAlts().iterator();
        while (iterator.hasNext() && n < 10) {
            alternateLocation = (AlternateLocation)iterator.next();
            this._downloader.addFailedAltLoc(alternateLocation);
            ++n;
        }
    }

    private void httpLoop() {
        LOG.debug((Object)"Starting HTTP Loop");
        this.incrementState(null);
    }

    public void incrementState(ConnectionStatus connectionStatus) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("WORKER: " + this + ", State Changed, Current: " + this._currentState + ", status: " + connectionStatus));
        }
        if (this._interrupted) {
            this.finishHttpLoop();
            return;
        }
        switch (this._currentState.getCurrentState()) {
            case 6: {
                this.releaseRanges();
            }
            case 0: 
            case 5: {
                this._currentState.setHttp11(this._rfd.isHTTP11());
                this._currentState.setState(1);
                if (this.requestTHEXIfNeeded()) break;
            }
            case 1: {
                this._currentState.setState(2);
                if (this.downloadThexIfNeeded()) break;
            }
            case 2: {
                this._currentState.setState(3);
                if (this.consumeBodyIfNeeded()) break;
            }
            case 3: {
                this._downloader.forgetRanges();
                if (connectionStatus == null || !connectionStatus.isQueued()) {
                    this._currentState.setState(4);
                    if (this.assignAndRequest()) break;
                    this.finishHttpLoop();
                    break;
                }
            }
            case 4: {
                this.httpRequestFinished(connectionStatus);
                break;
            }
            default: {
                throw new IllegalStateException("bad state: " + this._currentState);
            }
        }
    }

    private boolean consumeBodyIfNeeded() {
        if (this._downloader.isBodyConsumed()) {
            LOG.debug((Object)"Not consuming body.");
            return false;
        }
        this._downloader.consumeBody(new State(){

            protected void handleState(boolean bl) {
                if (!bl) {
                    DownloadWorker.this.handleRFDFailure(DownloadWorker.this._rfd);
                }
            }
        });
        return true;
    }

    private void handleRFDFailure(RemoteFileDesc remoteFileDesc) {
        this._rfd.incrementFailedCount();
        if (this._rfd.getFailedCount() < 2) {
            this._rfd.setRetryAfter(60);
            this._manager.addRFD(this._rfd);
        } else {
            this._manager.informMesh(this._rfd, false);
        }
    }

    private void httpRequestFinished(ConnectionStatus connectionStatus) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HTTP req finished, status: " + connectionStatus));
        }
        this._manager.addPossibleSources(this._downloader.getLocationsReceived());
        if (connectionStatus.isNoData() || connectionStatus.isNoFile()) {
            this.finishHttpLoop();
        } else {
            if (!connectionStatus.isConnected()) {
                this.releaseRanges();
            }
            if (!connectionStatus.isQueued()) {
                this._manager.removeQueuedWorker(this);
            }
            if (connectionStatus.isPartialData()) {
                this._currentState.setState(0);
                this.incrementState(null);
            } else {
                Assert.that(connectionStatus.isQueued() || connectionStatus.isConnected());
                boolean bl = this._manager.killQueuedIfNecessary(this, !connectionStatus.isQueued() ? -1 : connectionStatus.getQueuePosition());
                if (connectionStatus.isConnected()) {
                    this._currentState.setState(6);
                    this.beginDownload();
                } else if (!bl) {
                    this.finishHttpLoop();
                } else {
                    this.handleQueued(connectionStatus);
                }
            }
        }
    }

    private void beginDownload() {
        try {
            this._downloader.doDownload(new State(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleState(boolean bl) {
                    if (bl) {
                        DownloadWorker.this._rfd.resetFailedCount();
                        if (DownloadWorker.this._currentState.isHttp11()) {
                            DownloadStat.SUCCESSFUL_HTTP11.incrementStat();
                        } else {
                            DownloadStat.SUCCESSFUL_HTTP10.incrementStat();
                        }
                    } else {
                        if (DownloadWorker.this._currentState.isHttp11()) {
                            DownloadStat.FAILED_HTTP11.incrementStat();
                        } else {
                            DownloadStat.FAILED_HTTP10.incrementStat();
                        }
                        DownloadWorker.this._manager.workerFailed(DownloadWorker.this);
                    }
                    if (DownloadWorker.this._commonOutFile.isHopeless()) {
                        DownloadWorker.this._manager.promptAboutCorruptDownload();
                    }
                    int n = DownloadWorker.this._downloader.getInitialReadingPoint() + DownloadWorker.this._downloader.getAmountRead();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: terminating from " + DownloadWorker.this._downloader + " at " + n + " error? " + !bl));
                    }
                    ManagedDownloader managedDownloader = DownloadWorker.this._manager;
                    synchronized (managedDownloader) {
                        if (!bl) {
                            DownloadWorker.this._downloader.stop();
                            DownloadWorker.this.handleRFDFailure(DownloadWorker.this._rfd);
                        } else {
                            DownloadWorker.this._manager.informMesh(DownloadWorker.this._rfd, true);
                            if (!DownloadWorker.this._currentState.isHttp11()) {
                                DownloadWorker.this._manager.addRFD(DownloadWorker.this._rfd);
                            }
                        }
                    }
                }
            });
        }
        catch (SocketException socketException) {
            this.finishHttpLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestTHEXIfNeeded() {
        boolean bl = false;
        VerifyingFile verifyingFile = this._commonOutFile;
        synchronized (verifyingFile) {
            if (!this._commonOutFile.isHashTreeRequested()) {
                HashTree hashTree = this._commonOutFile.getHashTree();
                boolean bl2 = bl = this._downloader.hasHashTree() && this._manager.getSHA1Urn() != null && (hashTree == null || !hashTree.isDepthGoodEnough());
                if (bl) {
                    this._commonOutFile.setHashTreeRequested(true);
                }
            }
        }
        if (bl) {
            this._downloader.requestHashTree(this._manager.getSHA1Urn(), new State(){

                protected void handleState(boolean bl) {
                }
            });
        }
        return bl;
    }

    private boolean downloadThexIfNeeded() {
        if (!this._downloader.isRequestingThex()) {
            return false;
        }
        ConnectionStatus connectionStatus = this._downloader.parseThexResponseHeaders();
        if (!connectionStatus.isConnected()) {
            this._rfd.setTHEXFailed();
            this.incrementState(connectionStatus);
        } else {
            this._manager.removeQueuedWorker(this);
            this._downloader.downloadThexBody(this._manager.getSHA1Urn(), new State(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleState(boolean bl) {
                    VerifyingFile verifyingFile = DownloadWorker.this._commonOutFile;
                    synchronized (verifyingFile) {
                        HashTree hashTree;
                        DownloadWorker.this._commonOutFile.setHashTreeRequested(false);
                        HashTree hashTree2 = DownloadWorker.this._downloader.getHashTree();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Downloaded tree: " + hashTree2));
                        }
                        if (hashTree2 != null && hashTree2.isBetterTree(hashTree = DownloadWorker.this._commonOutFile.getHashTree())) {
                            DownloadWorker.this._commonOutFile.setHashTree(hashTree2);
                        }
                    }
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRanges() {
        int n;
        int n2;
        HTTPDownloader hTTPDownloader;
        if (!this._shouldRelease) {
            return;
        }
        this._shouldRelease = false;
        if (this._commonOutFile.isComplete()) {
            return;
        }
        HTTPDownloader hTTPDownloader2 = hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader2) {
            n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
            n2 = Math.max(n2, hTTPDownloader.getInitialWritingPoint());
            n = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead() - 1;
        }
        if (n - n2 >= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("releasing ranges " + new Interval(n2, n)));
            }
            this._commonOutFile.releaseBlock(new Interval(n2, n));
            hTTPDownloader.forgetRanges();
        } else {
            LOG.debug((Object)"nothing to release!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueued(ConnectionStatus connectionStatus) {
        this._manager.removeActiveWorker(this);
        DownloadState downloadState = this._currentState;
        synchronized (downloadState) {
            if (this._interrupted) {
                LOG.debug((Object)"Exiting from queueing");
                return;
            }
            LOG.debug((Object)"Queueing");
            this._currentState.setState(5);
        }
        RouterService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.debug((Object)"Queue time up");
                DownloadState downloadState = DownloadWorker.this._currentState;
                synchronized (downloadState) {
                    if (DownloadWorker.this._interrupted) {
                        LOG.warn((Object)("WORKER: interrupted while waiting in queue " + DownloadWorker.this._downloader));
                        return;
                    }
                }
                NIODispatcher.instance().invokeLater(new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$0(this.this$1).incrementState(null);
                    }
                });
            }

            static /* synthetic */ DownloadWorker access$0(5 var0) {
                return var0.DownloadWorker.this;
            }
        }, connectionStatus.getQueuePollTime(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("establishConnection(" + this._rfd + ")"));
        }
        if (this._manager.isCancelled() || this._manager.isPaused()) {
            this._manager.addRFD(this._rfd);
            this._manager.workerFinished(this);
            return;
        }
        boolean bl = this._rfd.needsPush();
        ManagedDownloader managedDownloader = this._manager;
        synchronized (managedDownloader) {
            int n = this._manager.getState();
            if (this._manager.getNumDownloaders() == 0 && n != 4 && n != 5 && n != 6 && n != 7 && n != 9 && n != 11 && n != 12) {
                if (this._interrupted) {
                    return;
                }
                this._manager.setState(1, bl ? 20000 : 10000);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: attempting connect to " + this._rfd.getHost() + ":" + this._rfd.getPort()));
        }
        DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        if (this._rfd.isReplyToMulticast()) {
            this.connectWithPush(new PushConnector(false, true));
        } else if (!bl) {
            this.connectDirectly(new DirectConnector(true));
        } else {
            this.connectWithPush(new PushConnector(true, false));
        }
    }

    private boolean finishConnect() {
        if (this._downloader == null) {
            this._manager.informMesh(this._rfd, false);
            return false;
        }
        if (this._interrupted) {
            this._downloader.stop();
            this._downloader = null;
            return false;
        }
        return true;
    }

    private void connectDirectly(DirectConnector directConnector) {
        if (!this._interrupted) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WORKER: attempt asynchronous direct connection to: " + this._rfd));
            }
            this._connectObserver = directConnector;
            try {
                Socket socket = Sockets.connect(this._rfd.getHost(), this._rfd.getPort(), 10000, directConnector);
                if (!directConnector.isShutdown()) {
                    directConnector.setSocket(socket);
                }
            }
            catch (IOException iOException) {
                directConnector.shutdown();
            }
        } else {
            this._manager.workerFinished(this);
        }
    }

    private void connectWithPush(PushConnector pushConnector) {
        if (!this._interrupted) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WORKER: attempt push connection to: " + this._rfd));
            }
            this._connectObserver = null;
            final PushDetails pushDetails = new PushDetails(this._rfd.getClientGUID(), this._rfd.getHost());
            pushConnector.setPushDetails(pushDetails);
            this._manager.registerPushObserver(pushConnector, pushDetails);
            RouterService.getDownloadManager().sendPush(this._rfd, pushConnector);
            RouterService.schedule(new Runnable(){

                public void run() {
                    DownloadWorker.this._manager.unregisterPushObserver(pushDetails, true);
                }
            }, this._rfd.isFromAlternateLocation() ? 6000 : 20000, 0L);
        } else {
            this._manager.workerFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInfo() {
        if (this._downloader != null) {
            HTTPDownloader hTTPDownloader = this._downloader;
            synchronized (hTTPDownloader) {
                return this + "hashcode " + System.identityHashCode(this._downloader) + " will release? " + this._shouldRelease + " interrupted? " + this._interrupted + " active? " + this._downloader.isActive() + " victim? " + this._downloader.isVictim() + " initial reading " + this._downloader.getInitialReadingPoint() + " initial writing " + this._downloader.getInitialWritingPoint() + " amount to read " + this._downloader.getAmountToRead() + " amount read " + this._downloader.getAmountRead() + " is in stealing " + this.isStealing() + "\n";
            }
        }
        return "worker not started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean assignAndRequest() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("assignAndRequest for: " + this._rfd));
        }
        Interval interval = null;
        VerifyingFile verifyingFile = this._commonOutFile;
        synchronized (verifyingFile) {
            if (this._commonOutFile.hasFreeBlocksToAssign() > 0) {
                try {
                    interval = this.pickAvailableInterval();
                }
                catch (NoSuchRangeException noSuchRangeException) {
                    this.handleNoRanges();
                    return false;
                }
            }
        }
        if (interval == null) {
            if (this.assignGrey()) return true;
            return false;
        } else {
            this.assignWhite(interval);
        }
        return true;
    }

    private void completeAssignAndRequest(IOException iOException, Interval interval, DownloadWorker downloadWorker) {
        ConnectionStatus connectionStatus = this.completeAssignAndRequestImpl(iOException, interval, downloadWorker);
        if (downloadWorker != null) {
            downloadWorker.setStealing(false);
            this.setStealing(false);
        }
        this.incrementState(connectionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectionStatus completeAssignAndRequestImpl(IOException iOException, Interval interval, DownloadWorker downloadWorker) {
        ManagedDownloader managedDownloader;
        try {
            block22: {
                try {
                    this._downloader.parseHeaders();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (iOException == null) throw throwable;
                    throw iOException;
                }
                {
                    managedDownloader = null;
                    if (iOException == null) break block22;
                }
                throw iOException;
            }
            if (downloadWorker == null) {
                this.completeAssignWhite(interval);
            } else {
                this.completeAssignGrey(downloadWorker, interval);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            DownloadStat.NSE_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)noSuchElementException);
            return this.handleNoMoreDownloaders();
        }
        catch (NoSuchRangeException noSuchRangeException) {
            LOG.debug((Object)this._downloader, (Throwable)noSuchRangeException);
            return this.handleNoRanges();
        }
        catch (TryAgainLaterException tryAgainLaterException) {
            DownloadStat.TAL_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)tryAgainLaterException);
            return this.handleTryAgainLater();
        }
        catch (RangeNotAvailableException rangeNotAvailableException) {
            DownloadStat.RNA_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)rangeNotAvailableException);
            return this.handleRangeNotAvailable();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DownloadStat.FNF_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)fileNotFoundException);
            return this.handleFileNotFound();
        }
        catch (NotSharingException notSharingException) {
            DownloadStat.NS_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)notSharingException);
            return this.handleNotSharing();
        }
        catch (QueuedException queuedException) {
            DownloadStat.Q_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)queuedException);
            return this.handleQueued(queuedException.getQueuePosition(), queuedException.getMinPollTime());
        }
        catch (ProblemReadingHeaderException problemReadingHeaderException) {
            DownloadStat.PRH_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)problemReadingHeaderException);
            return this.handleProblemReadingHeader();
        }
        catch (UnknownCodeException unknownCodeException) {
            DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)unknownCodeException);
            return this.handleUnknownCode();
        }
        catch (ContentUrnMismatchException contentUrnMismatchException) {
            DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)contentUrnMismatchException);
            return ConnectionStatus.getNoFile();
        }
        catch (IOException iOException2) {
            DownloadStat.IO_EXCEPTION.incrementStat();
            LOG.debug((Object)this._downloader, (Throwable)iOException2);
            return this.handleIO();
        }
        DownloadStat.RESPONSE_OK.incrementStat();
        if (this._rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        this._rfd.resetFailedCount();
        managedDownloader = this._manager;
        synchronized (managedDownloader) {
            if (!(this._manager.isCancelled() || this._manager.isPaused() || this._interrupted)) {
                this._manager.workerStarted(this);
                return ConnectionStatus.getConnected();
            }
            LOG.trace((Object)"Stopped in assignAndRequest");
            this._manager.addRFD(this._rfd);
            return ConnectionStatus.getNoData();
        }
    }

    private void assignWhite(Interval interval) {
        final int n = interval.low;
        final int n2 = interval.high;
        this._shouldRelease = true;
        this._downloader.connectHTTP(n, n2 + 1, true, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, new Interval(n, n2), null);
            }

            public void handleIOException(IOException iOException) {
                DownloadWorker.this.completeAssignAndRequest(iOException, null, null);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignWhite(Interval interval) {
        HTTPDownloader hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader) {
            int n = interval.low;
            int n2 = interval.high;
            int n3 = this._downloader.getInitialReadingPoint();
            int n4 = this._downloader.getAmountToRead() - 1 + n3;
            if (n4 - n3 >= 0) {
                if (n3 > n) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: Host gave subrange, different low.  Was: " + n + ", is now: " + n3));
                    }
                    this._commonOutFile.releaseBlock(new Interval(n, n3 - 1));
                }
                if (n4 < n2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: Host gave subrange, different high.  Was: " + n2 + ", is now: " + n4));
                    }
                    this._commonOutFile.releaseBlock(new Interval(n4 + 1, n2));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WORKER: assigning white " + n3 + "-" + n4 + " to " + this._downloader));
                }
            } else {
                LOG.debug((Object)"debouched at birth");
            }
        }
    }

    private Interval pickAvailableInterval() throws NoSuchRangeException {
        Interval interval = null;
        if (!this._downloader.getRemoteFileDesc().isPartialSource()) {
            interval = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(this.findChunkSize()) : this._commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet intervalSet = this._downloader.getRemoteFileDesc().getAvailableRanges();
                interval = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(intervalSet, this.findChunkSize()) : this._commonOutFile.leaseWhite(intervalSet);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NoSuchRangeException();
            }
        }
        return interval;
    }

    private int findChunkSize() {
        int n = this._commonOutFile.getChunkSize();
        int n2 = this._commonOutFile.hasFreeBlocksToAssign();
        if (n2 <= n && this._manager.getActiveWorkers().size() > 1) {
            n = Math.max(16384, n2 / 2);
        }
        return n;
    }

    private boolean assignGrey() {
        if (this._downloader.getRemoteFileDesc().isPartialSource()) {
            this.handleNoRanges();
            return false;
        }
        final DownloadWorker downloadWorker = this.findSlowestDownloader();
        if (downloadWorker == null) {
            LOG.debug((Object)"didn't find anybody to steal from");
            this.handleNoMoreDownloaders();
            return false;
        }
        final Interval interval = downloadWorker.getDownloadInterval();
        if (interval.low == interval.high) {
            this.handleNoMoreDownloaders();
            return false;
        }
        downloadWorker.setStealing(true);
        this.setStealing(true);
        this._downloader.connectHTTP(interval.low, interval.high, false, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, interval, downloadWorker);
            }

            public void handleIOException(IOException iOException) {
                DownloadWorker.this.completeAssignAndRequest(iOException, null, downloadWorker);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, downloadWorker);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignGrey(DownloadWorker downloadWorker, Interval interval) throws IOException {
        int n;
        HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
        synchronized (hTTPDownloader) {
            if (!downloadWorker.getDownloader().isActive()) {
                LOG.debug((Object)"victim is no longer active");
                throw new NoSuchElementException();
            }
            Interval interval2 = downloadWorker.getDownloadInterval();
            if (interval2.high != interval.high) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("victim is now downloading something else " + interval2 + " vs. " + interval));
                }
                throw new NoSuchElementException();
            }
            if (interval2.low > interval.low && LOG.isDebugEnabled()) {
                LOG.debug((Object)("victim managed to download " + (interval2.low - interval.low) + " bytes while stealer was connecting"));
            }
            int n2 = this._downloader.getInitialReadingPoint();
            int n3 = this._downloader.getAmountToRead() + n2;
            if (n3 < interval.high) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WORKER: not stealing because stealer gave a subrange.  Expected low: " + interval.low + ", high: " + interval.high + ".  Was low: " + n2 + ", high: " + n3));
                }
                throw new IOException();
            }
            n = Math.max(interval2.low, n2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: picking stolen grey " + n + "-" + interval.high + " from [" + downloadWorker + "] to [" + this + "]"));
            }
            downloadWorker.getDownloader().stopAt(n);
        }
        this._downloader.startAt(n);
        this._shouldRelease = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Interval getDownloadInterval() {
        HTTPDownloader hTTPDownloader;
        HTTPDownloader hTTPDownloader2 = hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader2) {
            int n = Math.max(hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead(), hTTPDownloader.getInitialWritingPoint());
            int n2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead();
            return new Interval(n, n2);
        }
    }

    private void setStealing(boolean bl) {
        this._stealing = bl;
    }

    boolean isStealing() {
        return this._stealing;
    }

    private DownloadWorker findSlowestDownloader() {
        float f;
        DownloadWorker downloadWorker = null;
        float f2 = f = this.getOurSpeed();
        Set set = this._manager.getQueuedWorkers().keySet();
        Iterator iterator = this._manager.getAllWorkers().iterator();
        while (iterator.hasNext()) {
            HTTPDownloader hTTPDownloader;
            DownloadWorker downloadWorker2 = (DownloadWorker)iterator.next();
            if (downloadWorker2.isStealing() || set.contains(downloadWorker2) || (hTTPDownloader = downloadWorker2.getDownloader()) == null || hTTPDownloader == this._downloader) continue;
            if (f == -1.0f) {
                if (!downloadWorker2.isSlow()) continue;
                return downloadWorker2;
            }
            float f3 = 0.0f;
            try {
                hTTPDownloader.getMeasuredBandwidth();
                f3 = hTTPDownloader.getAverageBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f3 = Math.max(0.0f, f - 0.1f);
            }
            if (!(f3 < f2)) continue;
            f2 = f3;
            downloadWorker = downloadWorker2;
        }
        return downloadWorker;
    }

    private float getOurSpeed() {
        if (this._downloader == null) {
            return -1.0f;
        }
        try {
            this._downloader.getMeasuredBandwidth();
            return this._downloader.getAverageBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return -1.0f;
        }
    }

    boolean isSlow() {
        float f = this.getOurSpeed();
        return f < MIN_ACCEPTABLE_SPEED && f != -1.0f;
    }

    private ConnectionStatus handleNoMoreDownloaders() {
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoData();
    }

    private ConnectionStatus handleNoRanges() {
        this._rfd.setAvailableRanges(null);
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(300);
        }
        this._rfd.resetFailedCount();
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleTryAgainLater() {
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(60);
        }
        if (!this._manager.getActiveWorkers().isEmpty() && this._rfd.getWaitTime(System.currentTimeMillis()) < 600) {
            this._rfd.setRetryAfter(600);
        }
        this._manager.addRFD(this._rfd);
        this._rfd.resetFailedCount();
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleRangeNotAvailable() {
        this._rfd.resetFailedCount();
        this._manager.informMesh(this._rfd, true);
        return ConnectionStatus.getPartialData();
    }

    private ConnectionStatus handleFileNotFound() {
        this._manager.informMesh(this._rfd, false);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleNotSharing() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleQueued(int n, int n2) {
        if (this._manager.getActiveWorkers().isEmpty()) {
            if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted) {
                return ConnectionStatus.getNoData();
            }
            this._manager.setState(10);
        }
        this._rfd.resetFailedCount();
        return ConnectionStatus.getQueued(n, n2);
    }

    private ConnectionStatus handleProblemReadingHeader() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleUnknownCode() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleIO() {
        this.handleRFDFailure(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        Object object = this._currentState;
        synchronized (object) {
            this._interrupted = true;
            if (this._currentState.getCurrentState() == 5) {
                this.finishHttpLoop();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping while state is: " + this._currentState + ", this: " + this.toString()));
        }
        if (this._downloader != null) {
            this._downloader.stop();
        }
        if ((object = this._connectObserver) != null) {
            if (Sockets.removeConnectObserver(this._connectObserver)) {
                this._manager.workerFinished(this);
            } else if (((DirectConnector)object).getSocket() != null) {
                IOUtils.close(((DirectConnector)object).getSocket());
            }
        }
    }

    public RemoteFileDesc getRFD() {
        return this._rfd;
    }

    HTTPDownloader getDownloader() {
        return this._downloader;
    }

    public String toString() {
        return String.valueOf(this._workerName) + "[" + this._currentState + "] -> " + this._rfd;
    }

    private void startDownload(HTTPDownloader hTTPDownloader) {
        this._downloader = hTTPDownloader;
        if (this.finishConnect()) {
            LOG.trace((Object)"Starting download");
            this.initializeAlternateLocations();
            this.httpLoop();
        } else {
            this._manager.workerFinished(this);
        }
    }

    private void finishHttpLoop() {
        this.releaseRanges();
        this._manager.removeQueuedWorker(this);
        this._downloader.stop();
        this._manager.workerFinished(this);
    }

    private abstract class State
    implements IOStateObserver {
        State() {
        }

        public final void handleIOException(IOException iOException) {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        public final void handleStatesFinished() {
            this.handleState(true);
            DownloadWorker.this.incrementState(null);
        }

        public final void shutdown() {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        protected abstract void handleState(boolean var1);
    }

    private class PushConnector
    extends HTTPConnectObserver {
        private boolean forgetOnFailure;
        private boolean directConnectOnFailure;
        private PushDetails pushDetails;

        PushConnector(boolean bl, boolean bl2) {
            this.forgetOnFailure = bl;
            this.directConnectOnFailure = bl2;
        }

        public void handleConnect(Socket socket) {
            HTTPDownloader hTTPDownloader = new HTTPDownloader(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, false);
            try {
                hTTPDownloader.connectTCP(0);
                DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
            }
            catch (IOException iOException) {
                DownloadStat.PUSH_FAILURE_LOST.incrementStat();
                this.failed();
                return;
            }
            DownloadWorker.this.startDownload(hTTPDownloader);
        }

        public void shutdown() {
            DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
            this.failed();
        }

        void setPushDetails(PushDetails pushDetails) {
            this.pushDetails = pushDetails;
        }

        private void failed() {
            DownloadWorker.this._manager.unregisterPushObserver(this.pushDetails, false);
            if (!this.directConnectOnFailure) {
                if (this.forgetOnFailure) {
                    DownloadWorker.this._manager.forgetRFD(DownloadWorker.this._rfd);
                }
                DownloadWorker.this.finishConnect();
                DownloadWorker.this._manager.workerFinished(DownloadWorker.this);
            } else {
                DownloadWorker.this.connectDirectly(new DirectConnector(false));
            }
        }
    }

    private class DirectConnector
    extends HTTPConnectObserver {
        private long createTime = System.currentTimeMillis();
        private boolean pushConnectOnFailure;
        private Socket connectingSocket;
        private boolean shutdown;

        DirectConnector(boolean bl) {
            this.pushConnectOnFailure = bl;
        }

        public void handleConnect(Socket socket) {
            this.connectingSocket = null;
            NumericalDownloadStat.TCP_CONNECT_TIME.addData((int)(System.currentTimeMillis() - this.createTime));
            DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
            HTTPDownloader hTTPDownloader = new HTTPDownloader(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, false);
            try {
                hTTPDownloader.connectTCP(0);
            }
            catch (IOException iOException) {
                this.shutdown();
                return;
            }
            DownloadWorker.this.startDownload(hTTPDownloader);
        }

        public void shutdown() {
            this.shutdown = true;
            this.connectingSocket = null;
            DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            if (this.pushConnectOnFailure) {
                DownloadWorker.this.connectWithPush(new PushConnector(false, false));
            } else {
                DownloadWorker.this.finishConnect();
                DownloadWorker.this._manager.workerFinished(DownloadWorker.this);
            }
        }

        void setSocket(Socket socket) {
            this.connectingSocket = socket;
        }

        Socket getSocket() {
            return this.connectingSocket;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }
}

