/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.ChannelReader;
import com.limegroup.gnutella.io.ChannelWriter;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.Future;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.InterruptedIOException;
import com.limegroup.gnutella.io.NBSocket;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.NIOInputStream;
import com.limegroup.gnutella.io.NIOMultiplexor;
import com.limegroup.gnutella.io.NIOOutputStream;
import com.limegroup.gnutella.io.NoOpReader;
import com.limegroup.gnutella.io.NoOpWriter;
import com.limegroup.gnutella.io.ReadObserver;
import com.limegroup.gnutella.io.ReadTimeout;
import com.limegroup.gnutella.io.ReadWriteObserver;
import com.limegroup.gnutella.io.SoTimeout;
import com.limegroup.gnutella.io.ThrottleListener;
import com.limegroup.gnutella.io.WriteObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNBSocket
extends NBSocket
implements ConnectObserver,
ReadWriteObserver,
NIOMultiplexor,
ReadTimeout,
SoTimeout {
    private static final Log LOG;
    private final Object LOCK = new Object();
    protected ReadObserver reader;
    protected WriteObserver writer;
    protected volatile ConnectObserver connecter;
    private boolean shutdown = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.AbstractNBSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    protected abstract InterestReadChannel getBaseReadChannel();

    protected abstract InterestWriteChannel getBaseWriteChannel();

    protected abstract void shutdownImpl();

    public final void setInitialReader() {
        this.reader = new NIOInputStream(this, this, this.getBaseReadChannel());
    }

    public final void setInitialWriter() {
        this.writer = new NIOOutputStream(this, this.getBaseWriteChannel());
    }

    public final void setReadObserver(final ChannelReadObserver channelReadObserver) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                ReadObserver readObserver = AbstractNBSocket.this.reader;
                try {
                    AbstractNBSocket.this.reader = channelReadObserver;
                    ChannelReader channelReader = channelReadObserver;
                    while (channelReader.getReadChannel() instanceof ChannelReader) {
                        channelReader = (ChannelReader)((Object)channelReader.getReadChannel());
                    }
                    if (readObserver instanceof InterestReadChannel && readObserver != channelReadObserver) {
                        if (channelReader instanceof ThrottleListener) {
                            ((ThrottleListener)((Object)channelReader)).setAttachment(AbstractNBSocket.this);
                        }
                        channelReader.setReadChannel((InterestReadChannel)((Object)readObserver));
                        AbstractNBSocket.this.reader.handleRead();
                        readObserver.shutdown();
                    }
                    InterestReadChannel interestReadChannel = AbstractNBSocket.this.getBaseReadChannel();
                    channelReader.setReadChannel(interestReadChannel);
                    NIODispatcher.instance().interestRead(AbstractNBSocket.this.getChannel(), true);
                }
                catch (IOException iOException) {
                    AbstractNBSocket.this.shutdown();
                    readObserver.shutdown();
                }
            }
        });
    }

    public final void setWriteObserver(final ChannelWriter channelWriter) {
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                try {
                    if (AbstractNBSocket.this.writer.handleWrite()) {
                        throw new IllegalStateException("data still in old writer!");
                    }
                    AbstractNBSocket.this.writer.shutdown();
                    ChannelWriter channelWriter2 = channelWriter;
                    while (channelWriter2.getWriteChannel() instanceof ChannelWriter) {
                        if (!((channelWriter2 = (ChannelWriter)((Object)channelWriter2.getWriteChannel())) instanceof ThrottleListener)) continue;
                        ((ThrottleListener)((Object)channelWriter2)).setAttachment(AbstractNBSocket.this);
                    }
                    InterestWriteChannel interestWriteChannel = AbstractNBSocket.this.getBaseWriteChannel();
                    AbstractNBSocket.this.writer = interestWriteChannel;
                    channelWriter2.setWriteChannel(interestWriteChannel);
                }
                catch (IOException iOException) {
                    AbstractNBSocket.this.shutdown();
                    channelWriter.shutdown();
                }
            }
        });
    }

    public final void handleConnect(Socket socket) throws IOException {
        ConnectObserver connectObserver = this.connecter;
        this.connecter = null;
        connectObserver.handleConnect(this);
    }

    public final void handleRead() throws IOException {
        this.reader.handleRead();
    }

    public final boolean handleWrite() throws IOException {
        return this.writer.handleWrite();
    }

    public final void close() {
        this.shutdown();
    }

    public final void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(SocketAddress socketAddress, int n) throws IOException {
        BlockingConnecter blockingConnecter;
        BlockingConnecter blockingConnecter2 = blockingConnecter = new BlockingConnecter();
        synchronized (blockingConnecter2) {
            if (!this.connect(socketAddress, n, blockingConnecter)) {
                long l = System.currentTimeMillis();
                try {
                    blockingConnecter.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.shutdown();
                    throw new InterruptedIOException(interruptedException);
                }
                if (!this.isConnected()) {
                    this.shutdown();
                    long l2 = System.currentTimeMillis();
                    if (n != 0 && l2 - l >= (long)n) {
                        throw new SocketTimeoutException("operation timed out (" + n + ")");
                    }
                    throw new ConnectException("Unable to connect!");
                }
            }
        }
    }

    public boolean connect(SocketAddress socketAddress, int n, ConnectObserver connectObserver) {
        this.connecter = connectObserver;
        try {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (inetSocketAddress.isUnresolved()) {
                throw new IOException("unresolved: " + socketAddress);
            }
            if (this.getChannel().connect(socketAddress)) {
                connectObserver.handleConnect(this);
                return true;
            }
            NIODispatcher.instance().registerConnect(this.getChannel(), this, n);
            return false;
        }
        catch (IOException iOException) {
            NIODispatcher.instance().invokeReallyLater(new Runnable(){

                public void run() {
                    AbstractNBSocket.this.shutdown();
                }
            });
            return false;
        }
    }

    public final InputStream getInputStream() throws IOException {
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        if (this.reader instanceof NIOInputStream) {
            InputStream inputStream = ((NIOInputStream)this.reader).getInputStream();
            NIODispatcher.instance().interestRead(this.getChannel(), true);
            return inputStream;
        }
        Future future = new Future(){
            private Object result;

            public void run() {
                try {
                    NIOInputStream nIOInputStream = new NIOInputStream(AbstractNBSocket.this, AbstractNBSocket.this, null).init();
                    AbstractNBSocket.this.setReadObserver(nIOInputStream);
                    this.result = nIOInputStream.getInputStream();
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOXed after creation", (Throwable)iOException);
                }
            }

            public Object getResult() {
                return this.result;
            }
        };
        try {
            NIODispatcher.instance().invokeAndWait(future);
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new IOException().initCause(interruptedException);
        }
        InputStream inputStream = (InputStream)future.getResult();
        if (inputStream == null) {
            throw new IOException("error constructing InputStream");
        }
        return inputStream;
    }

    public final OutputStream getOutputStream() throws IOException {
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        if (this.writer instanceof NIOOutputStream) {
            return ((NIOOutputStream)this.writer).getOutputStream();
        }
        throw new IllegalStateException("writer not NIOOutputStream!");
    }

    public final long getReadTimeout() {
        if (this.reader instanceof NIOInputStream) {
            return 0L;
        }
        try {
            return this.getSoTimeout();
        }
        catch (SocketException socketException) {
            return 0L;
        }
    }

    public final void handleIOException(IOException iOException) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Shutting down socket & streams for: " + this));
        }
        this.shutdownImpl();
        try {
            this.getChannel().close();
        }
        catch (IOException iOException) {}
        this.reader.shutdown();
        this.writer.shutdown();
        if (this.connecter != null) {
            this.connecter.shutdown();
        }
        NIODispatcher.instance().invokeLater(new Runnable(){

            public void run() {
                AbstractNBSocket.this.reader = new NoOpReader();
                AbstractNBSocket.this.writer = new NoOpWriter();
                AbstractNBSocket.this.connecter = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.shutdown;
        }
    }

    private static class BlockingConnecter
    implements ConnectObserver {
        BlockingConnecter() {
        }

        public synchronized void handleConnect(Socket socket) {
            this.notify();
        }

        public synchronized void shutdown() {
            this.notify();
        }

        public void handleIOException(IOException iOException) {
        }
    }
}

